/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.listener.MapperAndContextAwareNotifyListenersObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.hint.HubToHubHint;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.HubFromType;
import com.deutscheboerse.m7.trading.api.v6.HubToHubAtcData;
import com.deutscheboerse.m7.trading.api.v6.HubToHubNtf;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubToHubNtfNotifyListenerObjectHandler
extends MapperAndContextAwareNotifyListenersObjectHandler<HubToHubNtf> {
    private static final Logger LOG = LoggerFactory.getLogger(HubToHubNtfNotifyListenerObjectHandler.class);
    private volatile boolean hubToHubLoadingFinished = false;
    private Set<HubToHub> hubToHubBuffer = new HashSet<HubToHub>();

    public HubToHubNtfNotifyListenerObjectHandler(BroadcastListenerHandlerForClass broadcastHandler, ApplicationContext appContext, MapperHandler mappers) {
        super(broadcastHandler, appContext, mappers);
        this.appContext.getService(EventBus.class).register(this);
    }

    @Override
    public Collection<HubToHub> unpack(HubToHubNtf hubToHubNtf, Exchange exchange, String correlationId) {
        if (!hubToHubNtf.getHubToHubAtcList().isEmpty()) {
            for (HubToHubAtcData hubToHubAtcData : hubToHubNtf.getHubToHubAtcList()) {
                HubToHubHint hubToHubHint = new HubToHubHint(hubToHubAtcData.getDlvryStart(), hubToHubAtcData.getDlvryEnd(), hubToHubAtcData.getTimestmp());
                for (HubFromType hubFrom : hubToHubAtcData.getHubFrom()) {
                    hubToHubHint.setFromMA(hubFrom.getFrm());
                    hubToHubHint.setAtcDirection(HubToHubHint.AtcDirection.IN);
                    this.hubToHubBuffer.addAll(this.mappers.translateList(HubToHub.class, hubFrom.getAtc(), hubToHubHint));
                    hubToHubHint.setAtcDirection(HubToHubHint.AtcDirection.OUT);
                    this.hubToHubBuffer.addAll(this.mappers.translateList(HubToHub.class, hubFrom.getAtc(), hubToHubHint));
                }
            }
            if (this.hubToHubLoadingFinished) {
                HashSet<HubToHub> allData = new HashSet<HubToHub>(this.hubToHubBuffer);
                this.hubToHubBuffer.clear();
                return allData;
            }
        }
        return Collections.emptySet();
    }

    @Subscribe
    public void handleEntityLoadingStarted(EntityLoadingStartedEvent<?> entityLoadingStartedEvent) {
        if (entityLoadingStartedEvent.getEntityClass().equals(HubToHub.class)) {
            this.hubToHubLoadingFinished = false;
            this.hubToHubBuffer.clear();
        }
    }

    @Subscribe
    public void handleEntityLoadingFinished(EntityLoadingFinishedEvent<?> entityLoadingFinishedEvent) {
        if (entityLoadingFinishedEvent.getEntityClass().equals(HubToHub.class)) {
            this.hubToHubLoadingFinished = true;
            LOG.info("Buffered data after finished loading: {}", (Object)this.hubToHubBuffer.size());
        }
    }

    @Subscribe
    public void handleLogoutEvent(LogoutEvent event) {
        this.appContext.getService(EventBus.class).unregister(this);
    }
}

