/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.listener.MapperAndContextAwareNotifyListenersObjectHandler;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.MbrVolumeType;
import com.deutscheboerse.m7.trading.api.v6.OrdrLmtRprt;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class OrdrLmtRprtNotifyListenerObjectHandler
extends MapperAndContextAwareNotifyListenersObjectHandler<OrdrLmtRprt> {
    private final SmallFastDataModel<Long, OrderLimit> orderLimitDataModel;

    public OrdrLmtRprtNotifyListenerObjectHandler(BroadcastListenerHandlerForClass broadcastHandler, ApplicationContext appContext, MapperHandler mappers) {
        super(broadcastHandler, appContext, mappers);
        this.orderLimitDataModel = appContext.getSmallDataModel(OrderLimit.class);
    }

    @Override
    public Collection<? extends BroadcastEntity> unpack(OrdrLmtRprt ordrLmtRprt, Exchange exchange, String correlationId) {
        HashSet<OrderLimit> orderLimits = new HashSet<OrderLimit>();
        List<MbrVolumeType> mbr = ordrLmtRprt.getMbrList().getMbr();
        for (MbrVolumeType mbrVolumeType : mbr) {
            orderLimits.addAll(this.mappers.translateList(OrderLimit.class, mbrVolumeType.getOrdrLmtList().getOrdrLmt(), mbrVolumeType));
        }
        return orderLimits;
    }

    @Override
    public ObjectHandler.Result handleObject(Session session, OrdrLmtRprt object, String correlationId) {
        this.orderLimitDataModel.removeAll();
        return super.handleObject(session, object, correlationId);
    }
}

