/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.session.LogoutNotification;
import com.deutscheboerse.comxerv.comtrader.entities.session.LogoutType;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.amqp.NotifyListenersObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.v6.RefDataStateType;
import com.deutscheboerse.m7.trading.api.v6.UserRprt;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class UserRprtObjectHandler
extends NotifyListenersObjectHandler<UserRprt> {
    private final OnBehalfService onBehalfService;
    private final UserAlertService userAlertService;
    private final AbstractComXervExchangeConnection connection;

    public UserRprtObjectHandler(ApplicationContext applicationContext, AbstractComXervExchangeConnection connection) {
        super(connection.getBroadcastHandler());
        this.connection = connection;
        this.onBehalfService = applicationContext.getService(OnBehalfService.class);
        this.userAlertService = applicationContext.getService(UserAlertService.class);
    }

    @Override
    public ObjectHandler.Result handleObject(Session session, UserRprt userRprt, String correlationId) {
        boolean isSuspendedOrDeleted;
        super.handleObject(session, userRprt, correlationId);
        UserRprt.Usr user = userRprt.getUsr();
        boolean isCurrentUser = this.connection.getLoggedInUserId() == user.getUsrId();
        boolean isCurrentOnBehalfUser = Objects.equals(this.onBehalfService.getOnBehalfUserId(), user.getUsrId());
        boolean bl = isSuspendedOrDeleted = user.getState() == RefDataStateType.SUSP || user.getState() == RefDataStateType.DELE;
        if (isCurrentUser) {
            if (isSuspendedOrDeleted) {
                LogoutNotification logoutNotification = new LogoutNotification(session.getRemoteId(), "", LogoutType.EXTERNAL_SUSPENDED);
                this.connection.getBroadcastHandler().notifyListeners(logoutNotification);
            } else {
                this.connection.forceFullDataReload();
            }
        } else if (isCurrentOnBehalfUser) {
            if (isSuspendedOrDeleted) {
                this.showOnBehalfUserSuspendedWarning(userRprt);
                this.onBehalfService.setOnBehalfUser(null);
            } else {
                this.onBehalfService.reloadOnBehalfUser();
            }
        }
        return ObjectHandler.Result.RETAIN;
    }

    @Override
    public Collection<? extends BroadcastEntity> unpack(UserRprt object, Exchange exchange, String correlationId) {
        return Collections.singletonList(this.connection.getMapper().translate(User.class, object));
    }

    private void showOnBehalfUserSuspendedWarning(UserRprt object) {
        String status = object.getUsr().getState() == RefDataStateType.SUSP ? Util.getLabel("commons_suspended") : Util.getLabel("commons_deleted");
        this.userAlertService.showConfirmationDialog(Util.getLabel("onBehalfUserSuspendedHeader", status), Util.getLabel("onBehalfUserSuspendedNotification", status), UserAlertService.Flag.WARNING);
    }
}

