/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.DlvryAreaListEntryType;

public class DeliveryAreaMapper
extends AbstractMapper<DlvryAreaListEntryType, DeliveryArea> {
    public DeliveryAreaMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, DlvryAreaListEntryType.class, DeliveryArea.class);
    }

    @Override
    public DeliveryArea translate(DlvryAreaListEntryType from, MapperHandler mapperHandler, Object hint) {
        DeliveryArea deliveryArea = new DeliveryArea();
        deliveryArea.setId(from.getDlvryAreaId());
        deliveryArea.setStatus(EnumMapper.mapSuspensionDeliveryAreaType(from.getState()));
        if (from.getRemoteState() != null) {
            deliveryArea.setRemoteStatus(EnumMapper.mapSuspensionDeliveryAreaType(from.getRemoteState()));
        }
        deliveryArea.setRevisionNumber(from.getRevisionNo());
        deliveryArea.setMarketAreaId(from.getMktAreaId());
        if (hint != null) {
            deliveryArea.setCorrelationId(hint.toString());
        }
        this.applicationContext.getSmallDataModel(MarketArea.class).getAllEntitiesAsStream().filter(ma -> ma.getMarketAreaId().equals(from.getMktAreaId())).findFirst().ifPresent(deliveryArea::setMarketArea);
        deliveryArea.setName(from.getName());
        deliveryArea.setProductIds(from.getProdName());
        return deliveryArea;
    }
}

