/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EntityNotFoundException;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.HalfTradeMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.LargePersistableDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SystemInfo;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeType;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.TradeListEntryType;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTradeMapper
extends AbstractMapper<TradeListEntryType, FullTrade> {
    private static final Logger LOG = LoggerFactory.getLogger(FullTradeMapper.class);
    private final DataModel<Long, Contract> contractDataModel;
    private final LargePersistableDataModel<Long, FullTrade> fullTradeDataModel;
    private final HalfTradeMapper halfTradeMapper;

    public FullTradeMapper(ApplicationContext context, Exchange exchange) {
        super(context, exchange, TradeListEntryType.class, FullTrade.class);
        this.contractDataModel = context.getDataModel(Contract.class);
        this.fullTradeDataModel = context.getLargeDataModel(FullTrade.class);
        this.halfTradeMapper = new HalfTradeMapper(context);
    }

    @Override
    public FullTrade translate(TradeListEntryType from, MapperHandler mapperHandler, Object hint) {
        try {
            FullTrade trade = null;
            if (from.getSell() == null || from.getBuy() == null) {
                trade = (FullTrade)this.fullTradeDataModel.findById(from.getTradeId());
            }
            if (trade == null) {
                trade = new FullTrade(from.getTradeId());
            } else {
                trade.allHalfTrades().forEach(t -> t.setDirty(false));
            }
            trade.setDecomposed(Optional.ofNullable(from.isDecomposed()).orElse(false));
            trade.setParentTradeId(from.getParentTradeId());
            trade.setRemoteTradeId(from.getRemoteTradeId());
            this.mapTradeListEntryTypeToTrade(from, trade);
            if (from.getBuy() != null && (trade.getBuyHalfTrade() == null || trade.getBuyHalfTrade().getRevisionNumber() < from.getRevisionNo())) {
                trade.setBuyHalfTrade(this.halfTradeMapper.createHalfTrade(from, trade.getTradeInfo(), Direction.BUY));
            }
            if (from.getSell() != null && (trade.getSellHalfTrade() == null || trade.getSellHalfTrade().getRevisionNumber() < from.getRevisionNo())) {
                trade.setSellHalfTrade(this.halfTradeMapper.createHalfTrade(from, trade.getTradeInfo(), Direction.SELL));
            }
            return trade;
        }
        catch (RuntimeException e) {
            LOG.error("Error when mapping trade {}: {}", (Object)from, (Object)e);
            return null;
        }
    }

    private void mapTradeListEntryTypeToTrade(TradeListEntryType from, Trade to) {
        to.setRevisionNumber(from.getRevisionNo());
        Contract contract = this.findContract(from);
        to.setContract(contract);
        Product product = contract.getProduct();
        to.setPrice(product.mapPriceFromBackend(from.getPx()));
        to.setQuantity(product.mapQuantityFromBackend(from.getQty()));
        SystemInfo systemInfo = this.getExchange().getSystemInfo();
        to.setRecallGrantedTime(DateTimeUtils.mapDateToDateTime(from.getRecallGrantedTime(), systemInfo.getTimeZone()));
        to.setRecallRequestedTime(DateTimeUtils.mapDateToDateTime(from.getRecallReqTime(), systemInfo.getTimeZone()));
        to.setRecallLatestProcessTime(DateTimeUtils.mapDateToDateTime(from.getLatestRecallProcessTime(), systemInfo.getTimeZone()));
        to.setTimeStamp(DateTimeUtils.mapDateToDateTime(from.getExecTime(), systemInfo.getTimeZone()));
        to.setTradeState(EnumMapper.mapTradeState(from.getState()));
        to.setTradeType(from.isPreArranged() ? TradeType.PREARRANGED : TradeType.REGULAR);
        to.setContractPhase(EnumMapper.mapContractPhase(from.getContractPhase()));
        to.setSelfTrade(BooleanUtils.isTrue(from.isSelfTrade()));
        to.setRecallRequestor(from.getRecallRequestor());
        to.setLocation(from.getLocation());
    }

    private Contract findContract(TradeListEntryType from) {
        Contract contract = this.contractDataModel.findById(from.getContractId());
        if (contract == null) {
            throw new EntityNotFoundException("The trade %d has unknown contract %d", from.getTradeId(), from.getContractId());
        }
        return contract;
    }
}

