/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.AbstractOrderMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.OrdrExeRestrictionType;
import com.deutscheboerse.m7.trading.api.v6.OrdrModificationType;
import org.apache.commons.lang3.StringUtils;

public class OrderModificationTypeMapper
extends AbstractOrderMapper<Order, OrdrModificationType> {
    public OrderModificationTypeMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, Order.class, OrdrModificationType.class);
    }

    @Override
    public OrdrModificationType translate(Order from, MapperHandler mapperHandler, Object hint) {
        Product product = from.getContract().getProduct();
        OrdrModificationType orderModf = new OrdrModificationType();
        orderModf.setOrdrId((Long)from.getId());
        orderModf.setDisplayQty(product.mapQuantityToBackend(from.getPeakQuantity()));
        orderModf.setPpd(product.mapPriceToBackend(from.getPeakPriceDelta()));
        if (from.getLimitPrice() != null) {
            orderModf.setPx(product.mapPriceToBackend(from.getLimitPrice()));
        }
        if (from.getStopPrice() != null) {
            orderModf.setStopPx(product.mapPriceToBackend(from.getStopPrice()));
        }
        if (from.getRemainingQuantity() != null) {
            orderModf.setQty(product.mapQuantityToBackend(from.getRemainingQuantity()));
        }
        if (from.getExecutionRestriction() != null) {
            orderModf.setOrdrExeRestriction(this.mapExecutionRestriction(from.getExecutionRestriction()));
        } else {
            orderModf.setOrdrExeRestriction(OrdrExeRestrictionType.NON);
        }
        orderModf.setType(this.mapOrderType(from.getOrderType(), from.getContract()));
        if (from.getText() != null) {
            orderModf.setTxt(from.getText());
        }
        if (StringUtils.isNotEmpty(from.getLocation())) {
            orderModf.setLocation(from.getLocation());
        }
        if (from.isMarketBased() != null) {
            orderModf.setMarketBased(from.isMarketBased());
        }
        if (StringUtils.isNotEmpty(from.getContractReference())) {
            orderModf.setContractReference(from.getContractReference());
        }
        if (StringUtils.isNotEmpty(from.getFacilityType())) {
            orderModf.setFacilityType(from.getFacilityType());
        }
        if (from.getUsageFraction() != null) {
            orderModf.setUsageFraction(from.getUsageFraction());
        }
        orderModf.setValidityDate(DateTimeUtils.mapDateTimeToDate(from.getValidityDate()));
        orderModf.setValidityRes(this.mapValidityRestriction(from.getValidityRestriction()));
        orderModf.setClOrdrId(from.getClientOrderId());
        orderModf.setRevisionNo(from.getRevisionNumber());
        if (from.getOpenOrClose() != null) {
            orderModf.setOpenCloseInd(this.mapOpenCloseIndicator(from.getOpenOrClose()));
        }
        orderModf.setAot(from.getAot());
        return orderModf;
    }
}

