/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.core.entity;

import com.deutscheboerse.comxerv.comtrader.core.ExchangeConfigurationLoader;
import com.deutscheboerse.comxerv.comtrader.core.entity.SystemInfo;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exchange
implements DisplayName,
Comparable<Exchange> {
    private static final Logger LOG = LoggerFactory.getLogger(Exchange.class);
    private static final Map<String, Exchange> values = new HashMap<String, Exchange>();
    private final String id;
    private final String marketId;
    private final String apiVersion;
    private final String name;
    private final String customTrustStore;
    private final String customTrustStorePassword;
    private final int contractLookAheadInDays;
    private final boolean supportsCommodityLimit;
    private final boolean supportsLogoutAction;
    private final boolean supportsAuction;
    private final boolean supportsDeliveryAreas;
    private SystemInfo systemInfo = new SystemInfo();

    public static void add(Exchange exchange) {
        if (values.put(exchange.getId(), exchange) != null) {
            throw new IllegalArgumentException("Duplicate exchange ID: " + exchange.getId());
        }
    }

    public static void remove(String exchangeId) {
        values.remove(exchangeId);
    }

    private Exchange(Builder builder) {
        this.id = builder.marketId + builder.apiVersion;
        this.marketId = builder.marketId;
        this.apiVersion = builder.apiVersion;
        this.name = builder.name;
        this.systemInfo = builder.systemInfo;
        this.customTrustStore = builder.customTrustStore;
        this.customTrustStorePassword = builder.customTrustStorePassword;
        this.contractLookAheadInDays = builder.contractLookAheadInDays;
        this.supportsCommodityLimit = builder.supportsCommodityLimit;
        this.supportsLogoutAction = builder.supportsLogoutAction;
        this.supportsAuction = builder.supportsAuction;
        this.supportsDeliveryAreas = builder.supportsDeliveryAreas;
    }

    protected Exchange(Exchange other, SystemInfo systemInfo) {
        this.id = other.id;
        this.marketId = other.marketId;
        this.apiVersion = other.apiVersion;
        this.name = other.name;
        this.customTrustStore = other.customTrustStore;
        this.customTrustStorePassword = other.customTrustStorePassword;
        this.contractLookAheadInDays = other.contractLookAheadInDays;
        this.supportsCommodityLimit = other.supportsCommodityLimit;
        this.supportsLogoutAction = other.supportsLogoutAction;
        this.supportsAuction = other.supportsAuction;
        this.supportsDeliveryAreas = other.supportsDeliveryAreas;
        this.systemInfo = systemInfo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getMarketId() {
        return this.marketId;
    }

    public String getName() {
        return this.name;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public boolean supportsLogoutAction() {
        return this.supportsLogoutAction;
    }

    public boolean supportsCommodityLimit() {
        return this.supportsCommodityLimit;
    }

    public boolean supportsAuction() {
        return this.supportsAuction;
    }

    public boolean supportsDeliveryAreas() {
        return this.supportsDeliveryAreas;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public void updateSystemInfo(SystemInfo systemInfo) {
        if (this.systemInfo != null) {
            LOG.info("System info has been loaded!");
        }
        this.systemInfo = systemInfo;
    }

    public int getContractLookAheadInDays() {
        return this.contractLookAheadInDays;
    }

    public String getCustomTrustStore() {
        return this.customTrustStore;
    }

    public String getCustomTrustStorePassword() {
        return this.customTrustStorePassword;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Exchange other) {
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object o) {
        return o instanceof Exchange && ((Exchange)o).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static Collection<Exchange> values() {
        return values.values();
    }

    public static Exchange get(String strId) {
        Optional<String> id = Optional.of(strId);
        Optional<Exchange> optionalExchange = Optional.ofNullable(values.get(id.get()));
        if (!optionalExchange.isPresent()) {
            optionalExchange = values.values().stream().filter(p -> strId.equals(p.getName())).findFirst();
        }
        if (!optionalExchange.isPresent()) {
            optionalExchange = values.values().stream().filter(p -> strId.equals(p.getMarketId())).findFirst();
        }
        return optionalExchange.orElseThrow(() -> new IllegalArgumentException("Exchange " + strId + " not found."));
    }

    public static Comparator<Exchange> createExchangeNameComparator() {
        return (o1, o2) -> o1.getName().compareTo(o2.getName());
    }

    static {
        ServiceLoader.load(ExchangeConfigurationLoader.class).forEach(ExchangeConfigurationLoader::load);
    }

    public static final class Builder {
        private String marketId;
        private String apiVersion;
        private String name;
        private SystemInfo systemInfo = new SystemInfo();
        private String customTrustStore;
        private String customTrustStorePassword;
        private int contractLookAheadInDays;
        private boolean supportsCommodityLimit;
        private boolean supportsLogoutAction;
        private boolean supportsAuction;
        private boolean supportsDeliveryAreas;

        private Builder() {
        }

        public Builder withMarketId(String marketId) {
            this.marketId = marketId;
            return this;
        }

        public Builder withApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withSystemInfo(SystemInfo systemInfo) {
            this.systemInfo = systemInfo;
            return this;
        }

        public Builder withCustomTrustStore(String customTrustStore) {
            this.customTrustStore = customTrustStore;
            return this;
        }

        public Builder withCustomTrustStorePassword(String customTrustStorePassword) {
            this.customTrustStorePassword = customTrustStorePassword;
            return this;
        }

        public Builder withContractLookAheadInDays(int contractLookAheadInDays) {
            this.contractLookAheadInDays = contractLookAheadInDays;
            return this;
        }

        public Builder withSupportsCommodityLimit(boolean supportsCommodityLimit) {
            this.supportsCommodityLimit = supportsCommodityLimit;
            return this;
        }

        public Builder withSupportsLogoutAction(boolean supportsLogoutAction) {
            this.supportsLogoutAction = supportsLogoutAction;
            return this;
        }

        public Builder withSupportsAuction(boolean supportsAuction) {
            this.supportsAuction = supportsAuction;
            return this;
        }

        public Builder withSupportsDeliveryAreas(boolean supportsDeliveryAreas) {
            this.supportsDeliveryAreas = supportsDeliveryAreas;
            return this;
        }

        public Exchange build() {
            return new Exchange(this);
        }
    }
}

