/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.datamodel.LargePersistableDataModelBase;
import com.deutscheboerse.comxerv.comtrader.datamodel.mapdb.Pair;
import com.deutscheboerse.comxerv.comtrader.datamodel.mapdb.Utils;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import java.util.ArrayList;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiFunction;
import org.joda.time.DateTime;
import org.mapdb.MapModificationListener;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.SerializerLong;

public abstract class AbstractTradeDataModel<T extends Trade>
extends LargePersistableDataModelBase<Long, T> {
    protected final NavigableSet<Pair<Long, Long>> tradeDateIndex = new ConcurrentSkipListSet<Pair<Long, Long>>();
    protected final NavigableSet<Pair<Long, Long>> deliveryDateIndex = new ConcurrentSkipListSet<Pair<Long, Long>>();
    protected final NavigableSet<Pair<Long, Long>> contractIndex = new ConcurrentSkipListSet<Pair<Long, Long>>();
    protected final NavigableSet<Pair<Long, Long>> parentTradeIdIndex = new ConcurrentSkipListSet<Pair<Long, Long>>();

    protected AbstractTradeDataModel(ApplicationContext applicationContext, String mapName, GroupSerializer valueSerializer) {
        super(applicationContext, mapName, new SerializerLong(), valueSerializer);
        ArrayList<MapModificationListener> listeners = new ArrayList<MapModificationListener>();
        listeners.add(this.secondaryKey(this.tradeDateIndex, (key, trade) -> trade.getTimeStamp().getMillis()));
        listeners.add(this.secondaryKey(this.deliveryDateIndex, (key, trade) -> trade.getContract().getDeliveryStart().getMillis()));
        listeners.add(this.secondaryKey(this.deliveryDateIndex, (key, trade) -> trade.getContract().getDeliveryEnd().getMillis() - 1L));
        listeners.add(this.secondaryKey(this.contractIndex, (key, trade) -> (Long)trade.getContract().getId()));
        listeners.add(this.secondaryKey(this.parentTradeIdIndex, (key, trade) -> trade.getParentTradeId()));
        this.init(listeners);
    }

    private MapModificationListener<Long, Trade> secondaryKey(Set<Pair<Long, Long>> secondary, BiFunction<Long, Trade, Long> fun) {
        return (key, oldVal, newVal, triggered) -> {
            if (newVal == null) {
                secondary.remove(Pair.of((Long)fun.apply((Long)key, (Trade)oldVal), key));
            } else if (oldVal == null) {
                secondary.add(Pair.of((Long)fun.apply((Long)key, (Trade)newVal), key));
            } else {
                Long newKey;
                Long oldKey = (Long)fun.apply((Long)key, (Trade)oldVal);
                if (oldKey == (newKey = (Long)fun.apply((Long)key, (Trade)newVal)) || oldKey.equals(newKey)) {
                    return;
                }
                secondary.remove(Pair.of(oldKey, key));
                secondary.add(Pair.of(newKey, key));
            }
        };
    }

    @Override
    public void runCleanup() {
        Exchange exchange;
        Optional any = this.getEntities().values().stream().findAny();
        if (any.isPresent() && (exchange = this.getAppContext().getService(ActiveExchange.class).getActiveExchange().get()) != null) {
            long oldestAllowed = DateTime.now(exchange.getSystemInfo().getTimeZone()).minusDays(exchange.getSystemInfo().getContractStoreTimeInDays()).withTimeAtStartOfDay().getMillis();
            Iterable oldTradeIds = Utils.filter(this.tradeDateIndex, 0L, true, oldestAllowed, false);
            this.removeIds(oldTradeIds);
        }
    }

    public NavigableSet<Pair<Long, Long>> getTradeDateIndex() {
        return this.tradeDateIndex;
    }

    public NavigableSet<Pair<Long, Long>> getDeliveryDateIndex() {
        return this.deliveryDateIndex;
    }

    public NavigableSet<Pair<Long, Long>> getContractIndex() {
        return this.contractIndex;
    }

    public NavigableSet<Pair<Long, Long>> getParentTradeIdIndex() {
        return this.parentTradeIdIndex;
    }
}

