/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.FullTradeDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.mapdb.Pair;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.HalfTradeDataQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.LargeDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.LargeDataModelRangeQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.HalfTradeQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.NavigableSet;
import org.joda.time.DateTime;

@Singleton
class HalfTradeQueriesImpl
implements HalfTradeQueries {
    private final FullTradeDataModel fullTradeDataModel;

    @Inject
    public HalfTradeQueriesImpl(ApplicationContext ctx) {
        this.fullTradeDataModel = (FullTradeDataModel)ctx.getLargeDataModel(FullTrade.class);
    }

    @Override
    public DataQuery<HalfTrade> findByTradingDate(DateTime day) {
        return this.getDayQuery(day, this.fullTradeDataModel.getTradeDateIndex(), true, false);
    }

    @Override
    public DataQuery<HalfTrade> findByDeliveryDate(DateTime day) {
        return this.getDayQuery(day, this.fullTradeDataModel.getDeliveryDateIndex(), false, true);
    }

    @Override
    public DataQuery<HalfTrade> findByParentTradeId(Long parentTradeId) {
        return new HalfTradeDataQuery(new LargeDataModelQuery<Long, FullTrade, Long>(this.fullTradeDataModel::findById, this.fullTradeDataModel.getParentTradeIdIndex(), parentTradeId));
    }

    private DataQuery<HalfTrade> getDayQuery(DateTime day, NavigableSet<Pair<Long, Long>> deliveryDateIndex, boolean lowInclusive, boolean distinct2) {
        LargeDataModelRangeQuery.Interval<Long> interval = LargeDataModelRangeQuery.Interval.of(day.withTimeAtStartOfDay().getMillis(), lowInclusive, day.withTimeAtStartOfDay().plusDays(1).getMillis(), false);
        return new HalfTradeDataQuery(new LargeDataModelRangeQuery<Long, FullTrade, Long>(this.fullTradeDataModel::findById, deliveryDateIndex, interval, distinct2));
    }

    @Override
    public DataQuery<HalfTrade> findByContractDeliveryAreaAndMemberId(Contract contract, DeliveryArea deliveryArea, String memberId) {
        return new HalfTradeDataQuery(new LargeDataModelQuery<Long, FullTrade, Long>(this.fullTradeDataModel::findById, this.fullTradeDataModel.getContractIndex(), (Long)contract.getId()), halfTrade -> ((String)deliveryArea.getId()).equals(halfTrade.getOrder().getDeliveryAreaId()) && memberId.equals(halfTrade.getMemberId()));
    }
}

