/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SortedSmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.TradingLimitQueries;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
class TradingLimitQueriesImpl
implements TradingLimitQueries {
    private final SmallFastDataModel<String, TradingLimit> tradingLimitDataModel;

    @Inject
    public TradingLimitQueriesImpl(ApplicationContext applicationContext) {
        this.tradingLimitDataModel = applicationContext.getSmallDataModel(TradingLimit.class);
    }

    @Override
    public DataQuery<TradingLimit> findByMemberId(String memberId) {
        return new SortedSmallFastDataModelQuery<String, TradingLimit>(this.tradingLimitDataModel, (o1, o2) -> o1.getStartDate().compareTo(o2.getStartDate())).addFilter(EntityFilters.propertyEquals(TradingLimit::getMemberId, memberId));
    }
}

