/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.entities.AtcId;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValueChange;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class HubToHub
extends BroadcastEntity<AtcId>
implements SmallDataModelEntity,
Mergeable<HubToHub> {
    private final ObjectProperty<Long> atc = new SimpleObjectProperty<Long>();
    private final ObjectProperty<ValueChange> trend = new SimpleObjectProperty<ValueChange>();
    private final ObjectProperty<DateTime> timestamp = new SimpleObjectProperty<DateTime>();

    public String getFromMarketAreaId() {
        return ((AtcId)this.getId()).getFromMarketAreaId();
    }

    public String getToMarketAreaId() {
        return ((AtcId)this.getId()).getToMarketAreaId();
    }

    public Interval getDeliveryPeriod() {
        return ((AtcId)this.getId()).getDeliveryPeriod();
    }

    public Long getAtc() {
        return (Long)this.atc.get();
    }

    public DateTime getTimestamp() {
        return (DateTime)this.timestamp.get();
    }

    public ValueChange getTrend() {
        return (ValueChange)((Object)this.trend.get());
    }

    public void setAtc(Long atc) {
        Long prevAtc = this.getAtc();
        this.atc.set(atc);
        if (prevAtc != null && atc != null) {
            if (prevAtc < atc) {
                this.setTrend(ValueChange.UP);
            } else if (prevAtc > atc) {
                this.setTrend(ValueChange.DOWN);
            } else {
                this.setTrend(ValueChange.SAME);
            }
        } else {
            this.setTrend(ValueChange.SAME);
        }
    }

    public void setTrend(ValueChange atcTrend) {
        this.trend.set(atcTrend);
    }

    public void setTimestamp(DateTime timestamp) {
        this.timestamp.set(timestamp);
    }

    public ObjectProperty<Long> atcProperty() {
        return this.atc;
    }

    public ObjectProperty<ValueChange> trendProperty() {
        return this.trend;
    }

    public ObjectProperty<DateTime> timestampProperty() {
        return this.timestamp;
    }

    @Override
    public void merge(HubToHub hubToHub) {
        if (!hubToHub.getTimestamp().equals(this.getTimestamp()) || !hubToHub.getAtc().equals(this.getAtc())) {
            this.setAtc(hubToHub.getAtc());
            this.setTimestamp(hubToHub.getTimestamp());
        }
    }

    @Override
    public Class<HubToHub> getEntityClass() {
        return HubToHub.class;
    }
}

