/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.EmptyComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapper;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.PriceGroupedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateAdapter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.WeakBatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public abstract class AbstractBestOwnOrderOrderbookValueWrapper
extends OrderbookValueWrapper {
    private final ObjectProperty<LongDisplayValue> ask = new SimpleObjectProperty<LongDisplayValue>();
    private final ObjectProperty<LongDisplayValue> bid = new SimpleObjectProperty<LongDisplayValue>();
    private final ObjectProperty<String> askLocation = new SimpleObjectProperty<String>();
    private final ObjectProperty<String> bidLocation = new SimpleObjectProperty<String>();
    private final ObjectProperty<LongDisplayValue> initAskQty = new SimpleObjectProperty<LongDisplayValue>();
    private final ObjectProperty<LongDisplayValue> initBidQty = new SimpleObjectProperty<LongDisplayValue>();
    private final ObjectProperty<LongDisplayValue> ownAskPrc = new SimpleObjectProperty<LongDisplayValue>();
    private final ObjectProperty<LongDisplayValue> ownBidPrc = new SimpleObjectProperty<LongDisplayValue>();
    private final BooleanProperty ownAskPrcValid = new SimpleBooleanProperty();
    private final BooleanProperty ownBidPrcValid = new SimpleBooleanProperty();
    private final ObjectProperty<LongDisplayValue> ownAskQty = new SimpleObjectProperty<LongDisplayValue>();
    private final ObjectProperty<LongDisplayValue> ownBidQty = new SimpleObjectProperty<LongDisplayValue>();
    private final ObjectProperty<LongDisplayValue> askShownQty = new SimpleObjectProperty<LongDisplayValue>();
    private final ObjectProperty<LongDisplayValue> bidShownQty = new SimpleObjectProperty<LongDisplayValue>();
    private final BatchUpdateListener<PriceGroupedOrderbookEntry> refreshBuys;
    private final BatchUpdateListener<PriceGroupedOrderbookEntry> refreshSells;
    private final BatchUpdateListener<PriceGroupedOrderbookEntry> weakRefreshBuys;
    private final BatchUpdateListener<PriceGroupedOrderbookEntry> weakRefreshSells;
    private ComputedOrderbookEntries<PriceGroupedOrderbookEntry> groupedBuys;
    private ComputedOrderbookEntries<PriceGroupedOrderbookEntry> groupedSells;
    private ChangeListener<Orderbook> orderbookChangedListener;
    private ChangeListener<ContractPhase> contractPhaseChangedListener;

    public AbstractBestOwnOrderOrderbookValueWrapper(ContractAdditionOrigin origin, Consumer<Orderbook> contractBecameInactive, BiConsumer<Orderbook, Boolean> compaundContractStatus) {
        super(origin, contractBecameInactive, compaundContractStatus, null);
        EmptyComputedOrderbookEntries<PriceGroupedOrderbookEntry> emptyEntries = new EmptyComputedOrderbookEntries<PriceGroupedOrderbookEntry>();
        this.groupedBuys = emptyEntries;
        this.groupedSells = emptyEntries;
        this.refreshBuys = BatchUpdateAdapter.batchFinishedListener(this::refreshBuys);
        this.refreshSells = BatchUpdateAdapter.batchFinishedListener(this::refreshSells);
        this.weakRefreshBuys = new WeakBatchUpdateListener<PriceGroupedOrderbookEntry>(this.refreshBuys);
        this.weakRefreshSells = new WeakBatchUpdateListener<PriceGroupedOrderbookEntry>(this.refreshSells);
        this.orderbookChangedListener = this::orderbookChanged;
        this.contractPhaseChangedListener = this::contractPhaseChanged;
        this.orderbookProperty().addListener(this.orderbookChangedListener);
        this.ownAskPrcValid.bind(DependentBinding.get(prc -> !this.getBestOwnSellOrder().isPresent() || this.getOrderbook().getContract().getProduct().isPriceValid((LongDisplayValue)prc), this.ownAskPrc, true));
        this.ownBidPrcValid.bind(DependentBinding.get(prc -> !this.getBestOwnBuyOrder().isPresent() || this.getOrderbook().getContract().getProduct().isPriceValid((LongDisplayValue)prc), this.ownBidPrc, true));
    }

    public abstract Optional<Order> getBestOwnBuyOrder();

    public abstract Optional<Order> getBestOwnSellOrder();

    public void refreshOrdersFromModel() {
        this.refreshBuys();
        this.refreshSells();
    }

    private void contractPhaseChanged(ObservableValue<? extends ContractPhase> observable2, ContractPhase oldValue, ContractPhase newValue) {
        this.innerRefresh(this.getOrderbook());
    }

    private void orderbookChanged(ObservableValue<? extends Orderbook> observable2, Orderbook oldValue, Orderbook newValue) {
        if (oldValue != null) {
            oldValue.tradingPhaseProperty().removeListener(this.contractPhaseChangedListener);
        }
        if (newValue != null) {
            newValue.tradingPhaseProperty().addListener(this.contractPhaseChangedListener);
        }
        this.innerRefresh(newValue);
    }

    private void innerRefresh(Orderbook orderbook) {
        this.groupedBuys.removeListener(this.weakRefreshBuys);
        this.groupedSells.removeListener(this.weakRefreshSells);
        if (orderbook != null) {
            this.groupedBuys = orderbook.getGroupedBuys();
            this.groupedSells = orderbook.getGroupedSells();
        } else {
            EmptyComputedOrderbookEntries<PriceGroupedOrderbookEntry> emptyEntries = new EmptyComputedOrderbookEntries<PriceGroupedOrderbookEntry>();
            this.groupedBuys = emptyEntries;
            this.groupedSells = emptyEntries;
        }
        this.groupedBuys.addListener(this.weakRefreshBuys);
        this.groupedSells.addListener(this.weakRefreshSells);
        this.refreshOrdersFromModel();
    }

    private void refreshBuys() {
        if (this.groupedBuys.size() != 0) {
            this.bid.set(this.groupedBuys.getEntries().get(0).getPrice());
        } else {
            this.bid.setValue(null);
        }
        this.loadValuesFromOrder(this.getBestOwnBuyOrder(), Direction.BUY);
    }

    private void refreshSells() {
        if (this.groupedSells.size() != 0) {
            this.ask.set(this.groupedSells.getEntries().get(0).getPrice());
        } else {
            this.ask.setValue(null);
        }
        this.loadValuesFromOrder(this.getBestOwnSellOrder(), Direction.SELL);
    }

    protected void loadValuesFromBuyOrder(Order buyOrder) {
        this.loadValuesFromOrder(Optional.of(buyOrder), Direction.BUY);
    }

    protected void loadValuesFromSellOrder(Order sellOrder) {
        this.loadValuesFromOrder(Optional.of(sellOrder), Direction.SELL);
    }

    private void loadValuesFromOrder(Optional<Order> bestAndOldestOrder, Direction direction) {
        ObjectProperty<String> location;
        ObjectProperty<LongDisplayValue> ownQty = direction.isBuy() ? this.ownBidQty : this.ownAskQty;
        ObjectProperty<LongDisplayValue> initQty = direction.isBuy() ? this.initBidQty : this.initAskQty;
        ObjectProperty<LongDisplayValue> ownPrc = direction.isBuy() ? this.ownBidPrc : this.ownAskPrc;
        ObjectProperty<LongDisplayValue> shownQty = direction.isBuy() ? this.bidShownQty : this.askShownQty;
        ObjectProperty<String> objectProperty = location = direction.isBuy() ? this.bidLocation : this.askLocation;
        if (bestAndOldestOrder.isPresent()) {
            ownQty.set(bestAndOldestOrder.get().getRemainingQuantity());
            initQty.set(bestAndOldestOrder.get().getInitialQuantity());
            ownPrc.set(bestAndOldestOrder.get().getLimitPrice());
            shownQty.set(bestAndOldestOrder.get().getShownQuantity());
            location.set(bestAndOldestOrder.get().getLocation());
        } else {
            ownQty.set(null);
            initQty.set(null);
            ownPrc.set(null);
            shownQty.set(null);
            location.set(null);
        }
    }

    public ReadOnlyObjectProperty<LongDisplayValue> askProperty() {
        return this.ask;
    }

    public ReadOnlyObjectProperty<LongDisplayValue> bidProperty() {
        return this.bid;
    }

    public ReadOnlyObjectProperty<String> askLocationProperty() {
        return this.askLocation;
    }

    public ReadOnlyObjectProperty<String> bidLocationProperty() {
        return this.bidLocation;
    }

    public ReadOnlyObjectProperty<LongDisplayValue> initAskQtyProperty() {
        return this.initAskQty;
    }

    public ReadOnlyObjectProperty<LongDisplayValue> initBidQtyProperty() {
        return this.initBidQty;
    }

    public ReadOnlyObjectProperty<LongDisplayValue> ownAskPrcProperty() {
        return this.ownAskPrc;
    }

    public ReadOnlyObjectProperty<LongDisplayValue> ownBidPrcProperty() {
        return this.ownBidPrc;
    }

    public boolean getOwnAskPrcValid() {
        return this.ownAskPrcValid.get();
    }

    public BooleanProperty ownAskPrcValidProperty() {
        return this.ownAskPrcValid;
    }

    public boolean getOwnBidPrcValid() {
        return this.ownBidPrcValid.get();
    }

    public BooleanProperty ownBidPrcValidProperty() {
        return this.ownBidPrcValid;
    }

    protected void setOwnAskPrc(LongDisplayValue ownAskPrc) {
        this.ownAskPrc.set(ownAskPrc);
    }

    protected void setOwnBidPrc(LongDisplayValue ownBidPrc) {
        this.ownBidPrc.set(ownBidPrc);
    }

    public ReadOnlyObjectProperty<LongDisplayValue> ownAskQtyProperty() {
        return this.ownAskQty;
    }

    public ReadOnlyObjectProperty<LongDisplayValue> ownBidQtyProperty() {
        return this.ownBidQty;
    }

    public ReadOnlyObjectProperty<LongDisplayValue> askShownQtyProperty() {
        return this.askShownQty;
    }

    public ReadOnlyObjectProperty<LongDisplayValue> bidShownQtyProperty() {
        return this.bidShownQty;
    }
}

