/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.datamodel.SmallFastDataModelBase;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.jfx.MessageDirection;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.TotalsCounter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.AllEntitiesProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.FilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.FilterPopupButton;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpUtil;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MessageInterceptor;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.google.inject.Inject;
import jakarta.inject.Singleton;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GuiMessageRecorder
extends FXMLBorderPane
implements MessageInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(GuiMessageRecorder.class);
    private static final int TABLE_UPDATE_INTERVAL_IN_MILLIS = 500;
    private final AmqpMessageDataModel amqpMessageDataModel;
    @FXML
    private TableView<AmqpMessage> messageTableView;
    private final Stage stage;
    @FXML
    private Label outgoingCountLabel;
    @FXML
    private Label incomingCountLabel;
    @FXML
    private ButtonWithIcon pauseOrResumeButton;
    @FXML
    private TextField searchText;
    @FXML
    private FilterPopupButton<AmqpMessage> filterButton;
    @FXML
    private TotalsCounter totalsCounter;
    private final AtomicInteger outgoingCount = new AtomicInteger(0);
    private final AtomicInteger incomingCount = new AtomicInteger(0);
    private final AtomicBoolean recordingActive;
    private final BlockingQueue<AmqpMessage> bufferQueue;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> tableSync;
    private StringProperty rabbitUser = new SimpleStringProperty("");

    @Inject
    public GuiMessageRecorder(ApplicationContext applicationContext) {
        super(applicationContext);
        this.bufferQueue = new ArrayBlockingQueue<AmqpMessage>(5000);
        this.amqpMessageDataModel = new AmqpMessageDataModel(applicationContext);
        this.stage = new Stage();
        this.stage.setScene(new Scene(this, 1280.0, 800.0));
        this.recordingActive = new AtomicBoolean(false);
        this.stage.setOnHidden(event -> this.deactivateRecording());
        this.scheduledExecutorService = applicationContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        applicationContext.getService(WindowService.class).decorateWindow(this.stage);
        this.loadFxml();
    }

    public void initialize() {
        FilteredTableView<AmqpMessage> filteredTableView = new FilteredTableView<AmqpMessage>(this, this.messageTableView, message -> true, new AllEntitiesProvider<String, AmqpMessage>(this.amqpMessageDataModel), true){

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                super.notifyRemoveAll();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        this.messageTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.filterButton.initialize(filteredTableView);
        this.stage.titleProperty().bind(DependentBinding.get(() -> Util.getLabel("commons_recordMessagesWindowTitle", this.rabbitUser.getValue()), this.rabbitUser));
        this.totalsCounter.totalItemsProperty().bind(filteredTableView.totalItems());
        this.totalsCounter.shownItemsProperty().bind(filteredTableView.shownItems());
    }

    @Override
    public byte[] handleMessage(Session session, byte[] messageBytes, DateTime timestamp, boolean outgoing, String routingKey, String correlationId, Long eventIndex) {
        if (this.recordingActive.get()) {
            try {
                DateTime localTime = this.getAppContext().getService(TimeService.class).getLocalTime();
                String body = AmqpUtil.toString(messageBytes);
                MessageDirection direction = outgoing ? MessageDirection.OUT : MessageDirection.IN;
                AmqpMessage message = new AmqpMessage(body, timestamp, direction, routingKey, correlationId, localTime, eventIndex);
                this.handleMessage(message);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("cannot intercept message", e);
            }
        }
        return messageBytes;
    }

    private void handleMessage(AmqpMessage message) {
        this.bufferQueue.add(message);
        if (message.getDirection() == MessageDirection.IN) {
            this.incomingCount.incrementAndGet();
        } else {
            this.outgoingCount.incrementAndGet();
        }
        FxUtil.runInFxThread(() -> {
            if (!this.stage.isShowing()) {
                this.stage.show();
            }
        });
    }

    private void syncMessages() {
        FxUtil.runInFxThread(this::syncMessagesInFxThread);
    }

    private void syncMessagesInFxThread() {
        if (!this.bufferQueue.isEmpty()) {
            ArrayList<AmqpMessage> selectedMessages = new ArrayList<AmqpMessage>(this.messageTableView.getSelectionModel().getSelectedItems());
            ArrayList buffer = new ArrayList();
            this.bufferQueue.drainTo(buffer);
            this.amqpMessageDataModel.handleBroadcastEntities(buffer);
            if (!selectedMessages.isEmpty()) {
                selectedMessages.forEach(arg_0 -> GuiMessageRecorder.lambda$syncMessagesInFxThread$4(this.messageTableView.getSelectionModel(), arg_0));
            }
            this.setInOutLabels();
        }
    }

    private void setInOutLabels() {
        this.outgoingCountLabel.setText(Integer.toString(this.outgoingCount.get()));
        this.incomingCountLabel.setText(Integer.toString(this.incomingCount.get()));
    }

    @FXML
    public void clearList() {
        this.bufferQueue.clear();
        this.amqpMessageDataModel.removeAll();
        this.incomingCount.set(0);
        this.outgoingCount.set(0);
        this.setInOutLabels();
    }

    @FXML
    public void exportAllToCSV() {
        this.getAppContext().getService(ImportExportService.class).exportToCsvFile(new ExportableTableView<AmqpMessage>(this.messageTableView, ExportableTableView.Mode.ALL), this.stage, null);
    }

    @FXML
    public void exportSelectedToCSV() {
        this.getAppContext().getService(ImportExportService.class).exportToCsvFile(new ExportableTableView<AmqpMessage>(this.messageTableView, ExportableTableView.Mode.SELECTED), this.stage, null);
    }

    @FXML
    public void exportAllToClipboard() {
        this.getAppContext().getService(ImportExportService.class).exportToClipboard(new ExportableTableView<AmqpMessage>(this.messageTableView, ExportableTableView.Mode.ALL));
    }

    @FXML
    public void exportSelectedToClipboard() {
        this.getAppContext().getService(ImportExportService.class).exportToClipboard(new ExportableTableView<AmqpMessage>(this.messageTableView, ExportableTableView.Mode.SELECTED));
    }

    @FXML
    public void pauseOrResume() {
        if (this.recordingActive.get()) {
            this.deactivateRecording();
        } else {
            this.activateRecording();
        }
    }

    @FXML
    public void search() {
        String text = this.searchText.getText();
        if (StringUtils.isEmpty(text)) {
            return;
        }
        TableView.TableViewSelectionModel<AmqpMessage> selectionModel = this.messageTableView.getSelectionModel();
        selectionModel.clearSelection();
        ObservableList<AmqpMessage> items = this.messageTableView.getItems();
        for (int row = 0; row < items.size(); ++row) {
            if (!((AmqpMessage)items.get(row)).getText().contains(text)) continue;
            selectionModel.select(row);
        }
    }

    public void activateRecording() {
        if (this.recordingActive.compareAndSet(false, true)) {
            LOG.info("Record messages is now activated");
            FxUtil.runInFxThread(() -> {
                this.pauseOrResumeButton.setText("Pause");
                this.pauseOrResumeButton.setIconStyleClass("button-deactivate");
                if (!this.stage.isShowing()) {
                    this.stage.show();
                }
            });
            this.tableSync = this.scheduledExecutorService.scheduleAtFixedRate(this::syncMessages, 0L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    private void deactivateRecording() {
        if (this.recordingActive.compareAndSet(true, false)) {
            LOG.info("Record messages is now deactivated");
            FxUtil.runInFxThread(() -> {
                this.pauseOrResumeButton.setText("Resume");
                this.pauseOrResumeButton.setIconStyleClass("button-activate");
            });
            if (this.tableSync != null) {
                this.tableSync.cancel(false);
            }
        }
    }

    public void setRabbitUser(String rabbitUser) {
        this.rabbitUser.set(rabbitUser);
    }

    private static /* synthetic */ void lambda$syncMessagesInFxThread$4(TableView.TableViewSelectionModel rec$, Object x$0) {
        rec$.select(x$0);
    }

    private static final class AmqpMessageDataModel
    extends SmallFastDataModelBase<String, AmqpMessage> {
        public AmqpMessageDataModel(ApplicationContext appContext) {
            super(appContext);
        }

        @Override
        public Class<AmqpMessage> getEntityClass() {
            return AmqpMessage.class;
        }
    }

    public static class AmqpMessage
    extends BroadcastEntity<String>
    implements SmallDataModelEntity {
        private final String text;
        private final DateTime processDate;
        private final DateTime clientDate;
        private final MessageDirection direction;
        private final String routingKey;
        private final long roundTripTime;
        private final String type;
        private final Long eventIndex;
        private static final Pattern TYPE_PATTERN = Pattern.compile("<([a-zA-Z0-9]+) ");

        public AmqpMessage(String text, DateTime processDate, MessageDirection directionOut, String routingKey, String correlationId, DateTime clientDate, Long eventIndex) {
            super(UUID.randomUUID().toString());
            this.setCorrelationId(correlationId);
            this.text = text;
            this.processDate = processDate;
            this.direction = directionOut;
            this.routingKey = routingKey;
            this.clientDate = clientDate;
            this.eventIndex = eventIndex;
            this.roundTripTime = clientDate == null || processDate == null ? 0L : clientDate.getMillis() - processDate.getMillis();
            Matcher matcher = TYPE_PATTERN.matcher(text);
            this.type = matcher.find() ? matcher.group(1) : "";
        }

        public String getText() {
            return this.text;
        }

        public DateTime getClientDate() {
            return this.clientDate;
        }

        public DateTime getProcessDate() {
            return this.processDate;
        }

        public long getRoundTripTime() {
            return this.roundTripTime;
        }

        public MessageDirection getDirection() {
            return this.direction;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }

        public String getType() {
            return this.type;
        }

        public int getLength() {
            return this.text.length();
        }

        public Long getEventIndex() {
            return this.eventIndex;
        }

        @Override
        public Class<AmqpMessage> getEntityClass() {
            return AmqpMessage.class;
        }
    }
}

