/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.MessageQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ExportableAbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.MessageSeverityCheckBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.AllEntitiesProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.FilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.FilterPopupButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.message.MessageAppender;
import com.deutscheboerse.comxerv.comtrader.jfx.components.message.MessagePanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.message.MessageTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.fxml.FXML;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.input.TransferMode;

@DraggableComponent(hasPublicAccess=true, nameKey="messagePanel_header_label", descriptionKey="messagePanel_description")
@PanelWithLoadingIndicator(entityClasses={Message.class})
public class MessagePanel
extends ExportableAbstractPanel<Message>
implements StorableComponent<MessagePanelState> {
    private FilteredTableView<Message> filteredTableView;
    @FXML
    private MessageTableView messageTableView;
    @FXML
    private MessageSeverityCheckBox messageSeverityCheckBox;
    @FXML
    private TitledPane menu;
    @FXML
    private FilterPopupButton<Message> filterButton;
    @FXML
    private BottomToolbar bottomToolbar;

    public MessagePanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public MessagePanel(ApplicationContext applicationContext) {
        super(applicationContext);
        this.loadFxml();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.messageTableView.setOnDragOver(dragEvent -> {
            dragEvent.acceptTransferModes(TransferMode.NONE);
            dragEvent.consume();
        });
        this.messageTableView.setOnDragDropped(dragEvent -> {
            dragEvent.acceptTransferModes(TransferMode.NONE);
            dragEvent.consume();
        });
        int maxMessages = this.getAppContext().getService(ApplicationConfigurationService.class).getIntegerApplicationProperty("max.visible.messages", 1000);
        MessageAppender messageAppender = new MessageAppender(maxMessages, this.messageTableView.getItems());
        AllEntitiesProvider<String, Message> messageAllEntitiesProvider = new AllEntitiesProvider<String, Message>(this.getAppContext().getSmallDataModel(Message.class)){

            @Override
            public Stream<Message> getRelevantEntities() {
                return MessagePanel.this.getAppContext().getService(MessageQueries.class).getAllSortedByTimestamp();
            }
        };
        this.filteredTableView = new FilteredTableView<Message>(this.messageTableView, message -> true, messageAllEntitiesProvider, messageAppender, true);
        this.filterButton.initialize(this.filteredTableView);
        this.messageSeverityCheckBox.getFilter().addListener((observable2, oldValue, newValue) -> this.filteredTableView.setQuickFilter((Predicate<Message>)newValue));
        this.setCenter(this.messageTableView);
    }

    @Override
    public MessagePanelState getComponentState() {
        return new MessagePanelState(StorableTableLayoutDescriptor.fromTable(this.messageTableView), this.menu.isExpanded(), this.bottomToolbar.getState(), this.filteredTableView.getCustomFilter().getFilterStates());
    }

    @Override
    public void restoreComponentState(MessagePanelState componentState) {
        componentState.getMessageTableDescriptor().applyToTable(this.messageTableView);
        this.menu.setExpanded(componentState.isMenuExpanded());
        this.bottomToolbar.applyToolbarItemState(componentState.getBottomToolbarStoredState());
        this.filteredTableView.loadCustomFilter(componentState.getColumnFilters());
    }

    @Override
    public TableView<Message> getTableView() {
        return this.messageTableView;
    }
}

