/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.filter.ContractFilters;
import com.deutscheboerse.comxerv.comtrader.domain.filter.ProductFilters;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractMarketMakerPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.BestOwnOrderWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookRemovalCallback;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurations;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.BottomToolbarOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TableViewOverrideGuiStrategy;
import javafx.fxml.FXML;
import javafx.scene.control.Button;

@DraggableComponent(hasPublicAccess=true, nameKey="ownMarketPanel_header_label", descriptionKey="ownMarketPanel_description")
@PanelWithLoadingIndicator(entityClasses={Orderbook.class})
@OverrideGuiConfigurations(value={@OverrideGuiConfiguration(field="bottomToolbar", overrideId="OwnMarketPanel", strategy=BottomToolbarOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="marketTableView", overrideId="OwnMarketPanel", strategy=TableViewOverrideGuiStrategy.class)})
public class OwnMarketPanel
extends AbstractMarketMakerPanel<BestOwnOrderWrapper> {
    @FXML
    protected Button fillUpButton;

    public OwnMarketPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OwnMarketPanel(ApplicationContext applicationContext) {
        super(applicationContext, ContractFilters.ONLY_CANONICAL_CONTRACTS_FILTER, ProductFilters.NON_OTC_NON_BLOCK_PRODUCTS_FILTER);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.fillUpButton.disableProperty().bind(this.getButtonDisableBinding());
        this.narrowButton.disableProperty().bind(this.getButtonDisableBinding());
        this.widenButton.disableProperty().bind(this.getButtonDisableBinding());
        this.stepUpButton.disableProperty().bind(this.getButtonDisableBinding());
        this.stepDownButton.disableProperty().bind(this.getButtonDisableBinding());
    }

    @Override
    public BestOwnOrderWrapper getOrderbookItem(Orderbook orderbook, OrderbookRemovalCallback orderbookRemovalCallback, ContractAdditionOrigin origin) {
        return new BestOwnOrderWrapper(orderbook, orderbookRemovalCallback, this.getAppContext(), origin);
    }
}

