/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.AlertingSettingsPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.ComXervSettingsPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.ExportSettingsPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.FacilityTypeTemplatesPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.GeneralSettingsPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.LocationTemplatesPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.OrderPreferencesPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.OrderTextTemplatesPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.OrderValidationSettingsPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SoundSettingsPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.TradingSettingsPane;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TabPaneOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.jfx.util.UtilityStages;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

@Singleton
@OverrideGuiConfiguration(field="tabPane", overrideId="SettingsPanel", strategy=TabPaneOverrideGuiStrategy.class)
public class SettingsPanel
extends BorderPane {
    private final Stage settingsStage;
    private final Set<SettingsSection> sections;
    @FXML
    private ExportSettingsPane exportSettingsPane;
    @FXML
    private TradingSettingsPane tradingSettingsPane;
    @FXML
    private OrderValidationSettingsPane orderValidationSettingsPane;
    @FXML
    private OrderPreferencesPane orderPreferencesPane;
    @FXML
    private OrderTextTemplatesPane orderTextTemplatesPane;
    @FXML
    private LocationTemplatesPane locationTemplatesPane;
    @FXML
    private FacilityTypeTemplatesPane facilityTypeTemplatesPane;
    @FXML
    private GeneralSettingsPane generalSettingsPane;
    @FXML
    private SoundSettingsPane soundSettingsPane;
    @FXML
    private ComXervSettingsPane comXervSettingsPane;
    @FXML
    private AlertingSettingsPane alertingSettingsPane;
    @FXML
    private TabPane tabPane;
    private final EventBus eventBus;
    private OverrideGuiConfigurationsExecutor overrideExecutor;
    private BackendConnectionGateway backendConnectionGateway;

    @Inject
    public SettingsPanel(ApplicationContext appContext) {
        this.eventBus = appContext.getService(EventBus.class);
        this.settingsStage = appContext.getService(UtilityStages.class).withKey(SettingsPanel.class.getName()).get();
        this.settingsStage.setTitle(Util.getLabel("commons_settings"));
        this.settingsStage.setOnHidden(event -> {
            this.settingsStage.setScene(null);
            this.unregisterAllPanes();
            this.eventBus.unregister(this);
        });
        appContext.getService(WindowService.class).decorateWindow(this.settingsStage);
        this.sections = new HashSet<SettingsSection>();
        this.overrideExecutor = appContext.getService(OverrideGuiConfigurationsExecutor.class);
        this.backendConnectionGateway = appContext.getService(BackendConnectionGateway.class);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.eventBus.register(this);
    }

    public void initialize() {
        this.sections.add(this.generalSettingsPane);
        this.sections.add(this.tradingSettingsPane);
        this.sections.add(this.orderValidationSettingsPane);
        this.sections.add(this.orderPreferencesPane);
        this.sections.add(this.orderTextTemplatesPane);
        this.sections.add(this.locationTemplatesPane);
        this.sections.add(this.facilityTypeTemplatesPane);
        this.sections.add(this.exportSettingsPane);
        this.sections.add(this.soundSettingsPane);
        this.sections.add(this.comXervSettingsPane);
        this.sections.add(this.alertingSettingsPane);
        this.overrideExecutor.registerAndApply(this);
    }

    @FXML
    public void ok() {
        if (this.apply()) {
            this.refreshPanes();
            this.close();
        }
    }

    @FXML
    public void cancel() {
        this.refreshPanes();
        this.close();
    }

    @Subscribe
    public void handleLogout(LogoutEvent logoutEvent) {
        if (this.backendConnectionGateway.getSession() == null) {
            this.close();
        }
    }

    public void refreshPanes() {
        this.sections.stream().forEach(SettingsSection::cancelChanges);
    }

    @FXML
    public void resetToDefault() {
        this.sections.stream().forEach(SettingsSection::resetToDefault);
    }

    @FXML
    public boolean apply() {
        return this.sections.stream().map(SettingsSection::applyChanges).reduce(true, (a, b) -> a != false && b != false);
    }

    @Subscribe
    public void handleSettingsLoaded(SettingsLoadedEvent event) {
        this.refreshPanes();
    }

    public void showSettingsPanel() {
        this.settingsStage.setScene(new Scene(this));
        this.settingsStage.show();
        this.settingsStage.toFront();
        this.refreshPanes();
    }

    private void close() {
        this.settingsStage.close();
    }

    private void unregisterAllPanes() {
        this.sections.stream().forEach(this.eventBus::unregister);
    }

    public TabPane getTabPane() {
        return this.tabPane;
    }
}

