/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke;

import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BespokeContract;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.jfx.service.NotificationService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BespokeValidator {
    private final NotificationService.Notifier notifier;
    private final ContractQueries contractQueries;
    private static final Pattern BESPOKE_CONTRACT_PATTERN = Pattern.compile("([a-zA-Z0-9._+\\-]+(\\([0-9]+\\))?)|([a-zA-Z0-9._+\\-]+ -( [0-9]+(\\.[0-9]+)?)? (PUT|CALL)(\\([0-9]+\\))?)");

    public BespokeValidator(NotificationService.Notifier notifier, ContractQueries contractQueries) {
        this.notifier = notifier;
        this.contractQueries = contractQueries;
    }

    public boolean isValidBespokeContract(BespokeContract contract) {
        if (contract.getName() == null || !BESPOKE_CONTRACT_PATTERN.matcher(contract.getName()).matches()) {
            this.notifier.showNotification(Util.getLabel("bespokeTradesPanel_name_constraints"), NotificationService.NotificationSeverity.ERROR);
            return false;
        }
        if (this.contractQueries.findByName(contract.getName()).getAll().findAny().isPresent()) {
            this.notifier.showNotification(Util.getLabel("commons_nameAlreadyExist"), NotificationService.NotificationSeverity.ERROR);
            return false;
        }
        if (contract.getUnderlyingContracts().size() == 1) {
            Optional<BespokeContract> bespokeContractsWithSameUnderlying = this.contractQueries.findByUnderlyingContractsAndOption(contract.getUnderlyingContracts(), contract.getStrikePrc(), contract.getPutOrCall()).getFirst();
            if (bespokeContractsWithSameUnderlying.isPresent()) {
                this.notifier.showNotification(Util.getLabel("bespokeTradesPanel_underlyingContracts_option_exist", bespokeContractsWithSameUnderlying.get().getName()), NotificationService.NotificationSeverity.ERROR);
                return false;
            }
        } else {
            Optional<BespokeContract> bespokeContractsWithSameUnderlying = this.contractQueries.findByUnderlyingContracts(contract.getUnderlyingContracts()).getFirst();
            if (bespokeContractsWithSameUnderlying.isPresent()) {
                this.notifier.showNotification(Util.getLabel("bespokeTradesPanel_underlyingContracts_exist", bespokeContractsWithSameUnderlying.get().getName()), NotificationService.NotificationSeverity.ERROR);
                return false;
            }
        }
        return true;
    }

    public boolean isValidTrade(FullTrade trade) {
        if (StringUtils.isNotBlank(trade.getBuyOrder().getText()) && !Pattern.compile("[a-zA-Z0-9._+\\-\\s]+").matcher(trade.getBuyOrder().getText()).matches()) {
            this.notifier.showNotification(Util.getLabel("bespokeTradesPanel_text_constraints"), NotificationService.NotificationSeverity.ERROR);
            return false;
        }
        return true;
    }
}

