/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Label;

public abstract class ContractAndMarketAreaDependentLabel
extends Label {
    private final ObjectProperty<Contract> contract = new SimpleObjectProperty<Contract>();
    private final ObjectProperty<MarketArea> marketArea = new SimpleObjectProperty<MarketArea>();

    public ContractAndMarketAreaDependentLabel() {
        this.contract.addListener(this::loadText);
        this.marketArea.addListener(this::loadText);
    }

    protected void loadText(Observable observable2) {
        Contract currentContract = this.getContract();
        MarketArea currentMarketArea = this.getMarketArea();
        if (currentContract == null) {
            this.setText("");
        } else if (currentMarketArea != null && currentContract.getExchange().supportsDeliveryAreas()) {
            this.setText(this.getText(currentContract, currentMarketArea));
        } else {
            this.setText(this.getText(currentContract));
        }
    }

    protected abstract String getText(Contract var1);

    protected abstract String getText(Contract var1, MarketArea var2);

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public MarketArea getMarketArea() {
        return (MarketArea)this.marketArea.get();
    }

    public ObjectProperty<MarketArea> marketAreaProperty() {
        return this.marketArea;
    }

    public void setMarketArea(MarketArea marketArea) {
        this.marketArea.set(marketArea);
    }
}

