/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.componentlist;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.componentlist.ComponentDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.ComponentDragDone;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.deutscheboerse.ui.jfx.util.control.table.TextWrappingTableCellFactory;
import com.google.common.eventbus.EventBus;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;

public class ComponentsTableCellFactory
extends TextWrappingTableCellFactory<ComponentDescriptor> {
    private final DragAndDropService dragAndDropService;
    private final EventBus eventBus;

    public ComponentsTableCellFactory() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public ComponentsTableCellFactory(ApplicationContext appContext) {
        this.dragAndDropService = appContext.getService(DragAndDropService.class);
        this.eventBus = appContext.getService(EventBus.class);
    }

    @Override
    public TableCell<ComponentDescriptor, String> call(TableColumn<ComponentDescriptor, String> column) {
        TableCell<ComponentDescriptor, String> cell = super.call(column);
        cell.setOnDragDetected(event -> {
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)cell.getTableRow().getItem();
            if (componentDescriptor != null) {
                Dragboard db = cell.startDragAndDrop(TransferMode.COPY);
                this.dragAndDropService.setComponentClassName(db, componentDescriptor.getClassName());
                event.consume();
            }
        });
        cell.setOnDragDone(event -> this.eventBus.post(new ComponentDragDone()));
        return cell;
    }
}

