/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.jfx.components.TooltipFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.ValidProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class ShuttleSelectionField<T extends Comparable>
extends HBox {
    private static final int PADDING = 5;
    private final ObservableList<T> allItems = FXCollections.observableArrayList();
    private final ListView<T> availableItems = new ListView();
    private final ListView<T> selectedItems = new ListView();
    private final Button add;
    private final Button addAll;
    private final Button remove;
    private final Button removeAll;
    private final SimpleBooleanProperty emptyAvailableItems = new SimpleBooleanProperty(true);
    private final SimpleBooleanProperty emptySelectedItems = new SimpleBooleanProperty(true);
    private final ValidProperty valid = new ValidProperty(this.getSelectedItems());

    public ShuttleSelectionField() {
        this.valid.bind(this.emptySelectedItems.not());
        this.add = this.createButton("button-add-to-list", "commons_add");
        this.addAll = this.createButton("button-add-all-to-list", "commons_addAll");
        this.remove = this.createButton("button-remove-from-list", "commons_remove");
        this.removeAll = this.createButton("button-remove-all-from-list", "commons_removeAll");
        this.createInitialItemsChangeListener();
        this.createUI();
        this.createButtonActionHandler();
        this.createEmptyListener();
    }

    private Button createButton(String icon, String tooltipLabelKey) {
        Button b = new Button();
        b.setGraphic(new IconView(icon));
        b.setTooltip(TooltipFactory.getToolTip(tooltipLabelKey));
        StyleUtil.addStyleClass(b, "bespokePanelButton");
        return b;
    }

    private void createInitialItemsChangeListener() {
        this.allItems.addListener(c -> {
            ArrayList currentlySelectedItems = new ArrayList(this.selectedItems.getItems());
            this.availableItems.getItems().clear();
            this.availableItems.getItems().addAll((Collection<T>)this.allItems.stream().filter(i -> !currentlySelectedItems.contains(i)).toList());
            this.selectedItems.getItems().clear();
            this.selectedItems.getItems().addAll((Collection<T>)this.allItems.stream().filter(currentlySelectedItems::contains).toList());
            Collections.sort(this.availableItems.getItems(), Comparable::compareTo);
            Collections.sort(this.selectedItems.getItems(), Comparable::compareTo);
        });
    }

    private void createUI() {
        GridPane buttonPane = new GridPane();
        buttonPane.add(this.addAll, 0, 0);
        buttonPane.add(this.add, 0, 1);
        buttonPane.add(this.remove, 0, 2);
        buttonPane.add(this.removeAll, 0, 3);
        buttonPane.setAlignment(Pos.CENTER);
        buttonPane.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        this.availableItems.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.selectedItems.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.getChildren().add(this.availableItems);
        this.getChildren().add(buttonPane);
        this.getChildren().add(this.selectedItems);
        this.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        HBox.setHgrow(this.availableItems, Priority.ALWAYS);
        HBox.setHgrow(this.selectedItems, Priority.ALWAYS);
        this.availableItems.disableProperty().bind(this.disabledProperty());
        this.selectedItems.disableProperty().bind(this.disabledProperty());
        this.add.disableProperty().bind(this.disabledProperty());
        this.addAll.disableProperty().bind(this.disabledProperty());
        this.remove.disableProperty().bind(this.disabledProperty());
        this.removeAll.disableProperty().bind(this.disabledProperty());
    }

    private void createButtonActionHandler() {
        this.add.setOnAction(event -> this.add());
        this.addAll.setOnAction(event -> this.addAll());
        this.remove.setOnAction(event -> this.remove());
        this.removeAll.setOnAction(event -> this.removeAll());
    }

    private void createEmptyListener() {
        this.emptyAvailableItems.bind(Bindings.isEmpty(this.availableItems.getItems()));
        this.emptySelectedItems.bind(Bindings.isEmpty(this.selectedItems.getItems()));
    }

    public void add() {
        this.moveSelected(this.availableItems, this.selectedItems);
    }

    public void addAll() {
        this.moveAll(this.availableItems, this.selectedItems);
    }

    public void remove() {
        this.moveSelected(this.selectedItems, this.availableItems);
    }

    public void removeAll() {
        this.moveAll(this.selectedItems, this.availableItems);
    }

    private void moveAll(ListView<T> from, ListView<T> to) {
        LinkedHashSet<T> items = new LinkedHashSet<T>(from.getItems());
        from.getItems().removeAll((Collection<?>)items);
        to.getItems().addAll((Collection<T>)items);
        to.getItems().sort(Comparable::compareTo);
        this.clearSelectionAndSelectFirst();
    }

    private void moveSelected(ListView<T> from, ListView<T> to) {
        LinkedHashSet<T> selectedItems = new LinkedHashSet<T>(from.getSelectionModel().getSelectedItems());
        from.getItems().removeAll((Collection<?>)selectedItems);
        to.getItems().addAll((Collection<T>)selectedItems);
        to.getItems().sort(Comparable::compareTo);
        this.clearSelectionAndSelectFirst();
    }

    private void clearSelectionAndSelectFirst() {
        this.availableItems.getSelectionModel().clearSelection();
        this.availableItems.getSelectionModel().selectFirst();
        this.selectedItems.getSelectionModel().clearSelection();
        this.selectedItems.getSelectionModel().selectFirst();
    }

    public ListView<T> getAvailableItems() {
        return this.availableItems;
    }

    public ListView<T> getSelectedItems() {
        return this.selectedItems;
    }

    protected ObservableList<T> getAllItems() {
        return this.allItems;
    }

    public boolean getEmptyAvailableItems() {
        return this.emptyAvailableItems.get();
    }

    public SimpleBooleanProperty emptyAvailableItemsProperty() {
        return this.emptyAvailableItems;
    }

    public boolean getEmptySelectedItems() {
        return this.emptySelectedItems.get();
    }

    public SimpleBooleanProperty emptySelectedItemsProperty() {
        return this.emptySelectedItems;
    }
}

