/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SystemInfo;
import com.deutscheboerse.comxerv.comtrader.entities.DateFilterChoice;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DisplayNameArrowKeyBlockingChoiceBox;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;

public class DateFilterChoiceBox
extends DisplayNameArrowKeyBlockingChoiceBox<DateFilterChoice> {
    public static final DateFilterChoice DEFAULT_DATE_FILTER_CHOICE = DateFilterChoice.TODAY;
    private final ObservableValue<Exchange> activeExchange;
    private final ChangeListener<Exchange> activeExchangeChangeListener;

    public DateFilterChoiceBox() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public DateFilterChoiceBox(ApplicationContext appContext) {
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.activeExchangeChangeListener = this::activeExchangeChanged;
        this.activeExchange.addListener(new WeakChangeListener<Exchange>(this.activeExchangeChangeListener));
        this.activeExchangeChanged(this.activeExchange, null, this.activeExchange.getValue());
        this.reset();
    }

    private void activeExchangeChanged(ObservableValue<? extends Exchange> observable2, Exchange oldValue, Exchange newValue) {
        Integer contractStoreTimeInDays = Optional.ofNullable(newValue).map(Exchange::getSystemInfo).map(SystemInfo::getContractStoreTimeInDays).orElse(0);
        ArrayList<DateFilterChoice> items = Lists.newArrayList(DateFilterChoice.TOMORROW, DateFilterChoice.TODAY);
        for (int i = 1; i <= contractStoreTimeInDays; ++i) {
            items.add(new DateFilterChoice(Util.getLabel("commons_inRangePrefix") + i, -i));
        }
        this.setListedItems(items);
    }

    public void reset() {
        this.setValue(DEFAULT_DATE_FILTER_CHOICE);
    }
}

