/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.customization.column;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.column.ColumnColor;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.column.ColumnToolbarMenuRow;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.common.ToolbarMenuTable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColoredTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.SeparatorTableColumn;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.control.table.TableSourceData;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnToolbarMenuTable<S>
extends ToolbarMenuTable<ColumnToolbarMenuRow<S>>
implements TableSourceData<ColumnToolbarMenuRow<S>> {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnToolbarMenuTable.class);
    @FXML
    private TableColumn<S, ?> showColumnColumn;
    private final CustomTableView<S> targetTableView;
    private final ObservableList<ColumnToolbarMenuRow<S>> data;
    private final FilteredList<ColumnToolbarMenuRow<S>> filteredData;

    public ColumnToolbarMenuTable(CustomTableView<S> targetTableView, ApplicationContext applicationContext) {
        super(applicationContext);
        this.targetTableView = targetTableView;
        this.data = FXCollections.observableArrayList();
        this.filteredData = new FilteredList<ColumnToolbarMenuRow<S>>(this.data);
        targetTableView.getColumns().stream().map(this::getColumnToolbarMenuRow).forEach(this.data::add);
        this.setItems(this.filteredData);
        this.getItems().addListener(this::applyTableColumns);
        this.showColumnColumn.setContextMenu(this.createColumnContextMenu());
    }

    private void applyTableColumns(Observable observable2) {
        LOG.trace("Listener called for {}", (Object)observable2);
        List<TableColumn> newColumns = this.data.stream().map(ColumnToolbarMenuRow::getColumn).toList();
        this.targetTableView.getColumns().setAll(newColumns);
    }

    private void checkShowColumnAll(boolean check) {
        this.getItems().stream().forEach(item -> item.setVisible(check));
    }

    private ContextMenu createColumnContextMenu() {
        MenuItem selectAllMenuItem = new MenuItem(Util.getLabel("commons_selectAll"));
        selectAllMenuItem.setOnAction(event -> this.checkShowColumnAll(true));
        MenuItem clearAllMenuItem = new MenuItem(Util.getLabel("commons_clearAll"));
        clearAllMenuItem.setOnAction(event -> this.checkShowColumnAll(false));
        return new ContextMenu(selectAllMenuItem, clearAllMenuItem);
    }

    @Override
    public ObservableList<ColumnToolbarMenuRow<S>> getData() {
        return this.data;
    }

    private ColumnToolbarMenuRow<S> getColumnToolbarMenuRow(TableColumn<S, ?> tableColumn) {
        ColumnToolbarMenuRow<S> columnToolbarMenuRow = new ColumnToolbarMenuRow<S>(tableColumn);
        if (tableColumn instanceof ColoredTableColumn) {
            columnToolbarMenuRow.enableColorPicker();
            columnToolbarMenuRow.setColor(((ColoredTableColumn)tableColumn).getColor());
            columnToolbarMenuRow.colorProperty().addListener((observable2, oldValue, newValue) -> ((ColoredTableColumn)tableColumn).setColor((ColumnColor)((Object)newValue)));
        } else {
            columnToolbarMenuRow.disableColorPicker();
        }
        if (tableColumn instanceof SeparatorTableColumn) {
            columnToolbarMenuRow.visibleProperty().addListener((ChangeListener<? super Boolean>)((ChangeListener<Boolean>)(observable2, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.data.remove(columnToolbarMenuRow);
                }
            }));
        }
        return columnToolbarMenuRow;
    }

    @Override
    public void addSeparator() {
        SeparatorTableColumn<S> separatorTableColumn = this.targetTableView.addSeparator("separator" + System.currentTimeMillis());
        separatorTableColumn.setId("separator" + System.currentTimeMillis());
        ColumnToolbarMenuRow<S> columnToolbarMenuRow = this.getColumnToolbarMenuRow(separatorTableColumn);
        columnToolbarMenuRow.setVisible(true);
        int index = this.getSelectionModel().getSelectedIndex() == -1 ? this.getItems().size() : this.getSelectionModel().getSelectedIndex() + 1;
        this.data.add(index, columnToolbarMenuRow);
        this.getSelectionModel().select(index);
        this.smoothScrollTo(index);
    }
}

