/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter;

import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.BulkAppender;
import com.deutscheboerse.ui.jfx.util.binding.ObservableListWrapperWithBulkOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.scene.control.TableView;

public class SortingTableItemsAppender<T>
implements Consumer<T>,
BulkAppender<T> {
    private final TableView<T> tableView;

    public SortingTableItemsAppender(TableView<T> tableView) {
        this.tableView = tableView;
    }

    @Override
    public void accept(T t) {
        if (this.tableView.getComparator() == null || this.tableView.getItems().isEmpty()) {
            this.tableView.getItems().add(t);
        } else {
            this.addToCorrectPosition(this.tableView.getItems(), this.tableView.getComparator(), t);
        }
    }

    private void addToCorrectPosition(List<T> list, Comparator<T> comparator, T t) {
        int index = Collections.binarySearch(list, t, comparator);
        if (index < 0) {
            list.add(index * -1 - 1, t);
        } else {
            list.add(index, t);
        }
    }

    @Override
    public void bulkAppend(Collection<? extends T> items) {
        if (this.tableView.getComparator() == null) {
            this.tableView.getItems().addAll(items);
        } else {
            ObservableList<T> list = this.tableView.getItems();
            Comparator<T> comparator = this.tableView.getComparator();
            Runnable bulkAdd = () -> items.forEach(item -> this.addToCorrectPosition(list, comparator, item));
            if (list instanceof ObservableListWrapperWithBulkOperation) {
                ((ObservableListWrapperWithBulkOperation)list).doBulkOperation(bulkAdd);
            } else {
                bulkAdd.run();
            }
        }
    }
}

