/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.TotpConfigPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.TotpKeyDialog;
import com.deutscheboerse.comxerv.comtrader.jfx.service.NotificationService;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.user.ChangePasswordService;
import com.deutscheboerse.comxerv.comtrader.service.user.TotpResponseHandler;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.google.inject.Inject;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;

public class TotpConfigDialog
extends Dialog<Void> {
    private final TotpConfigPane totpConfigPane;
    private final NotificationService.Notifier notifier;
    private final ApplicationContext appContext;
    private final UserAlertService userAlertService;
    private Window parent;

    @Inject
    public TotpConfigDialog(ApplicationContext appContext) {
        this.appContext = appContext;
        this.userAlertService = this.appContext.getService(UserAlertService.class);
        this.totpConfigPane = new TotpConfigPane(appContext);
        this.notifier = appContext.getService(NotificationService.class).createNotifier(this.getDialogPane(), Pos.BOTTOM_CENTER);
        this.getDialogPane().setContent(this.totpConfigPane);
        this.setGraphic(new IconView("icon-info-32"));
        StyleUtil.addStyleClass(this.getDialogPane(), "jfxDialog");
        this.setTitle(Util.getLabel("totp_dialog_title"));
        this.setHeaderText(Util.getLabel("totp_dialog_status"));
        this.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        FxUtil.runLater(() -> this.totpConfigPane.getOldPassword().requestFocus());
    }

    public void show(Window parent) {
        this.parent = parent;
        this.prepare();
        this.showAndWait();
    }

    protected void prepare() {
        this.initOwner(this.parent);
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind(this.totpConfigPane.getOldPassword().textProperty().isEmpty());
        okButton.addEventFilter(ActionEvent.ACTION, (? super T event) -> {
            this.doChange();
            event.consume();
        });
    }

    private TotpResponseHandler createTotpResponseHandler() {
        return new TotpResponseHandler(){

            @Override
            public void handleResponse(String secret) {
                if (StringUtils.isEmpty(secret)) {
                    TotpConfigDialog.this.userAlertService.showConfirmationDialog(Util.getLabel("totp_dialog_authentication"), Util.getLabel("totp_dialog_disabled"), UserAlertService.Flag.INFO);
                } else {
                    FxUtil.runInFxThread(() -> TotpConfigDialog.this.showQrDialog(secret));
                }
                FxUtil.runInFxThread(() -> TotpConfigDialog.this.close());
            }

            @Override
            public ResponseHandler getErrorHandler() {
                return response -> FxUtil.runInFxThread(() -> TotpConfigDialog.this.notifier.showNotification(response));
            }
        };
    }

    private void showQrDialog(String secret) {
        this.appContext.getService(TotpKeyDialog.class).show(this.parent, secret);
    }

    private void doChange() {
        Session session = this.appContext.getService(BackendConnectionGateway.class).getSession();
        ChangePasswordService changePasswordService = this.appContext.getService(ChangePasswordService.class, session.getExchange());
        String oldPwd = this.totpConfigPane.getOldPassword().getText();
        changePasswordService.configureTotpPassword(oldPwd, this.createTotpResponseHandler());
    }
}

