/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.comxerv.comtrader.entities.comxerv.OrderQuoteNotification;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.AcceptOrRejectType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AccountTypeChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AotChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.BalancingGroupChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.BlockProductField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DirectionToggle;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ForBalancingGroupField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.LoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.MemberField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.NumberTextField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.OpenCloseIndicatorChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.OrderRestrictionChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.OrderStatusChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.OrderTypeChoiceBoxCx;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.TextFieldWithTemplates;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.UserField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ValidTillField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ValidityRestrictionChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.YesNoChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.AddToBasketButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.ClearButtonMode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.CloseButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderBindingUtil;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.PeakPriceDeltaField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.PeakQuantityField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.PriceField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.QuantityField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.ResetButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.ShowErrorsButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.StopPriceField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.SubmitButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.VwapComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract.BlockContractField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract.BlockContractFieldWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract.ContractFieldWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract.SingleContractFieldWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.service.NotificationService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.MarketSelectionEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.deutscheboerse.comxerv.comtrader.jfx.util.FocusTraversalRestrictionUtils;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.comxerv.ProductValidator;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderMarketBasedColumn;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.OnBehalfChangeEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OtcOrderService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketFullException;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesEntry;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOrderEntryPanel
extends AbstractPanel {
    private static final Logger LOG = LoggerFactory.getLogger(BaseOrderEntryPanel.class);
    static final SettingsService.Settings<String> ORDER_TEMPLATES = new SettingsService.Settings<String>("order-templates", "");
    private final DragAndDropService dragAndDropService;
    private final UserAlertService userAlertService;
    private final BackendConnectionGateway backendConnectionGateway;
    private final OrderValidationService validationService;
    private final OrderPreferencesService orderPreferencesService;
    private final OrderEntryProtectionService orderEntryProtectionService;
    private final OrderSender orderSender;
    private final UserService userService;
    private final MessagePublisher messagePublisher;
    private final ChangeListener<Exchange> activeExchangeChange;
    private final DataModel<Long, Order> orderDataModel;
    private final DataModel<String, BalancingGroup> balancingGroupDataModel;
    private final ProductValidator productValidator;
    private final ObjectProperty<Order> order;
    private final ObjectProperty<RequestType> requestType;
    private final BooleanProperty submitAvailable;
    private final BooleanProperty basketAvailable;
    private final BooleanProperty guiValid;
    private final BasketService basketService;
    private final BooleanProperty submitting;
    private final ClearButtonMode clearButtonMode;
    private final boolean basketMode;
    private final boolean blockMode;
    private final BooleanProperty isNewOrder;
    private final ObservableValue<User> currentUser;
    private final BooleanProperty isBlockContract;
    private final BooleanProperty isFutureContractWithOpenCloseCapable;
    private final BooleanProperty isProductLocationEnabled;
    private final NotificationService.Notifier notifier;
    private final TradingSettingsService tradingSettingsService;
    private ContractFieldWrapper contractField;
    private BlockProductField blockProductField;
    @FXML
    private VBox productContainer;
    @FXML
    private Label productLabel;
    @FXML
    private DirectionToggle directionToggle;
    @FXML
    private ValidTillField dateTimeField;
    @FXML
    private TextFieldWithTemplates orderTextField;
    @FXML
    private TextFieldWithTemplates locationField;
    @FXML
    private Label locationLabel;
    @FXML
    private YesNoChoiceBox marketBasedChoiceBox;
    @FXML
    private Label marketBasedLabel;
    @FXML
    private TextFieldWithTemplates contractReferenceField;
    @FXML
    private Label contractReferenceLabel;
    @FXML
    private TextFieldWithTemplates facilityTypeField;
    @FXML
    private Label facilityTypeLabel;
    @FXML
    private NumberTextField usageFractionField;
    @FXML
    private Label usageFractionLabel;
    @FXML
    private PriceField priceField;
    @FXML
    private StopPriceField stopPriceField;
    @FXML
    private QuantityField quantityField;
    @FXML
    private ValidityRestrictionChoiceBox validityRestrictionChoiceBox;
    @FXML
    private ContractField singleContractField;
    @FXML
    private BlockContractField frontContractField;
    @FXML
    private BlockContractField rearContractField;
    @FXML
    private OrderRestrictionChoiceBox orderRestrictionChoiceBox;
    @FXML
    private OrderStatusChoiceBox orderStatusChoiceBox;
    @FXML
    private DeliveryAreaChoiceBox deliveryAreaChoiceBox;
    @FXML
    private AotChoiceBox aotChoiceBox;
    @FXML
    private Label aotLabel;
    @FXML
    private BalancingGroupChoiceBox balancingGroupChoiceBox;
    @FXML
    private PeakQuantityField peakQuantityField;
    @FXML
    private PeakPriceDeltaField peakPriceDeltaField;
    @FXML
    private OpenCloseIndicatorChoiceBox openCloseIndicatorField;
    @FXML
    private AccountTypeChoiceBox accountTypeChoiceBox;
    @FXML
    private OrderTypeChoiceBoxCx orderTypeChoiceBox;
    @FXML
    private VBox peakQuantityContainer;
    @FXML
    private VBox peakPriceDeltaContainer;
    @FXML
    private VBox stopPriceContainer;
    @FXML
    private VBox openCloseIndicatorContainer;
    @FXML
    private Label peakQuantityLabel;
    @FXML
    private Label peakPriceDeltaLabel;
    @FXML
    private Label openCloseIndicatorLabel;
    @FXML
    private Pane deliveryAreaChoiceBoxContainer;
    @FXML
    private ForBalancingGroupField forBalancingGroupField;
    @FXML
    private UserField userField;
    @FXML
    private MemberField memberField;
    @FXML
    private Label priceLabel;
    @FXML
    private Label stopPriceLabel;
    @FXML
    private ShowErrorsButton showErrorsButton;
    @FXML
    private SubmitButton submitButton;
    @FXML
    private ResetButton resetButton;
    @FXML
    private CloseButton closeButton;
    @FXML
    private AddToBasketButton addButton;
    @FXML
    private VwapComponent vwapComponent;
    @FXML
    private HBox buttonsContainer;
    @FXML
    private HBox submitButtonContainer;
    @FXML
    private Parent container;

    protected BaseOrderEntryPanel(ApplicationContext appContext, ClearButtonMode clearButtonMode, boolean basketMode, boolean blockMode) {
        super(appContext);
        this.clearButtonMode = clearButtonMode;
        this.basketMode = basketMode;
        this.blockMode = blockMode;
        this.basketService = appContext.getService(BasketService.class);
        this.orderSender = appContext.getService(OrderSender.class);
        this.orderPreferencesService = appContext.getService(OrderPreferencesService.class);
        this.validationService = appContext.getService(OrderValidationService.class);
        this.messagePublisher = appContext.getService(MessagePublisher.class);
        this.dragAndDropService = appContext.getService(DragAndDropService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.userService = appContext.getService(UserService.class);
        this.backendConnectionGateway = appContext.getService(BackendConnectionGateway.class);
        this.balancingGroupDataModel = appContext.getDataModel(BalancingGroup.class);
        this.productValidator = appContext.getService(ProductValidator.class);
        this.orderDataModel = appContext.getDataModel(Order.class);
        this.notifier = appContext.getService(NotificationService.class).createNotifier(this, Pos.BOTTOM_CENTER);
        this.tradingSettingsService = appContext.getService(TradingSettingsService.class);
        this.orderEntryProtectionService = appContext.getService(OrderEntryProtectionService.class);
        this.submitting = new SimpleBooleanProperty(false);
        this.order = new SimpleObjectProperty<Order>(new Order());
        this.requestType = new SimpleObjectProperty<RequestType>();
        this.submitAvailable = new SimpleBooleanProperty(false);
        this.basketAvailable = new SimpleBooleanProperty(false);
        this.guiValid = new SimpleBooleanProperty(false);
        this.currentUser = this.userService.currentUserProperty();
        this.isBlockContract = new SimpleBooleanProperty(false);
        this.isFutureContractWithOpenCloseCapable = new SimpleBooleanProperty(false);
        this.isProductLocationEnabled = new SimpleBooleanProperty(false);
        this.isNewOrder = new SimpleBooleanProperty();
        ObservableObjectValue<Exchange> activeExchange = this.getAppContext().getService(ActiveExchange.class).getActiveExchange();
        this.activeExchangeChange = (observableValue, oldExchange, newExchange) -> {
            this.showExchangeSpecificInput((Exchange)newExchange);
            this.reset();
        };
        activeExchange.addListener(new WeakChangeListener<Exchange>(this.activeExchangeChange));
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.singleContractField != null && this.frontContractField == null && this.rearContractField == null) {
            this.contractField = new SingleContractFieldWrapper(this.singleContractField);
        } else if (this.singleContractField == null && this.frontContractField != null && this.rearContractField != null) {
            this.blockProductField = new BlockProductField(this.getAppContext());
            this.blockProductField.setPrefWidth(105.0);
            this.blockProductField.setMinWidth(105.0);
            this.contractField = new BlockContractFieldWrapper(this.getAppContext(), this.frontContractField, this.rearContractField, this.blockProductField);
            this.productLabel.setText(Util.getLabel("commons_product"));
            this.productContainer.getChildren().add(this.blockProductField);
        } else {
            throw new IllegalStateException("Either singleContractField or frontContractField and rearContractField must be initialized.");
        }
        ObjectProperty<Direction> directionProperty = this.directionToggle.valueProperty();
        final ObjectProperty<Contract> contractProperty = this.contractField.valueProperty();
        ObjectProperty<OrderType> orderTypeProperty = this.orderTypeChoiceBox.valueProperty();
        ObservableValue<Product> productBinding = OrderBindingUtil.productBinding(this.contractField.valueProperty());
        ObjectProperty<LongDisplayValue> priceProperty = this.priceField.valueProperty();
        ObjectProperty<LongDisplayValue> quantityProperty = this.quantityField.valueProperty();
        ObjectProperty<LongDisplayValue> peakQuantityProperty = this.peakQuantityField.valueProperty();
        this.isNewOrder.bind(DependentBinding.get(this::isNew, this.order));
        this.requestType.bind(DependentBinding.get(() -> this.isNewOrder.get() ? RequestType.ADD : RequestType.MODIFY, this.isNewOrder));
        StyleUtil.addStyleClass(this.container, "buy", "sell", this.directionToggle.getValue() == Direction.BUY);
        SimpleBooleanProperty modifiableFieldsDisableCondition = new SimpleBooleanProperty();
        this.order.addListener((observableValue, oldOrder, newOrder) -> {
            modifiableFieldsDisableCondition.setValue(newOrder.getPreArrangedAcceptOrReject() == AcceptOrRejectType.ACCEPT);
            this.unbind((Order)oldOrder);
            this.bind((Order)newOrder);
        });
        this.directionToggle.disableProperty().bind(this.isNewOrder.not().or(modifiableFieldsDisableCondition));
        this.directionToggle.valueProperty().addListener((observableValue, oldDirection, newDirection) -> StyleUtil.addStyleClass(this.container, "buy", "sell", newDirection == Direction.BUY));
        this.submitAvailable.bind(this.validationService.isOrderSubmittableProperty(this.order));
        this.basketAvailable.bind(this.validationService.isOrderBasketableProperty(this.order));
        this.guiValid.bind(this.peakPriceDeltaField.validProperty().and(this.userField.validProperty()).and(this.memberField.validProperty()));
        this.showErrorsButton.init(this.userAlertService, this.validationService, this.validationService.validationResultProperty(this.order));
        this.addButton.disableProperty().bind(new DependentBinding<Boolean>(new Observable[]{this.basketAvailable, this.isNewOrder, this.guiValid, orderTypeProperty, contractProperty, this.userField.valueProperty(), this.memberField.valueProperty()}){

            @Override
            protected Boolean computeValue() {
                return !BaseOrderEntryPanel.this.basketAvailable.get() || !BaseOrderEntryPanel.this.isNewOrder.get() || BaseOrderEntryPanel.this.guiValid.not().get() || OrderType.OTC_PREARRANGED.equals(((Order)BaseOrderEntryPanel.this.order.get()).getOrderType()) || contractProperty.isNull().get() || BaseOrderEntryPanel.this.backendConnectionGateway.getSession() == null || BaseOrderEntryPanel.this.userField.valueProperty().isNotNull().get() || BaseOrderEntryPanel.this.memberField.valueProperty().isNotNull().get();
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (!this.addButton.isDisabled() && keyEvent.isShiftDown() && keyEvent.getCode() == KeyCode.ENTER) {
                this.addButton.fire();
                keyEvent.consume();
            }
        });
        this.vwapComponent.initializeValue(this.order);
        this.vwapComponent.getVwapLabel().textProperty().bind(new DependentBinding<String>(this, new Observable[]{contractProperty}){

            @Override
            protected String computeValue() {
                Contract c = (Contract)contractProperty.get();
                return c == null ? Util.getLabel("commons_vwapShort_colon") : Util.getLabel("commons_vwapShort_with_currency_colon", c.getProduct().getCurrencyCode());
            }
        });
        if (this.clearButtonMode == ClearButtonMode.CLOSE) {
            this.buttonsContainer.getChildren().remove(this.resetButton);
        } else if (this.clearButtonMode == ClearButtonMode.RESET) {
            this.buttonsContainer.getChildren().remove(this.closeButton);
        }
        this.submitButton.init(this.isNewOrder, directionProperty, this.order);
        if (this.basketMode) {
            this.submitButtonContainer.getChildren().remove(this.submitButton);
            this.submitButton.setDisable(true);
            this.addButton.registerDefaultAction(this.getFields());
        } else {
            this.submitButton.disableProperty().bind(this.submitAvailable.not().or(this.submitting).or(this.guiValid.not()));
            this.submitButton.registerDefaultAction(this.getFields());
        }
        this.submitting.addListener(new ChangeListener<Boolean>(){
            private final LoadingIndicator loadingIndicator;
            {
                this.loadingIndicator = new LoadingIndicator(BaseOrderEntryPanel.this, Collections.singletonList(Order.class));
            }

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean aBoolean, Boolean isSubmitting) {
                if (isSubmitting.booleanValue()) {
                    this.loadingIndicator.handleLoadingStarted(null);
                    this.loadingIndicator.handleEntityLoadingStarted(new EntityLoadingStartedEvent<Order>(Order.class));
                } else {
                    this.loadingIndicator.handleEntityLoadingFinished(new EntityLoadingFinishedEvent<Order>(Order.class));
                }
            }
        });
        this.setOnDragOver(event -> {
            if (this.hasRelevantContent((DragEvent)event)) {
                event.acceptTransferModes(TransferMode.ANY);
            }
            event.consume();
        });
        this.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            boolean dropCompleted = false;
            if (this.dragAndDropService.hasOrderList(db)) {
                this.populateFromOrder(this.dragAndDropService.getOrderList(db).get(0));
                dropCompleted = true;
            } else if (this.dragAndDropService.hasContractList(db)) {
                this.populateFromContract(this.dragAndDropService.getContractList(db).get(0));
                dropCompleted = true;
            } else if (this.dragAndDropService.hasBasicOrderbookEntryList(db)) {
                this.populateFromOrder(this.dragAndDropService.getBasicOrderbookEntryList(db).get(0));
                dropCompleted = true;
            }
            event.setDropCompleted(dropCompleted);
            event.consume();
        });
        FocusTraversalRestrictionUtils.registerListenersToGuiComponents(this.directionToggle.getBuyButton(), this.resetButton);
        this.deliveryAreaChoiceBox.contractProperty().bind(this.contractField.valueProperty());
        this.deliveryAreaChoiceBox.balancingGroupProperty().bind(this.balancingGroupChoiceBox.valueProperty());
        this.deliveryAreaChoiceBox.onBehalfUserProperty().bind(this.userField.valueProperty());
        this.contractField.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null && this.isNewOrder.get()) {
                this.loadValuesFromOrderPreferences((Contract)newValue);
            }
            this.openCloseIndicatorFieldBinding((Order)this.order.get());
        });
        this.order.addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null && this.isNewOrder.get() && newValue.getContract() != null) {
                this.loadValuesFromOrderPreferences(newValue.getContract());
            }
            this.openCloseIndicatorFieldBinding((Order)this.order.get());
        });
        this.dateTimeField.deliveryAreaProperty().bind(this.deliveryAreaChoiceBox.valueProperty());
        this.dateTimeField.contractProperty().bind(contractProperty);
        this.userField.memberProperty().bind(this.memberField.valueProperty());
        this.forBalancingGroupField.setSelectedItemRemovedCallback(() -> FxUtil.runInFxThread(() -> {
            if (!this.forBalancingGroupField.isDisabled()) {
                this.reset();
            }
        }));
        this.forBalancingGroupField.productProperty().bind(productBinding);
        this.balancingGroupChoiceBox.onBehalfUserProperty().bind(this.userField.valueProperty());
        this.balancingGroupChoiceBox.contractProperty().bind(contractProperty);
        this.balancingGroupChoiceBox.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null && (this.deliveryAreaChoiceBox.getValue() == null || newValue.getDeliveryAreaIds().contains(((DeliveryArea)this.deliveryAreaChoiceBox.getValue()).getDisplayName()))) {
                this.deliveryAreaChoiceBox.applyDefaultValue();
            }
        });
        final ObjectProperty<ExecutionRestriction> executionRestrictionObjectProperty = this.orderRestrictionChoiceBox.valueProperty();
        this.validityRestrictionChoiceBox.disableProperty().bind(executionRestrictionObjectProperty.isEqualTo(ExecutionRestriction.IMMEDIATE_OR_CANCEL).or(executionRestrictionObjectProperty.isEqualTo(ExecutionRestriction.FILL_OR_KILL)).or(modifiableFieldsDisableCondition));
        this.orderTypeChoiceBox.contractProperty().bind(contractProperty);
        this.orderRestrictionChoiceBox.contractProperty().bind(contractProperty);
        this.isFutureContractWithOpenCloseCapable.bind(DependentBinding.get(Contract::supportsOpenCloseIndicator, contractProperty));
        this.isProductLocationEnabled.bind(DependentBinding.get(() -> contractProperty.isNotNull().get() && ((Contract)contractProperty.get()).getProduct().isLocationsEnabled(), contractProperty));
        this.orderRestrictionChoiceBox.disableProperty().bind(Bindings.or(this.isNewOrder, this.isBlockContract.not()).not().or(this.orderRestrictionChoiceBox.getHasOneOrLessItemsBinding()).or(this.orderStatusChoiceBox.valueProperty().isEqualTo(OrderStatus.HIBERNATE)));
        this.orderStatusChoiceBox.disableProperty().bind(this.isNewOrder.not());
        this.orderStatusChoiceBox.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            if (OrderStatus.HIBERNATE.equals(newValue)) {
                this.orderRestrictionChoiceBox.setValue(this.orderRestrictionChoiceBox.getContractType().isBlock() ? ExecutionRestriction.ALL_OR_NOTHING : ExecutionRestriction.NONE);
            }
        });
        this.contractField.disabledProperty().bind(this.isNewOrder.not());
        this.orderTextField.disableProperty().bind(Bindings.isNull(contractProperty));
        this.peakQuantityLabel.visibleProperty().bind(orderTypeProperty.isEqualTo(OrderType.ICEBERG));
        this.openCloseIndicatorLabel.disableProperty().bind(this.isFutureContractWithOpenCloseCapable.not());
        this.openCloseIndicatorField.disableProperty().bind(this.isFutureContractWithOpenCloseCapable.not());
        this.openCloseIndicatorField.futureProductProperty().bind(this.isFutureContractWithOpenCloseCapable);
        this.priceField.init(contractProperty);
        this.priceField.disableProperty().bind(Bindings.isNull(contractProperty).or(modifiableFieldsDisableCondition));
        this.priceLabel.textProperty().bind(new DependentBinding<String>(this, new Observable[]{contractProperty}){

            @Override
            protected String computeValue() {
                Contract c = (Contract)contractProperty.get();
                return c == null ? Util.getLabel("commons_price") : Util.getLabel("commons_price_with_currency", c.getProduct().getCurrencyCode());
            }
        });
        this.stopPriceField.init(contractProperty, orderTypeProperty);
        this.stopPriceField.disableProperty().bind(Bindings.or(orderTypeProperty.isNotEqualTo(OrderType.STOP), contractProperty.isNull()).or(modifiableFieldsDisableCondition));
        this.stopPriceField.limitPriceProperty().bind(priceProperty);
        this.stopPriceField.directionProperty().bind(directionProperty);
        this.stopPriceField.disableProperty().bind(Bindings.or(orderTypeProperty.isNotEqualTo(OrderType.STOP), contractProperty.isNull()).or(modifiableFieldsDisableCondition));
        this.stopPriceLabel.textProperty().bind(new DependentBinding<String>(this, new Observable[]{contractProperty}){

            @Override
            protected String computeValue() {
                Contract c = (Contract)contractProperty.get();
                return c == null ? Util.getLabel("commons_stopPrice") : Util.getLabel("commons_stopPrice_with_currency", c.getProduct().getCurrencyCode());
            }
        });
        this.quantityField.init(contractProperty, orderTypeProperty);
        this.quantityField.disableProperty().bind(Bindings.isNull(contractProperty).or(modifiableFieldsDisableCondition));
        this.peakPriceDeltaField.init(directionProperty, contractProperty, orderTypeProperty, priceProperty, quantityProperty, peakQuantityProperty);
        this.peakPriceDeltaLabel.visibleProperty().bind(this.peakPriceDeltaField.disableProperty().not());
        this.peakQuantityField.init(contractProperty, orderTypeProperty, quantityProperty);
        this.dateTimeField.disableProperty().bind(this.validityRestrictionChoiceBox.valueProperty().isNotEqualTo(ValidityRestriction.GOOD_TILL_DATE));
        this.forBalancingGroupField.disableProperty().bind(orderTypeProperty.isNotEqualTo(OrderType.OTC_PREARRANGED).or(this.isNewOrder.not()));
        this.balancingGroupChoiceBox.disableProperty().bind(this.balancingGroupChoiceBox.getHasOneOrLessItemsBinding().or(this.isNewOrder.not()));
        this.deliveryAreaChoiceBox.disableProperty().bind(Bindings.and(this.isNewOrder.not(), modifiableFieldsDisableCondition.not()).or(this.deliveryAreaChoiceBox.getHasOneOrLessItemsBinding()));
        this.accountTypeChoiceBox.disableProperty().bind(this.isNewOrder.not().or(modifiableFieldsDisableCondition));
        this.stopPriceContainer.visibleProperty().bind(orderTypeProperty.isEqualTo(OrderType.STOP));
        this.peakQuantityContainer.visibleProperty().bind(this.stopPriceContainer.visibleProperty().not());
        this.peakPriceDeltaContainer.visibleProperty().bind(this.stopPriceContainer.visibleProperty().not());
        this.orderRestrictionChoiceBox.orderTypeProperty().bind(orderTypeProperty);
        this.orderRestrictionChoiceBox.contractProperty().bind(contractProperty);
        executionRestrictionObjectProperty.addListener((observableValue, oldValue, newValue) -> {
            boolean isFOKorIOC;
            boolean wasFOKorIOC = oldValue == ExecutionRestriction.FILL_OR_KILL || oldValue == ExecutionRestriction.IMMEDIATE_OR_CANCEL;
            boolean bl = isFOKorIOC = newValue == ExecutionRestriction.FILL_OR_KILL || newValue == ExecutionRestriction.IMMEDIATE_OR_CANCEL;
            if (isFOKorIOC) {
                this.validityRestrictionChoiceBox.setListedItems(Collections.singleton(ValidityRestriction.NONE));
                this.validityRestrictionChoiceBox.setValue(ValidityRestriction.NONE);
            } else if (wasFOKorIOC) {
                this.validityRestrictionChoiceBox.setDefaultItems();
                this.validityRestrictionChoiceBox.loadDefaultValue();
            }
        });
        orderTypeProperty.addListener((observableValue, oldValue, newValue) -> {
            if (oldValue == OrderType.OTC_PREARRANGED && newValue != null && newValue != OrderType.OTC_PREARRANGED) {
                this.forBalancingGroupField.setText(null);
            }
        });
        this.accountTypeChoiceBox.reset();
        if (this.aotChoiceBox != null) {
            this.aotChoiceBox.visibleProperty().bind(new DependentBinding<Boolean>(new Observable[]{contractProperty, executionRestrictionObjectProperty}){

                @Override
                protected Boolean computeValue() {
                    ExecutionRestriction executionRestriction = (ExecutionRestriction)executionRestrictionObjectProperty.getValue();
                    return contractProperty.isNotNull().get() && BaseOrderEntryPanel.this.productValidator.isProductAotEnabled(((Contract)contractProperty.get()).getProduct()) && executionRestriction != ExecutionRestriction.FILL_OR_KILL && executionRestriction != ExecutionRestriction.IMMEDIATE_OR_CANCEL && executionRestriction != ExecutionRestriction.ALL_OR_NOTHING;
                }
            });
            this.aotLabel.visibleProperty().bind(this.aotChoiceBox.visibleProperty());
            this.aotChoiceBox.visibleProperty().addListener((observableValue, oldValue, newValue) -> {
                if (BooleanUtils.isFalse(newValue)) {
                    this.aotChoiceBox.setValue(Boolean.FALSE);
                }
            });
        }
        contractProperty.addListener((observable2, oldValue, newValue) -> {
            boolean wasAotContractEnabled;
            boolean bl = wasAotContractEnabled = oldValue != null && this.productValidator.isProductAotEnabled(oldValue.getProduct());
            if (!wasAotContractEnabled && this.aotChoiceBox != null) {
                this.aotChoiceBox.setValue(this.productValidator.computeAotEnabled((Contract)newValue));
            }
        });
        this.isProductLocationEnabled.addListener((observable2, oldValue, newValue) -> {
            if (BooleanUtils.isNotFalse(oldValue) && BooleanUtils.isFalse(newValue)) {
                this.resetLocationEnabledInputFields();
            }
            if (BooleanUtils.isNotTrue(oldValue) && BooleanUtils.isTrue(newValue)) {
                this.marketBasedChoiceBox.setValue(OrderMarketBasedColumn.DEFAULT_MARKET_BASED_VALUE);
            }
        });
        this.initializeLocationField(contractProperty);
        this.initializeMarketBasedChoiceBox();
        this.initializeContractReferenceField();
        this.initializeFacilityTypeField();
        this.initializeUsageFractionField();
        this.reset();
    }

    private void initializeLocationField(final ReadOnlyObjectProperty<Contract> contractProperty) {
        if (this.locationField != null) {
            this.locationField.visibleProperty().bind(new DependentBinding<Boolean>(this, new Observable[]{contractProperty}){

                @Override
                protected Boolean computeValue() {
                    return contractProperty.isNotNull().get() && ((Contract)contractProperty.get()).getProduct().isLocationsEnabled();
                }
            });
            this.locationLabel.visibleProperty().bind(this.locationField.visibleProperty());
        }
    }

    private void initializeMarketBasedChoiceBox() {
        if (this.marketBasedChoiceBox != null) {
            this.marketBasedChoiceBox.visibleProperty().bind(this.locationField.visibleProperty());
            this.marketBasedLabel.visibleProperty().bind(this.locationField.visibleProperty());
            this.marketBasedChoiceBox.includeDefaultNullProperty().bind(this.isProductLocationEnabled.not());
        }
    }

    private void initializeContractReferenceField() {
        if (this.contractReferenceField != null) {
            this.contractReferenceField.visibleProperty().bind(this.locationField.visibleProperty());
            this.contractReferenceLabel.visibleProperty().bind(this.locationField.visibleProperty());
        }
    }

    private void initializeFacilityTypeField() {
        if (this.facilityTypeField != null) {
            this.facilityTypeField.visibleProperty().bind(this.locationField.visibleProperty());
            this.facilityTypeLabel.visibleProperty().bind(this.locationField.visibleProperty());
        }
    }

    private void initializeUsageFractionField() {
        if (this.usageFractionField != null) {
            this.usageFractionField.visibleProperty().bind(this.locationField.visibleProperty());
            this.usageFractionLabel.visibleProperty().bind(this.locationField.visibleProperty());
        }
    }

    private boolean isNew(Order order) {
        return order == null || order.getId() == null || this.orderDataModel.findById((Long)order.getId()) == null || order.getStatus() == OrderStatus.ERROR;
    }

    private void loadValuesFromOrderPreferences(Contract contract) {
        Optional<OrderPreferencesEntry> orderPreferencesForContract = this.orderPreferencesService.getOrderPreferencesForContract(contract);
        if (orderPreferencesForContract.isPresent()) {
            OrderPreferencesEntry orderPreferencesEntry = orderPreferencesForContract.get();
            this.orderTypeChoiceBox.setValue(orderPreferencesEntry.getOrderType());
            LongDisplayValue quantity = Optional.ofNullable(orderPreferencesEntry.getQuantity()).orElse(Optional.ofNullable(this.quantityField.getValue()).orElse(LongDisplayValue.ZERO));
            this.quantityField.setValue(quantity.applyShift(contract.getProduct().getQuantityDecimalShift()));
            if (this.dateTimeField.getParent() != null) {
                this.accountTypeChoiceBox.setValue(orderPreferencesEntry.getAccountType());
                this.validityRestrictionChoiceBox.setValue(orderPreferencesEntry.getValidityRestriction());
            }
            this.openCloseIndicatorField.setValue(orderPreferencesEntry.getOpenOrClose());
            this.deliveryAreaChoiceBox.getListedItems().stream().filter(deliveryArea -> deliveryArea.equals(orderPreferencesEntry.getDeliveryArea())).findFirst().ifPresent(d -> this.deliveryAreaChoiceBox.setValue(d));
        }
    }

    private void loadValuesFromOrderPreferences(Order order) {
        Optional<OrderPreferencesEntry> orderPreferencesForContract = this.orderPreferencesService.getOrderPreferencesForContract(order.getContract());
        if (orderPreferencesForContract.isPresent()) {
            OrderPreferencesEntry orderPreferencesEntry = orderPreferencesForContract.get();
            if (order.getRemainingQuantity() == null || order.getRemainingQuantity().equals(LongDisplayValue.ZERO)) {
                LongDisplayValue quantity = Optional.ofNullable(orderPreferencesEntry.getQuantity()).orElse(LongDisplayValue.ZERO);
                order.setRemainingQuantity(quantity.applyShift(order.getProduct().getQuantityDecimalShift()));
            }
            if (order.getOrderType() == null) {
                order.setOrderType(orderPreferencesEntry.getOrderType());
            }
        }
    }

    private void showExchangeSpecificInput(Exchange exchange) {
        if (exchange != null) {
            this.deliveryAreaChoiceBoxContainer.setVisible(exchange.supportsDeliveryAreas());
            this.openCloseIndicatorContainer.setVisible(exchange.getSystemInfo().supportsOpenCloseIndicator());
        } else {
            this.deliveryAreaChoiceBoxContainer.setVisible(false);
            this.openCloseIndicatorContainer.setVisible(false);
        }
    }

    private boolean hasRelevantContent(DragEvent event) {
        Dragboard db = event.getDragboard();
        return this.dragAndDropService.hasOrderList(db) || this.dragAndDropService.hasContractList(db) || this.dragAndDropService.hasBasicOrderbookEntryList(db);
    }

    private Collection<Node> getFields() {
        return Lists.newArrayList(this.deliveryAreaChoiceBox, this.singleContractField, this.balancingGroupChoiceBox, this.accountTypeChoiceBox, this.priceField, this.quantityField, this.orderTypeChoiceBox, this.peakQuantityField, this.peakPriceDeltaField, this.stopPriceField, this.forBalancingGroupField, this.openCloseIndicatorField, this.orderTextField, this.locationField, this.marketBasedChoiceBox, this.contractReferenceField, this.facilityTypeField, this.usageFractionField, this.orderRestrictionChoiceBox, this.validityRestrictionChoiceBox, this.dateTimeField, this.directionToggle, this.frontContractField, this.rearContractField, this.memberField, this.userField, this.aotChoiceBox).stream().filter(Objects::nonNull).toList();
    }

    private void bind(Order newOrder) {
        if (newOrder == null) {
            return;
        }
        OrderBindingUtil.setAndBind(newOrder.directionProperty(), this.directionToggle.valueProperty());
        OrderBindingUtil.setAndBind(newOrder.contractProperty(), this.contractField.valueProperty());
        Optional.ofNullable(newOrder.getBalancingGroup()).ifPresent(this.balancingGroupChoiceBox::setValue);
        newOrder.balancingGroupProperty().bind(this.balancingGroupChoiceBox.valueProperty());
        this.deliveryAreaChoiceBox.setValue(newOrder.getDeliveryArea());
        newOrder.deliveryAreaProperty().bind(this.deliveryAreaChoiceBox.valueProperty());
        if (this.deliveryAreaChoiceBox.getValue() == null) {
            if (newOrder.getOrderType() == OrderType.OTC_PREARRANGED) {
                this.deliveryAreaChoiceBox.setIncludeDefaultNull(true);
            } else {
                this.deliveryAreaChoiceBox.applyDefaultValue();
            }
        }
        this.accountTypeChoiceBox.setValue(newOrder.getAccount());
        newOrder.accountProperty().bind(this.accountTypeChoiceBox.valueProperty());
        if (this.accountTypeChoiceBox.getValue() == null) {
            this.accountTypeChoiceBox.reset();
        }
        OrderBindingUtil.setAndBind(newOrder.limitPriceProperty(), this.priceField.valueProperty());
        OrderBindingUtil.setAndBind(newOrder.stopPriceProperty(), this.stopPriceField.valueProperty());
        OrderBindingUtil.setAndBind(newOrder.remainingQuantityProperty(), this.quantityField.valueProperty());
        this.orderTypeChoiceBox.init(this.isNewOrder.get(), this.isBalanceUser(), this.basketMode, newOrder.getOrderType());
        newOrder.orderTypeProperty().bind(this.orderTypeChoiceBox.valueProperty());
        Optional.ofNullable(newOrder.getPreArrangedBalancingGroupId()).map(this.balancingGroupDataModel::findById).map(BalancingGroup::getName).ifPresent(this.forBalancingGroupField::setText);
        newOrder.preArrangedBalancingGroupProperty().bind(this.forBalancingGroupField.valueProperty());
        this.orderRestrictionChoiceBox.setValue(newOrder.getExecutionRestriction());
        newOrder.executionRestrictionProperty().bind(this.orderRestrictionChoiceBox.valueProperty());
        if (this.orderRestrictionChoiceBox.getValue() == null) {
            this.orderRestrictionChoiceBox.setValue(ExecutionRestriction.NONE);
        }
        this.orderStatusChoiceBox.setValue(newOrder.getStatus());
        this.validityRestrictionChoiceBox.setValue(newOrder.getValidityRestriction());
        newOrder.validityRestrictionProperty().bind(this.validityRestrictionChoiceBox.valueProperty());
        if (this.validityRestrictionChoiceBox.getValue() == null) {
            this.validityRestrictionChoiceBox.loadDefaultValue();
        }
        if (newOrder.getValidityDate() != null && ValidityRestriction.GOOD_TILL_DATE == newOrder.getValidityRestriction()) {
            this.dateTimeField.loadValue(newOrder.getValidityDate());
        }
        newOrder.validityDateProperty().bind((ObservableValue<DateTime>)new DependentBinding<DateTime>(new Observable[]{this.dateTimeField.valueProperty(), this.contractField.valueProperty(), this.validityRestrictionChoiceBox.valueProperty()}){

            @Override
            protected DateTime computeValue() {
                Contract contract = (Contract)BaseOrderEntryPanel.this.contractField.valueProperty().get();
                if (contract == null || BaseOrderEntryPanel.this.validityRestrictionChoiceBox.getValue() != ValidityRestriction.GOOD_TILL_DATE) {
                    BaseOrderEntryPanel.this.dateTimeField.setText("");
                }
                return (DateTime)BaseOrderEntryPanel.this.dateTimeField.getValue();
            }
        });
        if (newOrder.getText() == null || newOrder.getText().isEmpty()) {
            this.orderTextField.setTextToDefault();
        } else {
            this.orderTextField.setText(newOrder.getText());
        }
        newOrder.textProperty().bind(this.orderTextField.textProperty());
        newOrder.onBehalfUserProperty().bind(this.userField.valueProperty());
        OrderBindingUtil.setAndBind(newOrder.peakQuantityProperty(), this.peakQuantityField.valueProperty());
        OrderBindingUtil.setAndBind(newOrder.peakPriceDeltaProperty(), this.peakPriceDeltaField.valueProperty());
        this.openCloseIndicatorFieldBinding(newOrder);
        this.aotBind(newOrder);
        this.locationFieldBinding(newOrder);
        this.marketBasedBind(newOrder);
        this.contractReferenceFieldBinding(newOrder);
        this.facilityTypeFieldBinding(newOrder);
        this.usageFractionFieldBinding(newOrder);
    }

    private void aotBind(Order newOrder) {
        if (this.aotChoiceBox != null) {
            if (newOrder.getAot() == null) {
                newOrder.setAot(this.productValidator.computeAotEnabled((Contract)this.contractField.valueProperty().get()));
            }
            OrderBindingUtil.setAndBind(newOrder.aotProperty(), this.aotChoiceBox.valueProperty());
        }
    }

    private void openCloseIndicatorFieldBinding(Order order) {
        if (order.getContract() != null && order.getContract().supportsOpenCloseIndicator()) {
            this.openCloseIndicatorField.setValue(order.getOpenOrClose());
            order.openOrCloseProperty().bind(this.openCloseIndicatorField.valueProperty());
        } else {
            this.openCloseIndicatorField.setValue(null);
            order.openOrCloseProperty().unbind();
        }
    }

    private void locationFieldBinding(Order order) {
        if (this.locationField != null) {
            if (StringUtils.isEmpty(order.getLocation())) {
                this.locationField.setTextToDefault();
            } else {
                this.locationField.setText(order.getLocation());
            }
            order.locationProperty().bind(this.locationField.textProperty());
        }
    }

    private void marketBasedBind(Order order) {
        if (this.marketBasedChoiceBox != null) {
            if (order.getProduct() != null && order.getProduct().isLocationsEnabled() && order.isMarketBased() == null) {
                this.marketBasedChoiceBox.setValue(OrderMarketBasedColumn.DEFAULT_MARKET_BASED_VALUE);
            }
            OrderBindingUtil.setAndBind(order.marketBasedProperty(), this.marketBasedChoiceBox.valueProperty());
        }
    }

    private void contractReferenceFieldBinding(Order order) {
        if (this.contractReferenceField != null) {
            if (StringUtils.isEmpty(order.getContractReference())) {
                this.contractReferenceField.setTextToDefault();
            } else {
                this.contractReferenceField.setText(order.getContractReference());
            }
            order.contractReferenceProperty().bind(this.contractReferenceField.textProperty());
        }
    }

    private void facilityTypeFieldBinding(Order order) {
        if (this.facilityTypeField != null) {
            if (StringUtils.isEmpty(order.getFacilityType())) {
                this.facilityTypeField.setTextToDefault();
            } else {
                this.facilityTypeField.setText(order.getFacilityType());
            }
            order.facilityTypeProperty().bind(this.facilityTypeField.textProperty());
        }
    }

    private void usageFractionFieldBinding(Order order) {
        if (this.usageFractionField != null) {
            if (order.getUsageFraction() == null) {
                this.usageFractionField.clear();
            } else {
                this.usageFractionField.setText(order.getUsageFraction().toString());
            }
            this.usageFractionField.textProperty().addListener((observableValue, oldValue, newValue) -> {
                if (StringUtils.isEmpty(newValue)) {
                    order.setUsageFraction(null);
                } else if (StringUtils.isNumeric(newValue)) {
                    order.setUsageFraction(Integer.valueOf(newValue));
                }
            });
        }
    }

    private void unbind(Order oldOrder) {
        if (oldOrder != null) {
            oldOrder.directionProperty().unbind();
            oldOrder.deliveryAreaProperty().unbind();
            oldOrder.contractProperty().unbind();
            oldOrder.balancingGroupProperty().unbind();
            oldOrder.accountProperty().unbind();
            oldOrder.limitPriceProperty().unbind();
            oldOrder.remainingQuantityProperty().unbind();
            oldOrder.orderTypeProperty().unbind();
            oldOrder.peakQuantityProperty().unbind();
            oldOrder.peakPriceDeltaProperty().unbind();
            oldOrder.stopPriceProperty().unbind();
            oldOrder.preArrangedBalancingGroupProperty().unbind();
            oldOrder.executionRestrictionProperty().unbind();
            oldOrder.validityRestrictionProperty().unbind();
            oldOrder.validityDateProperty().unbind();
            oldOrder.textProperty().unbind();
            oldOrder.onBehalfUserProperty().unbind();
            oldOrder.openOrCloseProperty().unbind();
            oldOrder.aotProperty().unbind();
            oldOrder.locationProperty().unbind();
            oldOrder.marketBasedProperty().unbind();
            oldOrder.contractReferenceProperty().unbind();
            oldOrder.facilityTypeProperty().unbind();
            oldOrder.usageFractionProperty().unbind();
        }
    }

    @Subscribe
    public void handleLoadingFinishedEvent(LoadingFinishedEvent event) {
        this.reset();
    }

    @Subscribe
    public void handleMarketSelectionEvent(MarketSelectionEvent event) {
        ContentTab contentTab = this.getContentTab();
        if (contentTab != null && contentTab.isSelected() && this.contractField.canHandleContract(event.getContract())) {
            event.markProcessed();
            BroadcastEntity<?> entity = event.getEntity();
            if (entity instanceof Order) {
                this.populateFromOrder((Order)entity);
            } else if (entity instanceof Orderbook) {
                this.populateFromOrderbook((Orderbook)entity);
            }
            this.directionToggle.setValue(event.getDirection());
            if (entity instanceof Order || entity instanceof Orderbook) {
                this.quantityField.getTextField().requestFocus();
            }
        }
    }

    public void populateFromOrderQuote(OrderQuoteNotification orderQuote) {
        Order newOrder = this.createEmptyOrder(orderQuote.getContract());
        newOrder.setRemainingQuantity(orderQuote.getQuantity());
        newOrder.setDirection(orderQuote.getDirection().reverse());
        newOrder.setDeliveryArea(orderQuote.getDeliveryArea());
        this.order.setValue(newOrder);
    }

    public void populateFromOrder(Order order) {
        Order orderToPopulate = new Order(order);
        if (orderToPopulate.getOrderType() == OrderType.ICEBERG && orderToPopulate.getRemainingQuantity().compareTo(orderToPopulate.getPeakQuantity()) < 0) {
            orderToPopulate.setOrderType(OrderType.REGULAR);
            orderToPopulate.setPeakQuantity(null);
            orderToPopulate.setPeakPriceDelta(null);
        }
        this.initializeOpenOrCloseIfCapable(orderToPopulate);
        this.order.setValue(orderToPopulate);
    }

    public void populateFromOrderbook(Orderbook orderbook) {
        Direction direction = this.directionToggle.getValue();
        Order newOrder = this.createEmptyOrder(orderbook.getContract());
        newOrder.setDeliveryArea(orderbook.getDeliveryArea());
        this.initializeOpenOrCloseIfCapable(newOrder);
        newOrder.setDirection(direction);
        this.order.setValue(newOrder);
    }

    public void populateFromContract(Contract contract) {
        Direction direction = this.directionToggle.getValue();
        Order newOrder = this.createEmptyOrder(contract);
        this.initializeOpenOrCloseIfCapable(newOrder);
        newOrder.setDirection(direction);
        this.order.setValue(newOrder);
    }

    private void initializeOpenOrCloseIfCapable(Order order) {
        boolean isCapable = order.getContract() != null && order.getContract().supportsOpenCloseIndicator();
        order.setOpenOrClose(isCapable ? Optional.ofNullable(order.getOpenOrClose()).orElse(OpenOrClose.OPEN) : null);
    }

    @FXML
    public void reset() {
        this.order.setValue(this.createEmptyOrder(null));
        this.resetInputFields();
        this.submitting.setValue(false);
        this.requestFocus();
    }

    private void resetInputFields() {
        this.orderTextField.setTextToDefault();
        this.contractField.reset();
        this.orderTypeChoiceBox.init(this.isNewOrder.get(), this.isBalanceUser(), this.basketMode, null);
        if (!this.userField.isDisabled()) {
            this.userField.setText(null);
        }
        if (!this.memberField.isDisabled()) {
            this.memberField.setText(null);
        }
        this.priceField.setValue(null);
        this.quantityField.setValue(null);
        this.peakQuantityField.setValue(null);
        this.peakPriceDeltaField.setValue(null);
        this.openCloseIndicatorField.setValue(null);
        this.orderRestrictionChoiceBox.setValue(this.blockMode ? ExecutionRestriction.ALL_OR_NOTHING : ExecutionRestriction.NONE);
        this.orderStatusChoiceBox.setValue(OrderStatus.ACTIVE);
        this.dateTimeField.clear();
        this.forBalancingGroupField.clear();
        this.deliveryAreaChoiceBox.applyDefaultValue();
        this.balancingGroupChoiceBox.setSelectedById(this.currentUser.getValue() != null ? this.currentUser.getValue().getDefaultBalancingGroup() : null);
        this.validityRestrictionChoiceBox.loadDefaultValue();
        this.accountTypeChoiceBox.reset();
        if (this.aotChoiceBox != null) {
            this.aotChoiceBox.reset();
        }
        this.resetLocationEnabledInputFields();
    }

    private void resetLocationEnabledInputFields() {
        if (this.locationField != null) {
            this.locationField.setTextToDefault();
        }
        this.marketBasedChoiceBox.reset();
        this.contractReferenceField.clear();
        this.facilityTypeField.clear();
        this.usageFractionField.clear();
    }

    @FXML
    public void add() {
        Order orderToAdd = this.createOrderForSubmit();
        try {
            if (this.orderEntryProtectionService.checkOrders(Lists.newArrayList(orderToAdd))) {
                this.basketService.getActiveBasket().replaceWithUpdateVersion(orderToAdd);
                this.notifier.showNotification(Util.getLabel("basket_order_successfully_added"), NotificationService.NotificationSeverity.SUCCESS);
                this.closeOrReset();
            }
        }
        catch (BasketFullException e) {
            this.messagePublisher.publishMessage(Util.getLabel("basketFullMessage", e.getAllowed()), MessageSeverity.ERROR);
        }
    }

    private void closeOrReset() {
        if (this.clearButtonMode == ClearButtonMode.CLOSE) {
            this.close();
        } else {
            this.reset();
        }
    }

    @FXML
    public void close() {
        Optional.ofNullable(this.getScene().getWindow()).ifPresent(Window::hide);
    }

    @FXML
    public void submit() {
        LOG.trace("Submit button pressed");
        this.submitting.set(true);
        Order orderToSubmit = this.createOrderForSubmit();
        this.basketService.getActiveBasket().remove(orderToSubmit);
        if (OrderType.OTC_PREARRANGED.equals(orderToSubmit.getOrderType()) && AcceptOrRejectType.ACCEPT.equals((Object)orderToSubmit.getPreArrangedAcceptOrReject())) {
            OtcOrderService otcOrderService = this.getAppContext().getService(OtcOrderService.class, orderToSubmit.getExchange());
            otcOrderService.acceptOtcOrder(orderToSubmit, this::handleOTCResponse);
        } else {
            this.orderSender.sendOrder(new OrdersToSend(orderToSubmit, (RequestType)((Object)this.requestType.get()), this::handleResponse, (User)this.userField.getValue()));
        }
    }

    private void handleOTCResponse(AsyncResponse response) {
        FxUtil.runInFxThread(this::handleSuccess);
    }

    private void handleResponse(AsyncResponse response) {
        FxUtil.runInFxThread(() -> {
            this.submitting.setValue(false);
            boolean waitForOrderConfirmation = this.tradingSettingsService.isWaitForOrderConfirmation();
            if (!waitForOrderConfirmation && response.getStatus() == ResponseStatus.ACKNOWLEDGED || waitForOrderConfirmation && response.getStatus() == ResponseStatus.SUCCESS) {
                this.handleSuccess();
            } else if (response.getStatus() == ResponseStatus.ERROR) {
                this.handleError();
            }
        });
    }

    private void handleError() {
        if (!this.isNewOrder.get()) {
            this.closeOrReset();
        }
    }

    private void handleSuccess() {
        this.closeOrReset();
        this.notifier.showNotification(Util.getLabel("commons_successfulCompletion"), NotificationService.NotificationSeverity.SUCCESS);
    }

    private Order createOrderForSubmit() {
        Order orderForSubmit = new Order((Order)this.order.getValue());
        if (this.isNewOrder.get()) {
            orderForSubmit.setId(null);
            orderForSubmit.setStatus((OrderStatus)this.orderStatusChoiceBox.getValue());
        }
        if (orderForSubmit.getOrderType() != OrderType.OTC_PREARRANGED) {
            orderForSubmit.setPreArrangedBalancingGroup(null);
        }
        if (orderForSubmit.getOrderType() != OrderType.ICEBERG) {
            orderForSubmit.setPeakQuantity(null);
            orderForSubmit.setPeakPriceDelta(null);
        }
        if (orderForSubmit.getOrderType() != OrderType.STOP) {
            orderForSubmit.setStopPrice(null);
        }
        if (orderForSubmit.getValidityRestriction() != ValidityRestriction.GOOD_TILL_DATE) {
            orderForSubmit.setValidityDate(null);
        }
        if (!((Order)this.order.get()).getContract().supportsOpenCloseIndicator()) {
            orderForSubmit.setOpenOrClose(null);
        }
        if (orderForSubmit.getAot() == null) {
            orderForSubmit.setAot(Boolean.FALSE);
        }
        return orderForSubmit;
    }

    private Order createEmptyOrder(Contract contract) {
        Order newOrder = new Order();
        newOrder.setDirection(Direction.BUY);
        newOrder.setContract(contract);
        if (contract != null) {
            this.loadValuesFromOrderPreferences(newOrder);
        }
        return newOrder;
    }

    private boolean isBalanceUser() {
        return Optional.ofNullable(this.userService.getCurrentUser()).map(User::getRoles).map(UserRoles::isBalanceUser).orElse(false);
    }

    @Subscribe
    public void handleOnBehalfChangeEvent(OnBehalfChangeEvent event) {
        this.closeOrReset();
    }

    @Subscribe
    public void handleLogoutEvent(LogoutEvent event) {
        this.closeOrReset();
    }

    public void focusQuantityField() {
        this.quantityField.getTextField().requestFocus();
    }

    public void focusDeliveryAreaField() {
        this.deliveryAreaChoiceBox.requestFocus();
    }

    public ReadOnlyObjectProperty<Order> orderProperty() {
        return this.order;
    }
}

