/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractProductAwareLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderBindingUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.Observable;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class QuantityField
extends AbstractProductAwareLongDisplayValueField {
    public QuantityField() {
    }

    public QuantityField(LongDisplayValue initialValue) {
        super(initialValue);
    }

    public QuantityField(LongDisplayValue initialValue, int delta) {
        super(initialValue, delta);
    }

    public void init(final ObservableObjectValue<Contract> contract, final ObservableObjectValue<OrderType> orderType) {
        this.productProperty().bind(OrderBindingUtil.productBinding(contract));
        this.textFieldFocusedProperty().addListener((observableValue, oldValue, newValue) -> {
            Contract contractValue = (Contract)contract.get();
            if (contractValue != null) {
                Product product = contractValue.getProduct();
                if (!oldValue.booleanValue() && newValue.booleanValue() || this.isValid()) {
                    LongDisplayValue oldQuantity = this.getValue();
                    this.setValue((oldQuantity != null ? oldQuantity : LongDisplayValue.ZERO).applyShift(product.getQuantityDecimalShift()));
                    this.setDelta((int)product.getQuantityLotSize().getValue());
                    this.selectAllIfFocused();
                }
                if (this.getValue() != null && oldValue.booleanValue() && !newValue.booleanValue()) {
                    this.setValue(this.getValue().applyShift(product.getQuantityDecimalShift()));
                }
            }
        });
        this.minimumProperty().bind((ObservableValue<LongDisplayValue>)new DependentBinding<LongDisplayValue>(this, new Observable[]{orderType, contract}){

            @Override
            protected LongDisplayValue computeValue() {
                Contract contractValue = (Contract)contract.getValue();
                if (contractValue != null) {
                    Product product = contractValue.getProduct();
                    if (orderType.getValue() == OrderType.ICEBERG) {
                        return product.getIcebergMinPeakSize();
                    }
                    return product.getQuantityMinValue();
                }
                return new LongDisplayValue(0L, 0);
            }
        });
        ObservableValue<Product> productBinding = OrderBindingUtil.productBinding(contract);
        DependentBinding<LongDisplayValue> maximumQuantityBinding = DependentBinding.get(Product::getQuantityMaxValue, productBinding, new LongDisplayValue(Integer.MAX_VALUE, 0));
        this.maximumProperty().bind(maximumQuantityBinding);
    }

    @Override
    public LongDisplayValue getInitialValue() {
        return LongDisplayValue.ZERO.applyShift(this.getProduct().getQuantityDecimalShift());
    }

    @Override
    public Node getPreviewForConfigTable() {
        QuantityField simpleLongDisplayValueField = new QuantityField(this.getValue());
        simpleLongDisplayValueField.setValue(this.getValue());
        simpleLongDisplayValueField.prefWidthProperty().bind(this.widthProperty());
        simpleLongDisplayValueField.setDisable(true);
        return simpleLongDisplayValueField;
    }
}

