/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.order;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.scene.control.Tooltip;

public abstract class AbstractOrderTooltip
extends Tooltip {
    public void applyOrder(Order order) {
        if (order == null) {
            this.setText("");
        } else if (order.getStatus() == OrderStatus.ERROR) {
            this.setText(this.getInvalidOrderTooltipText(order));
        } else if (order.getStatus() == OrderStatus.SENT) {
            this.setText(this.getSentOrderTooltipText());
        } else if (order.getStatus() == OrderStatus.MODI) {
            this.setText(this.getModiOrderTooltipText());
        } else {
            this.setText(this.getValidOrderTooltipText(order));
        }
    }

    protected abstract String getValidOrderTooltipText(Order var1);

    private String getSentOrderTooltipText() {
        return Util.getLabel("orderEntrySentTooltipText");
    }

    private String getModiOrderTooltipText() {
        return Util.getLabel("orderEntryModiTooltipText");
    }

    private String getInvalidOrderTooltipText(Order order) {
        return Util.getLabel("orderEntryFailedTooltipText", order.getErrorMessage());
    }
}

