/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.AbstractExtendedOrderbookEntryTableCell;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlash;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlashFactory;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import javafx.geometry.Pos;
import javafx.scene.control.ContentDisplay;

public class FlashingExtendedOrderbookEntryTableCell<T>
extends AbstractExtendedOrderbookEntryTableCell<T> {
    private final int flashMask;
    private ColorFlash colorFlash;

    protected FlashingExtendedOrderbookEntryTableCell(ApplicationContext applicationContext, ExtendedOrderbookTableView tableView, int flashMask, boolean displaysAccumulatedValue, Direction direction) {
        super(applicationContext, tableView, displaysAccumulatedValue, direction);
        this.flashMask = flashMask;
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        StyleUtil.addStyleClasses(this, "extendedOrderbookEntriesTableCell");
        this.setAlignment(Pos.CENTER);
    }

    private void flash() {
        if (this.colorFlash == null) {
            this.colorFlash = this.applicationContext.getService(ColorFlashFactory.class).getFlash(this);
        }
        this.colorFlash.flash();
    }

    @Override
    public void updateIndex(int i) {
        super.updateIndex(i);
        if (this.colorFlash != null && i >= 0) {
            this.colorFlash.abort();
        }
        if (i >= 0 && this.tableView.shouldFlash(i, this.direction, this.flashMask)) {
            this.flash();
        }
    }

    @Override
    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (item != null && !empty) {
            this.setText(item.toString());
        } else {
            this.setText(null);
        }
    }
}

