/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CollapsibleValueOrderbookWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColorInvalidationListener;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MagnifiedOrderbookPopupService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.SingleContractOrderbookEvent;
import com.google.common.eventbus.EventBus;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class OrderbookMagnifierCellFactory
implements Callback<TableColumn<CollapsibleValueOrderbookWrapper, CollapsibleValueOrderbookWrapper>, TableCell<CollapsibleValueOrderbookWrapper, CollapsibleValueOrderbookWrapper>> {
    private final ApplicationContext appContext = FXMLLoaderWithContext.getAppContext();

    @Override
    public TableCell<CollapsibleValueOrderbookWrapper, CollapsibleValueOrderbookWrapper> call(TableColumn<CollapsibleValueOrderbookWrapper, CollapsibleValueOrderbookWrapper> orderbookWrapperStringTableColumn) {
        OrderbookMagnifierCell tableCell = new OrderbookMagnifierCell(this.appContext);
        ColorInvalidationListener.registerForColoredTableColumn(orderbookWrapperStringTableColumn, tableCell);
        return tableCell;
    }

    private static final class OrderbookMagnifierCell
    extends TableCell<CollapsibleValueOrderbookWrapper, CollapsibleValueOrderbookWrapper> {
        private final MagnifiedOrderbookPopupService magnifiedOrderbookPopupService;
        private final EventBus eventBus;

        public OrderbookMagnifierCell(ApplicationContext applicationContext) {
            this.magnifiedOrderbookPopupService = applicationContext.getService(MagnifiedOrderbookPopupService.class);
            this.eventBus = applicationContext.getService(EventBus.class);
            this.setAlignment(Pos.TOP_CENTER);
        }

        private void handleMouseClicked() {
            CollapsibleValueOrderbookWrapper item = (CollapsibleValueOrderbookWrapper)this.getItem();
            SingleContractOrderbookEvent event = new SingleContractOrderbookEvent(item.getOrderbook(), this);
            this.eventBus.post(event);
            if (!event.wasProcessed()) {
                this.magnifiedOrderbookPopupService.showMagnifiedOrderbookPopup(item.getOrderbook(), this);
            }
        }

        @Override
        protected void updateItem(CollapsibleValueOrderbookWrapper value, boolean empty) {
            super.updateItem(value, empty);
            if (value != null && !empty) {
                Button magnifierButton = new Button();
                magnifierButton.setGraphic(new IconView("button-search"));
                magnifierButton.setOnMouseClicked(event -> this.handleMouseClicked());
                this.setGraphic(magnifierButton);
            } else {
                if (this.getGraphic() instanceof Button) {
                    this.getGraphic().setOnMouseClicked(null);
                }
                this.setGraphic(null);
            }
        }
    }
}

