/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.trade;

import com.deutscheboerse.comxerv.comtrader.domain.query.TradeQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.DateFilterBottomToolbarComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.DateTypeFilterChoice;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.RelevantEntitiesProvider;
import java.util.stream.Stream;
import org.joda.time.DateTime;

public abstract class RelevantTradesProvider<T extends Trade>
implements RelevantEntitiesProvider<T> {
    private final TradeQueries<T> tradeQueries;
    private final DateFilterBottomToolbarComponent<T> dateFilter;

    protected RelevantTradesProvider(TradeQueries<T> tradeQueries, DateFilterBottomToolbarComponent<T> dateFilter) {
        this.tradeQueries = tradeQueries;
        this.dateFilter = dateFilter;
    }

    @Override
    public Stream<T> getRelevantEntities() {
        DateTime date = this.dateFilter.getDate();
        if (date == null) {
            return Stream.empty();
        }
        DateTypeFilterChoice dateType = this.dateFilter.getDateType();
        switch (dateType) {
            case DELIVERY_DATE: {
                return this.tradeQueries.findByDeliveryDate(date).getAll();
            }
            case TRADING_DATE: {
                return this.tradeQueries.findByTradingDate(date).getAll();
            }
        }
        throw new IllegalStateException(String.valueOf(dateType));
    }
}

