/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.event.ReactOnButtonFocusKeyListener;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Collection;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class TradesCanceledPopupPanel
extends FXMLBorderPane {
    @FXML
    private Label tradesLabel;
    @FXML
    private HBox buttonGroupHBox;

    public TradesCanceledPopupPanel(ApplicationContext appContext, List<FullTrade> trades, int cancelled, int failures, Runnable closeAction) {
        super(appContext);
        this.loadFxml();
        this.tradesLabel.setText(this.tradeConfirmationText(cancelled, failures));
        this.setOnKeyPressed(new ReactOnButtonFocusKeyListener());
        this.buttonGroupHBox.getChildren().addAll((Collection<Node>)this.buttons(trades, closeAction));
    }

    private List<Button> buttons(List<FullTrade> trades, Runnable closeAction) {
        ButtonWithIcon okButton = new ButtonWithIcon(Util.getLabel("commons_ok"), "button-accept");
        okButton.setCancelButton(true);
        okButton.setOnAction(e -> closeAction.run());
        ButtonWithIcon exportButton = new ButtonWithIcon(Util.getLabel("commons_exportAll"), "button-export");
        exportButton.setOnAction(a -> this.exportTradeCsv(trades));
        return List.of(okButton, exportButton);
    }

    private void exportTradeCsv(List<FullTrade> trades) {
        ImportExportService exportService = this.getAppContext().getService(ImportExportService.class);
        String fileName = DateTime.now().toString("yyyy-MM-dd_HHmmSS") + "_trades_cancelled.csv";
        exportService.exportHalftradesToCsvFile(trades.stream().flatMap(FullTrade::allHalfTrades), this.getScene().getWindow(), fileName);
    }

    @Nonnull
    private String tradeConfirmationText(int cancelled, int failures) {
        return Util.getLabel("tradeCancellationConfirmationPanel_counts", cancelled, failures);
    }
}

