/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.tree;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.IntervalCallback;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.IntervalTree;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.layout.HBox;

public class SlideInIntervalTreePane
extends HBox {
    protected static final String LEFT_ICON_STYLE_CLASS = "button-orderbook-navigation-left";
    protected static final String RIGHT_ICON_STYLE_CLASS = "button-orderbook-navigation-right";
    @FXML
    private IconView toggleIntervalTreeButton;
    private final IntervalTree intervalTree;
    private final SimpleBooleanProperty intervalTreeVisible;

    public SlideInIntervalTreePane(ApplicationContext appContext, IntervalCallback intervalCallback) {
        this.intervalTree = new IntervalTree(appContext, intervalCallback);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.intervalTreeVisible = new SimpleBooleanProperty(true);
        this.intervalTreeVisible.addListener((ChangeListener<? super Boolean>)((ChangeListener<Boolean>)(observable2, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.toggleIntervalTreeButton.setIconStyleClass(LEFT_ICON_STYLE_CLASS);
                if (!this.getChildren().contains(this.intervalTree)) {
                    this.getChildren().add(this.intervalTree);
                }
            } else {
                this.toggleIntervalTreeButton.setIconStyleClass(RIGHT_ICON_STYLE_CLASS);
                this.getChildren().remove(this.intervalTree);
            }
        }));
        this.intervalTreeVisible.set(false);
    }

    @FXML
    public void toggleIntervalTree() {
        if (this.intervalTreeVisible.get()) {
            this.hideIntervalTree();
        } else {
            this.showIntervalTree();
        }
    }

    public void hideIntervalTree() {
        this.intervalTreeVisible.set(false);
    }

    public void showIntervalTree() {
        this.intervalTreeVisible.set(true);
    }

    public boolean getIntervalTreeVisible() {
        return this.intervalTreeVisible.get();
    }

    public SimpleBooleanProperty intervalTreeVisibleProperty() {
        return this.intervalTreeVisible;
    }

    public IntervalTree getIntervalTree() {
        return this.intervalTree;
    }
}

