/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelRowsStrategy;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

public class AdminOrderbookPaneExcelRowsStrategy
extends ExcelRowsStrategy<AbstractOrderbookPane, ExtendedOrderbookEntry> {
    public AdminOrderbookPaneExcelRowsStrategy(ApplicationContext ctx) {
        super(ctx);
        this.addProducer(entry -> {
            Order order = (Order)this.orderDataModel.findById(entry.getOrderId());
            return order.getUser() == null ? order.getTraderUserCode() : order.getUser().getDisplayName();
        });
        this.addProducer(entry -> {
            Order order = (Order)this.orderDataModel.findById(entry.getOrderId());
            return order.getUser() == null ? order.getMemberCode() : order.getUser().getMember().getDisplayName();
        });
        this.addProducers(entry -> this.localService.format(entry.getVwap().getDisplayValue()), entry -> this.localService.format(entry.getAccQuantity().getDisplayValue()), entry -> {
            Order order = (Order)this.orderDataModel.findById(entry.getOrderId());
            if (order != null && entry.isContainsOwnOrder() && OrderType.ICEBERG.equals(order.getOrderType())) {
                return String.valueOf(this.localService.format(entry.getQuantity().getDisplayValue())) + " (" + String.valueOf(this.localService.format(order.getRemainingQuantity().getDisplayValue())) + ")";
            }
            return this.localService.format(entry.getQuantity().getDisplayValue());
        }, entry -> this.localService.format(entry.getPrice().getDisplayValue()));
    }

    @Override
    public List<List<Object>> consume(AbstractOrderbookPane pane) {
        Orderbook orderbook = pane.getOrderbook();
        List buyList = orderbook.getExtendedBuys().getEntries();
        List sellList = orderbook.getExtendedSells().getEntries();
        int rowLimit = pane.getEntryTables().rowLimitProperty().get();
        int depth = Math.max(buyList.size(), sellList.size());
        if (rowLimit != -1) {
            depth = Math.min(depth, rowLimit);
        }
        ArrayList<List<Object>> result = Lists.newArrayList();
        IntStream.range(0, depth).forEach(i -> {
            ArrayList<Object> rowData = Lists.newArrayList();
            rowData.addAll(this.processInOrder(buyList, i));
            rowData.addAll(this.processInReverseOrder(sellList, i));
            result.add(rowData);
        });
        return result;
    }
}

