/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.util;

import com.deutscheboerse.comxerv.comtrader.monitoring.Monitor;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxDelaySensor {
    private static final Logger LOG = LoggerFactory.getLogger(FxDelaySensor.class);
    private static final long DEBUG_THRESHOLD = 200L;
    private static final long INFO_THRESHOLD = 500L;
    private static final long WARN_THRESHOLD = 1000L;
    private static final long ERROR_THRESHOLD = 2000L;
    private static final int SENSOR_INTERVAL_IN_MILLIS = 5000;
    private final ScheduledExecutorService sensorExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("ComTrader-FxDelaySensor").build());
    private final Monitor monitor;

    public FxDelaySensor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void start() {
        this.sensorExecutor.scheduleAtFixedRate(this::measureDelay, 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.sensorExecutor.shutdownNow();
    }

    private void measureDelay() {
        long now = System.currentTimeMillis();
        FxUtil.runInFxThread(() -> this.measureDelayInFx(now));
    }

    private void measureDelayInFx(long start) {
        long now = System.currentTimeMillis();
        long duration = now - start;
        this.monitor.fxDelay(duration);
        if (duration < 200L) {
            LOG.trace("FxDelay: {}ms", (Object)duration);
        } else if (duration < 500L) {
            LOG.debug("FxDelay: {}ms", (Object)duration);
        } else if (duration < 1000L) {
            LOG.info("FxDelay: {}ms", (Object)duration);
        } else if (duration < 2000L) {
            LOG.warn("FxDelay: {}ms", (Object)duration);
        } else {
            LOG.error("FxDelay: {}ms", (Object)duration);
        }
    }
}

