/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.util;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.scene.control.TableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TableUpdateManager {
    private static final Logger LOG = LoggerFactory.getLogger(TableUpdateManager.class);
    private final WeakHashMap<TableView, TableUpdater> updaters;
    private final ScheduledExecutorService executor;

    @Inject
    public TableUpdateManager(ApplicationContext applicationContext) {
        this.executor = applicationContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.updaters = new WeakHashMap();
    }

    public void submitSortRequest(TableView table) {
        FxUtil.runInFxThread(() -> {
            TableUpdater taskRecord = this.getTaskRecord(table);
            if (taskRecord != null) {
                taskRecord.requestSort();
            }
        });
    }

    private TableUpdater getTaskRecord(TableView table) {
        if (!this.executor.isShutdown()) {
            return this.updaters.computeIfAbsent(table, newTable -> new TableUpdater(this.executor, (TableView)newTable));
        }
        return null;
    }

    private static final class TableUpdater {
        private final ScheduledExecutorService executor;
        private final WeakReference<TableView> table;
        private boolean updateRequested = false;

        private TableUpdater(ScheduledExecutorService executor, TableView table) {
            this.executor = executor;
            this.table = new WeakReference<TableView>(table);
        }

        public void requestSort() {
            TableView table = (TableView)this.table.get();
            if (this.updateRequested || table == null) {
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Update requested: {} {}", (Object)this.getName(table), (Object)System.currentTimeMillis());
            }
            this.updateRequested = true;
            this.scheduleUpdate();
        }

        private void scheduleUpdate() {
            if (!this.executor.isShutdown()) {
                this.executor.execute(() -> FxUtil.runInFxThread(this::update));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            long startTime = System.currentTimeMillis();
            TableView table = (TableView)this.table.get();
            try {
                if (table != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Update started: {} {}", (Object)this.getName(table), (Object)System.currentTimeMillis());
                    }
                    this.forceReSort(table);
                }
            }
            finally {
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Refresh duration: {} {}", (Object)this.getName(table), (Object)duration);
                }
                this.scheduleIdleTimeSlot(duration);
            }
        }

        private void scheduleIdleTimeSlot(long lastUpdateDuration) {
            long pause = lastUpdateDuration * 10L;
            if (pause <= 0L) {
                pause = 100L;
            }
            if (pause >= 5000L) {
                pause = 5000L;
            }
            this.executor.schedule(() -> {
                this.updateRequested = false;
                return false;
            }, pause, TimeUnit.MILLISECONDS);
        }

        private String getName(TableView table) {
            return table.getId() + "/" + System.identityHashCode(table);
        }

        private void forceReSort(TableView table) {
            if (!table.getSortOrder().isEmpty()) {
                table.sort();
            }
        }
    }
}

