/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParameters;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.module.ReceiverExecutor;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.monitoring.Monitor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.ProxySettings;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpBroadcastClient;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpBroadcastListener;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpConnectionManager;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpRpcClient;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpUtil;
import com.deutscheboerse.comxerv.comtrader.service.amqp.BatchingBroadcastHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ComTraderConnectionFactory;
import com.deutscheboerse.comxerv.comtrader.service.amqp.CorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ErrorHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.Marshaller;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MarshallerException;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MessageInterceptor;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MessageSequenceCheck;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MissingQueueException;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.SimpleResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.UiThreadObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.PerformanceStatisticsService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.Request;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.TopologyRecoveryException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractAmqpBackend
implements AmqpBroadcastListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAmqpBackend.class);
    private static final Logger PERFORMANCE_LOG = LoggerFactory.getLogger("performance");
    private static final Marker COMPRESS_MARKER = MarkerFactory.getMarker("COMPRESS");
    private static final int GAP_TIMEOUT_THRESHOLD = 10000;
    private BatchingBroadcastHandler batchingBroadcastHandler;
    private final List<ErrorHandler> errorHandlers = new CopyOnWriteArrayList<ErrorHandler>();
    private final List<MessageInterceptor> messageInterceptors = new CopyOnWriteArrayList<MessageInterceptor>();
    private final Marshaller marshaller;
    private final TimeService timeService;
    private final PerformanceStatisticsService performanceStatisticsService;
    protected final MessageSequenceCheck messageSequenceCheck;
    protected final ScheduledExecutorService workerExecutorService;
    protected final ScheduledExecutorService receiverExecutorService;
    private final Session session;
    private final AmqpRpcClient amqpRpcClient;
    private AmqpBroadcastClient amqpBroadcastClient;
    private final ComTraderConnectionFactory connectionFactory;
    private final AmqpConnectionManager connectionManager;
    private final ApplicationConfigurationService applicationConfigurationService;
    private volatile boolean disconnected;
    private TimeoutHandler timeoutHandler;

    protected AbstractAmqpBackend(Session session, Marshaller marshaller, MessageSequenceCheck messageSequenceCheck, ApplicationContext appContext) throws LoginException {
        this.session = session;
        this.marshaller = marshaller;
        this.timeService = appContext.getService(TimeService.class);
        this.messageSequenceCheck = messageSequenceCheck;
        this.performanceStatisticsService = appContext.getService(PerformanceStatisticsService.class);
        this.workerExecutorService = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.receiverExecutorService = appContext.getService(ScheduledExecutorService.class, ReceiverExecutor.class);
        this.applicationConfigurationService = appContext.getService(ApplicationConfigurationService.class);
        this.batchingBroadcastHandler = new BatchingBroadcastHandler(appContext.getService(UiThreadObjectHandler.class), appContext.getService(Monitor.class));
        this.connectionFactory = this.createConnectionFactory(this.receiverExecutorService, session.getConnectionParameters(), appContext.getService(ProxySettings.class));
        this.connectionManager = this.createConnectionManager(this.connectionFactory, this);
        this.amqpRpcClient = this.createRpcClient(appContext, session, this.connectionManager, marshaller.getContentType());
        this.amqpBroadcastClient = this.createBroadcastClient(appContext, session, this.connectionManager, this);
    }

    protected AmqpBroadcastClient createBroadcastClient(ApplicationContext appContext, Session session, AmqpConnectionManager connectionManager, AbstractAmqpBackend abstractAmqpBackend) {
        return new AmqpBroadcastClient(appContext, session, connectionManager, abstractAmqpBackend);
    }

    protected AmqpRpcClient createRpcClient(ApplicationContext appContext, Session session, AmqpConnectionManager connectionManager, String contentType) {
        return new AmqpRpcClient(appContext, session, connectionManager, contentType);
    }

    protected AmqpConnectionManager createConnectionManager(ComTraderConnectionFactory connectionFactory, AmqpBroadcastListener amqpListener) {
        return new AmqpConnectionManager(connectionFactory, amqpListener);
    }

    protected ComTraderConnectionFactory createConnectionFactory(ExecutorService executorService, ConnectionParameters params, ProxySettings proxySettings) throws LoginException {
        return new ComTraderConnectionFactory(executorService, params, proxySettings, this.applicationConfigurationService);
    }

    protected abstract boolean hasMessageSequenceNumber(AMQP.BasicProperties var1);

    protected MessageSequenceCheck.Result checkMessageSequence(AMQP.BasicProperties properties) {
        if (this.hasMessageSequenceNumber(properties)) {
            return this.messageSequenceCheck.checkSequenceNumber(properties);
        }
        return MessageSequenceCheck.Result.OK;
    }

    protected void startMessageSequenceRecoveryTimer(Supplier<Collection<MessageSequenceCheck.Result>> resultSupplier) {
        if (this.timeoutHandler == null) {
            this.timeoutHandler = new TimeoutHandler(10000, this.workerExecutorService, resultSupplier);
            this.timeoutHandler.startTimeout();
        }
    }

    protected void stop() {
        if (this.timeoutHandler != null) {
            this.timeoutHandler.stopTimeout();
            this.timeoutHandler = null;
        }
        this.batchingBroadcastHandler.stop();
    }

    public void resetGapDetection() {
        this.messageSequenceCheck.reset();
    }

    protected String getGroupSequence() {
        return this.messageSequenceCheck.getSequenceHeaderName();
    }

    protected String getGapDetectionNotification(MessageSequenceCheck.Result result) {
        String routingKey = result.getTopic();
        Long prevSeqNo = result.getPrevSeqNo();
        Long currentSeqNo = result.getSeqNo();
        LOG.error("Gap detected: {} {}->{}.", routingKey, prevSeqNo, currentSeqNo);
        return Util.getLabel("gapDetectionMessage", routingKey, prevSeqNo, currentSeqNo);
    }

    protected void handleObject(Object object, String correlationId, Long eventIndex) {
        this.performanceStatisticsService.recordBroadcast(correlationId, eventIndex, object);
        this.batchingBroadcastHandler.handle(this.session, object, correlationId);
    }

    public void addErrorHandler(ErrorHandler errorHandler) {
        this.errorHandlers.add(errorHandler);
    }

    public void removeErrorHandler(ErrorHandler errorHandler) {
        this.errorHandlers.remove(errorHandler);
    }

    protected void notifyException(Exception e) {
        for (ErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handleException(this.session, e);
        }
    }

    protected void notifyGapDetected(String description) {
        for (ErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handleGapDetected(this.session, description);
        }
    }

    protected void notifyConnectionError(String description) {
        for (ErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handleConnectionError(this.session, description);
        }
    }

    protected void handleUserChangeException(ErrorHandler.UserChangeType userChangeType) {
        for (ErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handleUserChangeException(this.session, userChangeType);
        }
    }

    public void addMessageInterceptor(MessageInterceptor messageInterceptor) {
        this.messageInterceptors.add(messageInterceptor);
    }

    protected byte[] interceptMessage(byte[] messageBytes, DateTime timestamp, boolean outgoing, String routingKey, String correlationId, Long eventIndex) {
        for (MessageInterceptor messageInterceptor : this.messageInterceptors) {
            try {
                messageBytes = messageInterceptor.handleMessage(this.session, messageBytes, timestamp, outgoing, routingKey, correlationId, eventIndex);
            }
            catch (Exception e) {
                LOG.error("Interceptor " + String.valueOf(messageInterceptor) + " threw an exception", e);
            }
        }
        return messageBytes;
    }

    public void connect() throws LoginException {
        try {
            this.amqpRpcClient.initializeConnection();
            this.amqpBroadcastClient.creatBroadcastQueue();
        }
        catch (IOException e) {
            throw LoginException.fromIOException(e);
        }
        catch (TimeoutException e) {
            throw LoginException.fromTimeoutException(e);
        }
    }

    public void disconnect() {
        this.amqpBroadcastClient.stop();
        this.amqpRpcClient.close();
        this.disconnected = true;
    }

    public boolean disconnected() {
        return this.disconnected;
    }

    public void startBroadcastListener() {
        if (this.amqpBroadcastClient.isStopped()) {
            this.amqpBroadcastClient.start();
        }
    }

    public void processBroadcastListener() {
        this.amqpBroadcastClient.startProcessBroadcast();
    }

    @Override
    public boolean handleAmqpConnectionError(Exception e) {
        if (this.isNotRecoverableError(e)) {
            if (!this.isAlreadyClosedError(e)) {
                this.notifyConnectionError("Connection failure.");
            }
            return false;
        }
        return true;
    }

    private boolean isNotRecoverableError(Exception e) {
        return e instanceof ShutdownSignalException || e instanceof MissingQueueException || e instanceof TopologyRecoveryException;
    }

    private boolean isAlreadyClosedError(Exception e) {
        return e instanceof AlreadyClosedException;
    }

    public ResponseWithCorrelationId sendRequest(byte[] message, String routingKey, int timeout, boolean retry, boolean handleErrResp, boolean compress, AtomicLong eventIndex) {
        String correlationId = CorrelationId.next();
        try {
            ResponseWithCorrelationId response = this.sendRequest(message, correlationId, routingKey, timeout, retry, handleErrResp, compress, eventIndex);
            this.logResponse(response);
            this.performanceStatisticsService.recordResponse(response.getCorrelationId(), response.getResponse(), response.getPmiProcessingTime());
            return response;
        }
        catch (RuntimeException e) {
            LOG.error("error sending request", e);
            this.notifyException(e);
            return new SimpleResponseWithCorrelationId(null, correlationId);
        }
    }

    public ResponseWithCorrelationId sendRequest(Request request, boolean handleErrResp, int timeout, String correlationId, AtomicLong eventIndex) {
        try {
            String routingKey = this.getRequestRoutingKey(request);
            byte[] message = this.marshaller.getXmlBytes(request);
            if (correlationId == null) {
                correlationId = CorrelationId.next();
            }
            this.performanceStatisticsService.recordRequest(correlationId, request);
            this.logRequest(request, correlationId);
            ResponseWithCorrelationId response = this.sendRequest(message, correlationId, routingKey, timeout, !this.isLoginRequest(request), handleErrResp, false, eventIndex);
            this.logResponse(response);
            this.performanceStatisticsService.recordResponse(response.getCorrelationId(), response.getResponse(), response.getPmiProcessingTime());
            return response;
        }
        catch (MarshallerException | RuntimeException e) {
            LOG.error("error sending request", e);
            this.notifyException(e);
            return new SimpleResponseWithCorrelationId(null, correlationId);
        }
    }

    protected void logRequest(Object request, String correlationId) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Request: {} {}", (Object)correlationId, request);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Request: {} {} ", (Object)correlationId, (Object)this.getSimpleClassName(request));
        }
    }

    protected void logResponse(ResponseWithCorrelationId response) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Response: {} {}", (Object)response.getCorrelationId(), response.getResponse());
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Response: {} {} ", (Object)response.getCorrelationId(), (Object)this.getSimpleClassName(response.getResponse()));
        }
    }

    protected void logErrorResponse(String correlationId, String error) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Error Response: {} {}", (Object)correlationId, (Object)error);
        }
    }

    protected void logBroadcast(Object broadcast, AMQP.BasicProperties properties) {
        Map<String, Object> headers = properties.getHeaders();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Broadcast: {}\n{}\n{}\n{}", properties.getCorrelationId(), properties, headers, broadcast);
        } else if (LOG.isDebugEnabled()) {
            Object groupId = headers.get(this.messageSequenceCheck.getGroupHeaderName());
            Object sequenceNo = headers.get(this.messageSequenceCheck.getSequenceHeaderName());
            LOG.debug("Broadcast: {} {} {} {}", properties.getCorrelationId(), groupId, sequenceNo, this.getSimpleClassName(broadcast));
        }
    }

    protected String jaxbExceptionToString(AMQP.BasicProperties properties, byte[] body) {
        return "Error unmarshalling message  " + this.propertiesToShortString(properties) + " " + (body == null ? "null" : this.bodyToString(body));
    }

    private String propertiesToShortString(AMQP.BasicProperties properties) {
        return properties.getCorrelationId() + " " + this.messageSequenceCheck.getGroupHeaderName() + " " + this.messageSequenceCheck.getSequenceHeaderName();
    }

    private String bodyToString(byte[] body) {
        try {
            return AmqpUtil.toString(body);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", e);
            return null;
        }
    }

    private String getSimpleClassName(Object o) {
        return o == null ? "null" : o.getClass().getSimpleName();
    }

    protected abstract boolean isLoginRequest(Object var1);

    protected AmqpRpcClient getAmqpRpcClient() {
        return this.amqpRpcClient;
    }

    protected Marshaller getMarshaller() {
        return this.marshaller;
    }

    protected TimeService getTimeService() {
        return this.timeService;
    }

    protected abstract String getRequestRoutingKey(Request var1);

    protected abstract ResponseWithCorrelationId sendRequest(byte[] var1, String var2, String var3, int var4, boolean var5, boolean var6, boolean var7, AtomicLong var8);

    public Session getSession() {
        return this.session;
    }

    protected abstract void checkMessageDelay(AMQP.BasicProperties var1, int var2);

    protected void logCompression(AMQP.BasicProperties properties, Object object, int sizeCompressed, int sizeUncompressed, long unzipAndUnmarshall) {
        if (PERFORMANCE_LOG.isDebugEnabled()) {
            Object groupId = properties.getHeaders().get(this.messageSequenceCheck.getGroupHeaderName());
            PERFORMANCE_LOG.debug(COMPRESS_MARKER, "{} {} {} {} {} {}", unzipAndUnmarshall, object.getClass().getSimpleName(), sizeCompressed, sizeUncompressed, groupId, properties.getCorrelationId());
        }
    }

    protected abstract DateTime getServerTimestamp(AMQP.BasicProperties var1);

    private class TimeoutHandler {
        private final int timeoutInMillis;
        private final ScheduledExecutorService scheduledExecutorService;
        private ScheduledFuture<?> timeoutFuture;
        private Supplier<Collection<MessageSequenceCheck.Result>> resultSupplier;

        public TimeoutHandler(int timeoutInMillis, ScheduledExecutorService scheduledExecutorService, Supplier<Collection<MessageSequenceCheck.Result>> resultSupplier) {
            this.timeoutInMillis = timeoutInMillis;
            this.scheduledExecutorService = scheduledExecutorService;
            this.resultSupplier = resultSupplier;
        }

        public void startTimeout() {
            Runnable runnable = () -> {
                String messages = this.resultSupplier.get().stream().map(AbstractAmqpBackend.this::getGapDetectionNotification).collect(Collectors.joining("\n"));
                if (!messages.isEmpty()) {
                    AbstractAmqpBackend.this.notifyGapDetected(messages);
                }
            };
            this.timeoutFuture = this.scheduledExecutorService.schedule(runnable, (long)this.timeoutInMillis, TimeUnit.MILLISECONDS);
        }

        public boolean stopTimeout() {
            return this.timeoutFuture != null && this.timeoutFuture.cancel(false);
        }
    }

    public static class AmqpBackendException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AmqpBackendException(String message) {
            super(message);
        }

        public AmqpBackendException(String message, Throwable cause) {
            super(message, cause);
        }

        public AmqpBackendException(Throwable cause) {
            super(cause);
        }
    }
}

