/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AbstractAmqpBackend;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpConnectionManager;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpNames;
import com.deutscheboerse.comxerv.comtrader.service.amqp.BroadcastQueueListener;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MissingQueueException;
import com.deutscheboerse.comxerv.comtrader.service.amqp.SequenceCheckBroadcastListener;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpBroadcastClient {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpBroadcastClient.class);
    private static final boolean BASIC_CONSUME_AUTO_ACK = true;
    static final String BROADCAST_CONSUMER_TAG = "ComTrader-broadcast-consumer";
    private final String broadcastQueueName;
    private final SequenceCheckBroadcastListener listener;
    private final AmqpConnectionManager connectionManager;
    private volatile boolean stop = true;
    private final ExecutorService executorService;
    private Future<?> thread;

    public AmqpBroadcastClient(ApplicationContext appContext, Session session, AmqpConnectionManager connectionManager, AbstractAmqpBackend abstractAmqpBackend) {
        this.connectionManager = connectionManager;
        this.executorService = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.broadcastQueueName = appContext.getService(AmqpNames.class, session.getExchange()).getBroadcastQueueName(session.getRabbitUser());
        this.listener = new SequenceCheckBroadcastListener(appContext, abstractAmqpBackend, new BroadcastQueueListener(abstractAmqpBackend));
    }

    public void creatBroadcastQueue() throws IOException, TimeoutException {
        Channel broadcastChannel = this.connectionManager.getChannel(AmqpConnectionManager.ChannelId.BROADCAST_CHANNEL_ID, AmqpConnectionManager.ConnectionId.BROADCAST_CONNECTION_ID);
        try {
            broadcastChannel.queueDeclare(this.broadcastQueueName, false, false, false, Map.of("x-message-ttl", 60000, "x-expires", 80000, "x-queue-master-locator", "client-local"));
        }
        catch (IOException e) {
            LOG.warn("Cannot create broadcast queue. Reason: {}:{}. Relying on M7 backend to create it instead.", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            this.connectionManager.closeChannel(AmqpConnectionManager.ChannelId.BROADCAST_CHANNEL_ID);
        }
    }

    public synchronized void start() {
        if (this.thread != null && !this.thread.isDone()) {
            throw new IllegalStateException("Can't start broadcast thread when another one is running");
        }
        this.thread = this.executorService.submit(this::setupConsumer);
    }

    public synchronized void startProcessBroadcast() {
        this.listener.startProcessBroadcast();
    }

    public synchronized void stop() {
        this.stop = true;
        this.listener.stop();
        this.connectionManager.closeChannel(AmqpConnectionManager.ChannelId.BROADCAST_CHANNEL_ID);
        if (this.thread != null) {
            this.thread.cancel(true);
        }
    }

    public boolean isStopped() {
        return this.stop;
    }

    private void setupConsumer() {
        this.stop = false;
        try {
            Channel broadcastChannel = this.connectionManager.getChannel(AmqpConnectionManager.ChannelId.BROADCAST_CHANNEL_ID, AmqpConnectionManager.ConnectionId.BROADCAST_CONNECTION_ID);
            broadcastChannel.queueDeclarePassive(this.broadcastQueueName);
            Consumer consumer = new Consumer(){

                @Override
                public void handleConsumeOk(String consumerTag) {
                    LOG.info("Consume ok: {}", (Object)consumerTag);
                }

                @Override
                public void handleCancelOk(String consumerTag) {
                    LOG.info("Cancel ok: {}", (Object)consumerTag);
                }

                @Override
                public void handleCancel(String consumerTag) throws IOException {
                    LOG.warn("Consumer canceled: {}. Likely the queue is deleted.", (Object)consumerTag);
                    if (!AmqpBroadcastClient.this.stop) {
                        AmqpBroadcastClient.this.connectionManager.handleException(new MissingQueueException(AmqpConnectionManager.ChannelId.BROADCAST_CHANNEL_ID), AmqpConnectionManager.ChannelId.BROADCAST_CHANNEL_ID);
                    }
                }

                @Override
                public void handleShutdownSignal(String consumerTag, ShutdownSignalException signal) {
                    if (!AmqpBroadcastClient.this.stop) {
                        AmqpBroadcastClient.this.connectionManager.handleException(signal, AmqpConnectionManager.ChannelId.BROADCAST_CHANNEL_ID);
                    }
                }

                @Override
                public void handleRecoverOk(String consumerTag) {
                    LOG.info("Recover ok: {}", (Object)consumerTag);
                }

                @Override
                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    try {
                        LOG.debug("env: {}, property: {}", (Object)envelope, (Object)properties);
                        AmqpBroadcastClient.this.listener.processBroadcast(envelope, properties, body);
                    }
                    catch (Exception ex) {
                        LOG.error("Can't process broadcast", ex);
                    }
                }
            };
            broadcastChannel.basicConsume(this.broadcastQueueName, true, BROADCAST_CONSUMER_TAG, false, true, Collections.emptyMap(), consumer);
            LOG.info("Broadcast client started, consuming messages from {} channel.", (Object)AmqpConnectionManager.ChannelId.BROADCAST_CHANNEL_ID);
        }
        catch (Exception e) {
            if (!this.stop) {
                LOG.error("Unexpected error in AmqpBroadcastClient", e);
                this.listener.handleAmqpConnectionError(e);
            }
            this.connectionManager.closeChannel(AmqpConnectionManager.ChannelId.BROADCAST_CHANNEL_ID);
        }
    }
}

