/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpBroadcastListener;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ComTraderConnectionFactory;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.TopologyRecoveryException;
import com.rabbitmq.client.impl.DefaultExceptionHandler;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConnectionManager.class);
    private final ComTraderConnectionFactory connectionFactory;
    private final AmqpBroadcastListener amqpListener;
    private final Map<ChannelId, Channel> channels = new ConcurrentHashMap<ChannelId, Channel>();
    private final Map<ConnectionId, Connection> connections = new ConcurrentHashMap<ConnectionId, Connection>();

    public AmqpConnectionManager(ComTraderConnectionFactory connectionFactory, AmqpBroadcastListener amqpListener) {
        this.connectionFactory = connectionFactory;
        this.connectionFactory.setExceptionHandler(this.exceptionHandler());
        this.amqpListener = amqpListener;
    }

    private DefaultExceptionHandler exceptionHandler() {
        return new DefaultExceptionHandler(){

            @Override
            public void handleTopologyRecoveryException(Connection conn, Channel ch, TopologyRecoveryException exception) {
                super.handleTopologyRecoveryException(conn, ch, exception);
                AmqpConnectionManager.this.handleException(exception, null);
            }
        };
    }

    public boolean handleException(Exception e, ChannelId channelId) {
        LOG.error("Handle {} on {}. Reason: {}", new Object[]{e.getClass().getSimpleName(), channelId, e.getMessage()});
        if (this.amqpListener.handleAmqpConnectionError(e)) {
            return true;
        }
        if (e instanceof IOException) {
            this.close();
        } else if (e instanceof ShutdownSignalException) {
            ShutdownSignalException shutdownSignalException = (ShutdownSignalException)e;
            if (channelId != null) {
                this.closeChannel(channelId);
            }
            if (shutdownSignalException.isHardError()) {
                this.close();
            }
        }
        return false;
    }

    public synchronized Channel getChannel(ChannelId channelId, ConnectionId connectionId) throws IOException, TimeoutException {
        if (!this.channels.containsKey((Object)channelId)) {
            this.channels.put(channelId, this.createChannel(connectionId));
        }
        return this.channels.get((Object)channelId);
    }

    public Channel createChannel(ConnectionId connectionId) throws IOException, TimeoutException {
        this.createConnectionIfNeeded(connectionId);
        Channel channel = this.connections.get((Object)connectionId).createChannel();
        if (channel instanceof Recoverable) {
            Recoverable recoverableChannel = (Recoverable)((Object)channel);
            recoverableChannel.addRecoveryListener(new RecoveryListener(this){

                @Override
                public void handleRecovery(Recoverable recoverable) {
                    LOG.info("Recovered: {}", (Object)recoverable);
                }

                @Override
                public void handleRecoveryStarted(Recoverable recoverable) {
                    LOG.info("Recovering: {}", (Object)recoverable);
                }
            });
        }
        return channel;
    }

    private synchronized void createConnectionIfNeeded(ConnectionId connectionId) throws IOException, TimeoutException {
        if (!this.connections.containsKey((Object)connectionId)) {
            this.connections.put(connectionId, this.connectionFactory.createConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        try {
            HashSet<ChannelId> ids = new HashSet<ChannelId>(this.channels.keySet());
            for (ChannelId id : ids) {
                this.closeChannel(id);
            }
        }
        finally {
            this.connections.forEach(this::closeConnection);
        }
    }

    private void closeConnection(ConnectionId connectionId, Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (ShutdownSignalException | IOException ex) {
                LOG.error("{}", (Object)ex.getMessage());
            }
        }
        this.connections.remove((Object)connectionId);
    }

    public void closeChannel(ChannelId id) {
        Channel channel = this.channels.get((Object)id);
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (ShutdownSignalException | IOException | TimeoutException ex) {
                LOG.error("{}", (Object)ex.getMessage());
            }
        }
        this.channels.remove((Object)id);
    }

    public static enum ChannelId {
        REQUEST_CHANNEL_ID("requestChannel"),
        RESPONSE_CHANNEL_ID("responseChannel"),
        BROADCAST_CHANNEL_ID("broadcastChannel");

        private final String id;

        private ChannelId(String text) {
            this.id = text;
        }

        public String toString() {
            return this.id;
        }
    }

    public static enum ConnectionId {
        RPC_CONNECTION_ID("rpcConnection"),
        BROADCAST_CONNECTION_ID("broadcastConnection");

        private final String id;

        private ConnectionId(String text) {
            this.id = text;
        }

        public String toString() {
            return this.id;
        }
    }
}

