/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParameters;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.ProxySettings;
import com.deutscheboerse.comxerv.comtrader.service.SecureConnectionHelper;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ComTraderFrameHandlerFactory;
import com.deutscheboerse.comxerv.comtrader.util.AesEncrypt;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.base.Preconditions;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.AuthenticationFailureException;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ListAddressResolver;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryDelayHandler;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.TrustEverythingTrustManager;
import com.rabbitmq.client.impl.FrameHandlerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComTraderConnectionFactory
extends ConnectionFactory {
    private static final List<Long> RECOVERY_SEQUENCE = Arrays.asList(1000L, 1000L, 1000L, 2000L, 2000L, 2000L, 3000L, 3000L, 5000L, 5000L, 8000L, 8000L);
    private static final String CONNECTION_NAME = "ComTraderConnection";
    private static final Logger LOG = LoggerFactory.getLogger(ComTraderConnectionFactory.class);
    private final ProxySettings proxySettings;
    private final Exchange exchange;
    private final ConnectionParameters params;
    private final ExecutorService executorService;
    private final boolean automaticRecovery;
    private final int requestedHearbeatTimeout;

    public ComTraderConnectionFactory(ExecutorService executorService, ConnectionParameters params, ProxySettings proxySettings, ApplicationConfigurationService applicationConfigurationService) throws LoginException {
        this.executorService = executorService;
        this.proxySettings = proxySettings;
        this.params = params;
        this.automaticRecovery = applicationConfigurationService.getBooleanApplicationProperty("automatic.recovery");
        this.requestedHearbeatTimeout = applicationConfigurationService.getIntegerApplicationProperty("default.heartbeat", 60);
        this.exchange = Exchange.get(this.params.getExchangeId());
        this.loadParams();
    }

    @Override
    protected synchronized FrameHandlerFactory createFrameHandlerFactory() throws IOException {
        return new ComTraderFrameHandlerFactory(this.getConnectionTimeout(), this.getSocketFactory(), this.getSocketConfigurator(), this.isSSL(), this.proxySettings);
    }

    public Connection createConnection() throws IOException, TimeoutException {
        Connection connection = this.tryCreateConnection();
        if (connection instanceof Recoverable) {
            ((Recoverable)((Object)connection)).addRecoveryListener(new RecoveryListener(this){

                @Override
                public void handleRecoveryStarted(Recoverable recoverable) {
                    LOG.warn("Connection recovery started: {}", (Object)recoverable);
                }

                @Override
                public void handleRecovery(Recoverable recoverable) {
                    LOG.warn("Connection recovery finished: {}", (Object)recoverable);
                }
            });
        }
        return connection;
    }

    private Connection tryCreateConnection() throws IOException, TimeoutException {
        Connection connection = null;
        Exception lastException = null;
        ArrayList<Address> listAddresses = null;
        for (Address addr : this.params.getAddresses()) {
            listAddresses = new ArrayList<Address>();
            listAddresses.add(addr);
            try {
                connection = this.newConnection(this.executorService, new ListAddressResolver(listAddresses), CONNECTION_NAME);
                lastException = null;
                break;
            }
            catch (AuthenticationFailureException e) {
                throw e;
            }
            catch (IOException | TimeoutException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            if (lastException instanceof IOException) {
                throw (IOException)lastException;
            }
            if (lastException instanceof TimeoutException) {
                throw (TimeoutException)lastException;
            }
        }
        if (listAddresses != null) {
            listAddresses.clear();
            listAddresses.addAll(this.params.getAddresses());
        }
        return connection;
    }

    private void loadParams() throws LoginException {
        this.setUsername(this.params.getRabbitUser());
        this.setPassword(this.params.getRabbitPassword());
        this.setHost(this.params.getRabbitHost());
        this.setPort(this.params.getRabbitPort());
        this.setVirtualHost(this.params.getRabbitVHost());
        this.setRequestedHeartbeat(this.requestedHearbeatTimeout);
        this.setAutomaticRecoveryEnabled(this.automaticRecovery);
        if (this.automaticRecovery) {
            this.setRecoveryDelayHandler(new RecoveryDelayHandler.ExponentialBackoffDelayHandler(RECOVERY_SEQUENCE));
            this.setConnectionRecoveryTriggeringCondition(e -> !this.isInitiatedByApplication((ShutdownSignalException)e) && !this.isAccessRefused((ShutdownSignalException)e));
            this.setTopologyRecoveryEnabled(false);
        }
        this.setSocketFactory(SocketFactory.getDefault());
        if (BooleanUtils.isTrue(this.params.getUseNonSslConnection())) {
            LOG.info("no SSL context setup for target host: {}", (Object)this.getHost());
        } else {
            LOG.info("set up SSL context");
            this.useSslProtocol(this.createSslContext());
        }
    }

    private boolean isInitiatedByApplication(ShutdownSignalException e) {
        return e.isInitiatedByApplication() || this.isConnectionClosedWithReason(e, 320);
    }

    private boolean isConnectionClosedWithReason(ShutdownSignalException e, int connectionForced) {
        return e.getReason() instanceof AMQP.Connection.Close && ((AMQP.Connection.Close)e.getReason()).getReplyCode() == connectionForced;
    }

    private boolean isAccessRefused(ShutdownSignalException e) {
        return this.isConnectionClosedWithReason(e, 403);
    }

    private SSLContext createSslContext() throws LoginException {
        SSLContext sSLContext;
        block9: {
            InputStream certificate = this.getCertificate();
            try {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                char[] certificatePassword = this.getCertificatePassword();
                ks.load(certificate, certificatePassword);
                Util.closeQuietly(certificate);
                if (this.params.getOwnCertificateEnabled() && this.params.getCertificatePerUser()) {
                    this.certificatePerUserValidation(ks);
                }
                String algorithmX509 = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithmX509);
                kmf.init(ks, certificatePassword);
                SSLContext ctx = SSLContext.getInstance("TLSv1.2");
                ctx.init(kmf.getKeyManagers(), this.getTrustManagers(), null);
                sSLContext = ctx;
                if (certificate == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (certificate != null) {
                        try {
                            certificate.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new LoginException(Util.getLabel("certificate_error_other"), LoginException.ErrorType.SSL_CERTIFICATE_ERROR, e);
                }
            }
            certificate.close();
        }
        return sSLContext;
    }

    private TrustManager[] getTrustManagers() throws GeneralSecurityException, IOException, LoginException {
        if (Boolean.getBoolean("disableAmqpSslChecks")) {
            return new TrustManager[]{new TrustEverythingTrustManager()};
        }
        if (StringUtils.isNotBlank(this.params.getServerCertFilePath())) {
            return SecureConnectionHelper.getTrustManagers(this.params.getServerCertFilePath());
        }
        return SecureConnectionHelper.getTrustManagers(this.exchange.getCustomTrustStore(), this.exchange.getCustomTrustStorePassword());
    }

    private void certificatePerUserValidation(KeyStore ks) throws LoginException {
        try {
            X509Certificate x509cert = (X509Certificate)ks.getCertificate("1");
            String dn = x509cert.getSubjectX500Principal().getName();
            LdapName ldapDN = new LdapName(dn);
            boolean isSameUser = false;
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!rdn.getType().equals("CN") || !rdn.getValue().equals(this.getUsername())) continue;
                isSameUser = true;
                break;
            }
            if (!isSameUser) {
                throw new LoginException(Util.getLabel("certificate_error_username_mismatch"));
            }
        }
        catch (Exception e) {
            LOG.error("Certificate error: username [" + this.getUsername() + "] - certificate mismatch; ", e);
            throw new LoginException(Util.getLabel("certificate_error_username_mismatch"), LoginException.ErrorType.SSL_CERTIFICATE_ERROR, e);
        }
    }

    private InputStream getCertificate() throws LoginException {
        if (this.params.getUseOwnCertificate()) {
            try {
                FileInputStream inputStream = new FileInputStream(new File(this.params.getCertificatePath()));
                LOG.info("Own certificate used: {}", (Object)this.params.getCertificatePath());
                return inputStream;
            }
            catch (FileNotFoundException | NullPointerException e) {
                throw new LoginException(Util.getLabel("certificate_error_fileNotFound"), LoginException.ErrorType.SSL_CERTIFICATE_ERROR, e);
            }
        }
        InputStream certificate = ComTraderConnectionFactory.class.getResourceAsStream(this.params.getDefaultCertificatePath());
        if (certificate == null) {
            LOG.error("Certificate not found: {}", (Object)this.params.toDetailedString());
            throw new LoginException(Util.getLabel("certificate_error_other"), LoginException.ErrorType.SSL_CERTIFICATE_ERROR);
        }
        return certificate;
    }

    private char[] getCertificatePassword() throws LoginException {
        char[] cArray;
        block9: {
            if (this.params.getUseOwnCertificate()) {
                return AesEncrypt.decrypt(this.params.getRabbitPassword().toCharArray(), this.params.getCertificatePassword()).toCharArray();
            }
            InputStream is = ComTraderConnectionFactory.class.getResourceAsStream(this.params.getDefaultCertificatePassword());
            try {
                List<String> lines = IOUtils.readLines(is, StandardCharsets.UTF_8);
                Preconditions.checkArgument(lines.size() == 1, "certificate.pass must have only one line!");
                cArray = lines.get(0).toCharArray();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new LoginException(Util.getLabel("certificate_error_other"), LoginException.ErrorType.SSL_CERTIFICATE_ERROR, e);
                }
            }
            is.close();
        }
        return cArray;
    }
}

