/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.async;

import com.deutscheboerse.comxerv.comtrader.service.async.ErrorType;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import java.util.Objects;

public class AsyncResponse {
    private final ResponseStatus status;
    private final String clientOrderId;
    private final String message;
    private final ErrorType errorType;

    public AsyncResponse(ResponseStatus status, String clientOrderId) {
        this.status = status;
        this.clientOrderId = clientOrderId;
        this.message = "";
        this.errorType = status == ResponseStatus.ERROR ? ErrorType.GENERAL_TECHNICAL_ERROR : null;
    }

    public AsyncResponse(ResponseStatus status, String clientOrderId, String message, ErrorType errorType) {
        this.status = status;
        this.clientOrderId = clientOrderId;
        this.message = message;
        this.errorType = errorType;
    }

    public AsyncResponse copyWithClientOrderId(String clientOrderId) {
        return new AsyncResponse(this.status, clientOrderId, this.message, this.errorType);
    }

    public ResponseStatus getStatus() {
        return this.status;
    }

    public String getClientOrderId() {
        return this.clientOrderId;
    }

    public String getMessage() {
        return this.message;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncResponse that = (AsyncResponse)o;
        return this.status == that.status && Objects.equals(this.clientOrderId, that.clientOrderId) && Objects.equals(this.message, that.message) && this.errorType == that.errorType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.clientOrderId, this.message, this.errorType});
    }

    public String toString() {
        return "AsyncResponse{, status=" + String.valueOf((Object)this.status) + ", clientOrderId='" + this.clientOrderId + "', message='" + this.message + "', errorType=" + String.valueOf((Object)this.errorType) + "}";
    }
}

