/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.comxerv;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderLimitQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.comxerv.ProductValidator;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.CommonOrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidator;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.SimpleValidationResult;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMode;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.DependentObservableValue;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComXervOrderValidator
implements OrderValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ComXervOrderValidator.class);
    public static final int MAX_TEXT_LENGTH = 250;
    public static final int MAX_WORD_LENGTH = 64;
    public static final int MAX_FACILITY_TYPE_LENGTH = 16;
    public static final String WORD_SYM_PATTERN = "[a-zA-Z0-9\\-_./&()#\\\\]+";
    public static final String WORD_PATTERN = "[a-zA-Z0-9]+";
    public static final Range<Integer> INTEGER_RANGE = Range.closed(1, 100);
    private final TimeService timeService;
    private final UserService userService;
    private final AssignmentService assignmentService;
    private final OrderLimitQueries orderLimitQueries;
    private final ProductValidator productValidator;

    @Inject
    public ComXervOrderValidator(ApplicationContext appContext) {
        this.timeService = appContext.getService(TimeService.class);
        this.userService = appContext.getService(UserService.class);
        this.orderLimitQueries = appContext.getService(OrderLimitQueries.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
        this.productValidator = appContext.getService(ProductValidator.class);
    }

    @Override
    public OrderValidationService.ValidationResult validateOrder(Order order, ValidationMode mode) {
        User user = order.getOnBehalfUser() != null ? order.getOnBehalfUser() : this.userService.getCurrentUser();
        LongDisplayValue price = order.getLimitPrice();
        LongDisplayValue quantity = order.getRemainingQuantity();
        LongDisplayValue peakQuantity = order.getPeakQuantity();
        LongDisplayValue peakPriceDelta = order.getPeakPriceDelta();
        OpenOrClose openCloseIndicator = order.getOpenOrClose();
        Contract contract = order.getContract();
        Product product = contract == null ? null : contract.getProduct();
        LinkedHashSet<ValidationMessage> validationMessages = Sets.newLinkedHashSet();
        HashMap<ValidationMessage, List<String>> parameterMap = Maps.newHashMap();
        Exchange exchange = order.getExchange();
        try {
            if (contract == null) {
                if (mode.isOrderEntryMode()) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_CONTRACT);
                }
            } else if (!contract.getCompoundStatus().getContractStatus().isActive()) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INACTIVE_CONTRACT);
            }
            if (price == null && mode.isOrderEntryMode()) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_LIMIT_PRICE);
            }
            if (contract != null && product == null) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_PRODUCT);
            } else if (contract != null) {
                Optional<OrderLimit> orderLimit;
                LongDisplayValue minPrice = product.getPriceMinValue();
                LongDisplayValue maxPrice = product.getPriceMaxValue();
                LongDisplayValue priceMinIncrement = product.getPriceTickSize();
                if (price != null && (price.getValue() < minPrice.getValue() || price.getValue() > maxPrice.getValue())) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_LIMIT_PRICE);
                }
                if (price != null && (price.getShift() > product.getPriceDecimalShift() || price.getValue() % priceMinIncrement.getValue() != 0L)) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_LIMIT_PRICE);
                }
                if (quantity == null && mode.isOrderEntryMode()) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_REMAINING_QUANTITY);
                }
                if (quantity != null && quantity.getValue() < product.getQuantityMinValue().getValue()) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_REMAINING_QUANTITY);
                }
                if (quantity != null && ((orderLimit = this.orderLimitQueries.findOrderLimitForProduct(product)).isPresent() && quantity.getDisplayValue().compareTo(orderLimit.get().getMaxQuanity().getDisplayValue()) > 0 || quantity.getValue() > product.getQuantityMaxValue().getValue())) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_EXCEEDED_MAX_QUANTITY);
                }
                int qtyShift = product.getQuantityDecimalShift();
                LongDisplayValue qtyMinIncrement = product.getQuantityLotSize();
                if (quantity != null && (quantity.getShift() > qtyShift || quantity.getValue() % qtyMinIncrement.getValue() != 0L)) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_REMAINING_QUANTITY);
                }
                if (order.getOrderType() == OrderType.ICEBERG && (peakQuantity == null || peakQuantity.getValue() < product.getIcebergMinPeakSize().getValue() || peakQuantity.getShift() > qtyShift || peakQuantity.getValue() % qtyMinIncrement.getValue() != 0L)) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_PEAK_QUANTITY);
                }
                if (order.getOrderType() == OrderType.ICEBERG && peakPriceDelta != null) {
                    if (product.getPriceTickSize().getValue() != 0L && peakPriceDelta.getValue() % product.getPriceTickSize().getValue() != 0L) {
                        validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_PEAK_PRICE_DELTA);
                    }
                    if (order.getDirection() == Direction.BUY && peakPriceDelta.getValue() > 0L || order.getDirection() == Direction.SELL && peakPriceDelta.getValue() < 0L) {
                        validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_PEAK_PRICE_DELTA);
                    }
                    if (Math.abs(peakPriceDelta.getValue()) > product.getIcebergPriceDeltaRange().getValue()) {
                        validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_PEAK_PRICE_DELTA_RANGE);
                    }
                    if (quantity != null && peakQuantity != null && order.getLimitPrice() != null && peakQuantity.getValue() != 0L) {
                        LongDisplayValue lastPrice;
                        int numberOfPeaks = (int)(quantity.getValue() / peakQuantity.getValue());
                        if (quantity.getValue() % peakQuantity.getValue() == 0L) {
                            --numberOfPeaks;
                        }
                        if (minPrice.compareTo(lastPrice = order.getLimitPrice().add(peakPriceDelta.getValue() * (long)numberOfPeaks)) > 0 || maxPrice.compareTo(lastPrice) < 0) {
                            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_PEAK_PRICE_DELTA_RANGE);
                        }
                    }
                }
                if (!(order.getStopPrice() == null && order.getOrderType() != OrderType.STOP || product.isStopOrderSupported())) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_SPRC_NOT_SUPPORTED);
                }
            }
            if (quantity != null && peakQuantity != null && (peakQuantity.getValue() > quantity.getValue() || peakQuantity.getValue() <= 0L)) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_PEAK_QUANTITY);
            }
            if (order.getOrderType() != OrderType.ICEBERG && peakQuantity != null && peakQuantity.getValue() > 0L) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_PEAK_QUANTITY_NON_ICB);
            }
            if (order.getOrderType() == OrderType.ICEBERG && product != null && !product.isIcebergOrdersSupported()) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_ICB_NOT_SUPPORTED);
            }
            if (order.getDeliveryArea() == null && mode.isOrderEntryMode()) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_DA);
            }
            if (order.getValidityRestriction() == ValidityRestriction.GOOD_TILL_DATE && order.getValidityDate() == null) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_VAL_DATE);
            }
            if (contract != null && order.getValidityDate() != null && order.getValidityRestriction() == ValidityRestriction.GOOD_TILL_DATE) {
                DateTime validityDate = order.getValidityDate();
                if (validityDate.isBefore(this.timeService.getServerTime())) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_VAL_DATE);
                }
                if (validityDate.getMinuteOfHour() % 5 != 0) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_VAL_DATE);
                }
            }
            if (order.getValidityDate() != null && order.getValidityRestriction() == ValidityRestriction.NONE) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_REDUNDANT_VAL_DATE);
            }
            if ((order.getExecutionRestriction() == ExecutionRestriction.FILL_OR_KILL || order.getExecutionRestriction() == ExecutionRestriction.IMMEDIATE_OR_CANCEL) && order.getValidityRestriction() != ValidityRestriction.NONE) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_VAL_RES);
            }
            if ((order.getExecutionRestriction() == ExecutionRestriction.NONE || order.getExecutionRestriction() == ExecutionRestriction.ALL_OR_NOTHING) && order.getValidityRestriction() == ValidityRestriction.NONE) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_VAL_RES);
            }
            if (contract != null && order.getExecutionRestriction() != ExecutionRestriction.ALL_OR_NOTHING && order.getExecutionRestriction() != ExecutionRestriction.IMMEDIATE_OR_CANCEL && contract.getType() == ContractType.UDB) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_EXEC_RES);
            }
            if (order.getContract() != null && (order.getContract().getType().isCanonical() || order.getContract().getType() == ContractType.UDDP) && order.getOrderType() != OrderType.OTC_PREARRANGED && order.getExecutionRestriction() != ExecutionRestriction.ALL_OR_NOTHING && order.getExecutionRestriction() != ExecutionRestriction.IMMEDIATE_OR_CANCEL && order.getExecutionRestriction() != ExecutionRestriction.FILL_OR_KILL && order.getProduct().getExecutionRestriction() == ProductExecutionRestriction.ALL_OR_NOTHING) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_EXEC_RES);
            }
            if (order.getContract() != null && (order.getContract().getType().isCanonical() || order.getContract().getType() == ContractType.UDDP) && order.getOrderType() != OrderType.OTC_PREARRANGED && order.getExecutionRestriction() != ExecutionRestriction.NONE && order.getExecutionRestriction() != ExecutionRestriction.IMMEDIATE_OR_CANCEL && order.getExecutionRestriction() != ExecutionRestriction.FILL_OR_KILL && order.getProduct().getExecutionRestriction() == ProductExecutionRestriction.PARTIAL_EXECUTION) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_EXEC_RES);
            }
            if (order.getOrderType() == OrderType.OTC_PREARRANGED && order.getPreArrangedBalancingGroupId() == null) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_TARGET_BG);
            }
            if (order.getOrderType() == OrderType.ICEBERG && order.getExecutionRestriction() != ExecutionRestriction.NONE) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_EXEC_RES);
            }
            if (order.getText() != null && order.getText().length() > 250) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_TEXT_TOO_LONG);
            }
            this.validateGopacsFields(order, validationMessages);
            if (order.getBalancingGroupId() == null && mode.isOrderEntryMode()) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_BG);
            }
            if (order.getOrderType() == OrderType.STOP && order.getLimitPrice() != null) {
                if (order.getStopPrice() == null) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_SPRC);
                } else if (order.getLimitPrice().compareTo(order.getStopPrice()) < 0 && order.getDirection() == Direction.BUY) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_SPRC_LOWER_THEN_LIMIT_PRICE);
                } else if (order.getLimitPrice().compareTo(order.getStopPrice()) > 0 && order.getDirection() == Direction.SELL) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_SPRC_GRATER_THEN_LIMIT_PRC);
                }
            }
            if (contract != null && exchange != null && exchange.getSystemInfo().supportsOpenCloseIndicator()) {
                boolean supportsOpenCloseIndicator = contract.supportsOpenCloseIndicator();
                if (openCloseIndicator != null && !supportsOpenCloseIndicator) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_OPEN_CLOSE_INDICATOR_NOT_SUPPORTED);
                }
                if (openCloseIndicator == null && supportsOpenCloseIndicator) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_OPEN_CLOSE_INDICATOR_MANDATORY);
                }
            }
            if (contract != null && ContractPhase.CLSD.equals(contract.getCompoundStatus().deliveryAreaPhaseProperty(order.getDeliveryArea()).getValue())) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_DELIVERY_AREA_STATUS_INACTIVE);
            }
            if (product != null && !this.assignmentService.isUserAssignedToBgProductAndDa(user, order.getBalancingGroupId(), (String)order.getProduct().getId(), order.getDeliveryAreaId())) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_ASSIGNMENT);
            }
            if (product != null && order.getRemainingQuantity() != null && order.getLimitPrice() != null) {
                Optional<OrderLimit> orderLimit = this.orderLimitQueries.findOrderLimitForProduct(product);
                BigDecimal amount = quantity.getDisplayValue().multiply(price.getDisplayValue()).multiply(BigDecimal.valueOf(product.getDeliveryUnits()));
                if (orderLimit.isPresent() && orderLimit.get().getMaxAmount().getValue() != 0L && orderLimit.get().getMaxAmount().getDisplayValue().compareTo(amount) < 0) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_AMOUNT);
                    parameterMap.put(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_AMOUNT, Collections.singletonList(orderLimit.get().getMaxAmount().getDisplayValue().toString()));
                } else if (product.getAmountMaxValue().getValue() != 0L && product.getAmountMaxValue().getDisplayValue().compareTo(amount) < 0) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_AMOUNT);
                    parameterMap.put(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_AMOUNT, Collections.singletonList(product.getAmountMaxValue().getDisplayValue().toString()));
                }
            }
            if (Boolean.TRUE.equals(order.getAot())) {
                if (!this.productValidator.isProductAotEnabled(product)) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_AOT_NOT_ENABLED);
                }
                if (order.getExecutionRestriction() != null && order.getExecutionRestriction() != ExecutionRestriction.NONE) {
                    validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_AOT_EXEC_RES);
                    parameterMap.put(ValidationMessage.ORDER_VALIDATION_ERROR_AOT_EXEC_RES, Collections.singletonList(order.getExecutionRestriction().toString()));
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error("Error thrown during validation", e);
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_TECHNICAL_ERROR);
        }
        CommonOrderValidationService.ValidationFlag flag = this.defineValidationResult(validationMessages);
        SimpleValidationResult validationResult = new SimpleValidationResult(flag, validationMessages, parameterMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Order validation result: {} {}", (Object)validationResult.getLocalizedErrorMessageKeys(), (Object)order);
        }
        return validationResult;
    }

    private void validateGopacsFields(Order order, Set<ValidationMessage> validationMessages) {
        if (order.getProduct() != null) {
            if (order.getProduct().isLocationsEnabled()) {
                this.validateLocation(order, validationMessages);
                this.validateMarketBased(order, validationMessages);
                this.validateContractReference(order, validationMessages);
                this.validateFacilityType(order, validationMessages);
                this.validateUsageFraction(order, validationMessages);
            } else if (StringUtils.isNotEmpty(order.getLocation()) || order.isMarketBased() != null || StringUtils.isNotEmpty(order.getContractReference()) || StringUtils.isNotEmpty(order.getFacilityType()) || order.getUsageFraction() != null) {
                validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_LOCATION_NOT_ALLOWED);
            }
        }
    }

    private void validateMarketBased(Order order, Set<ValidationMessage> validationMessages) {
        if (order.isMarketBased() == null) {
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_MARKET_BASED_MANDATORY);
        }
    }

    private void validateLocation(Order order, Set<ValidationMessage> validationMessages) {
        if (StringUtils.isEmpty(order.getLocation())) {
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_LOCATION_MANDATORY);
        } else if (order.getLocation().length() > 64) {
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_LOCATION_TOO_LONG);
        } else if (!Pattern.compile(WORD_SYM_PATTERN).matcher(order.getLocation()).matches()) {
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_LOCATION);
        }
    }

    private void validateContractReference(Order order, Set<ValidationMessage> validationMessages) {
        if (StringUtils.isEmpty(order.getContractReference())) {
            return;
        }
        if (order.getContractReference().length() > 64) {
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_CONTRACT_REFERENCE_TOO_LONG);
        } else if (!Pattern.compile(WORD_SYM_PATTERN).matcher(order.getContractReference()).matches()) {
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_CONTRACT_REFERENCE);
        }
    }

    private void validateFacilityType(Order order, Set<ValidationMessage> validationMessages) {
        if (StringUtils.isEmpty(order.getFacilityType())) {
            return;
        }
        if (order.getFacilityType().length() > 16) {
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_FACILITY_TYPE_TOO_LONG);
        } else if (!Pattern.compile(WORD_PATTERN).matcher(order.getFacilityType()).matches()) {
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_FACILITY_TYPE);
        }
    }

    private void validateUsageFraction(Order order, Set<ValidationMessage> validationMessages) {
        if (order.getUsageFraction() == null) {
            return;
        }
        if (!INTEGER_RANGE.contains(order.getUsageFraction())) {
            validationMessages.add(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_USAGE_FRACTION_RANGE);
        }
    }

    private CommonOrderValidationService.ValidationFlag defineValidationResult(Set<ValidationMessage> validationMessages) {
        if (validationMessages.isEmpty() || validationMessages.stream().allMatch(v -> v.getValidationMessageSeverity() == ValidationMessage.ValidationMessageSeverity.WARNING)) {
            return CommonOrderValidationService.ValidationFlag.SUBMIT;
        }
        if (validationMessages.stream().anyMatch(v -> v.getValidationMessageSeverity() == ValidationMessage.ValidationMessageSeverity.BLOCKING)) {
            return CommonOrderValidationService.ValidationFlag.INVALID;
        }
        if (validationMessages.stream().anyMatch(v -> v.getValidationMessageSeverity() == ValidationMessage.ValidationMessageSeverity.BASKET_ONLY)) {
            return CommonOrderValidationService.ValidationFlag.BASKET;
        }
        throw new IllegalArgumentException("Unkown severity of messages present in set: " + String.valueOf(validationMessages));
    }

    @Override
    public ReadOnlyObjectProperty<OrderValidationService.ValidationResult> validationResultProperty(final Order order) {
        DependentObservableValue<Contract, ContractPhase> deliveryAreaPhase = new DependentObservableValue<Contract, ContractPhase>(this, order.contractProperty(), new Observable[]{order.deliveryAreaProperty()}){

            @Override
            public ObservableValue<ContractPhase> getObservableValue(Contract contract) {
                return new WeakObservableValue<ContractPhase>(contract.getCompoundStatus().deliveryAreaPhaseProperty(order.getDeliveryArea()));
            }
        };
        deliveryAreaPhase.addListener(observable2 -> deliveryAreaPhase.getValue());
        SimpleObjectProperty<OrderValidationService.ValidationResult> result = new SimpleObjectProperty<OrderValidationService.ValidationResult>();
        result.bind(new DependentBinding<OrderValidationService.ValidationResult>(new Observable[]{order.directionProperty(), order.textProperty(), order.limitPriceProperty(), order.remainingQuantityProperty(), order.peakQuantityProperty(), order.peakPriceDeltaProperty(), order.preArrangedBalancingGroupProperty(), order.balancingGroupProperty(), order.contractProperty(), order.deliveryAreaProperty(), order.orderTypeProperty(), order.executionRestrictionProperty(), order.validityRestrictionProperty(), order.validityDateProperty(), order.stopPriceProperty(), order.openOrCloseProperty(), order.locationProperty(), order.marketBasedProperty(), order.contractReferenceProperty(), order.facilityTypeProperty(), order.usageFractionProperty(), deliveryAreaPhase}){

            @Override
            protected OrderValidationService.ValidationResult computeValue() {
                return ComXervOrderValidator.this.validateOrder(order, ValidationMode.ORDERENTRY);
            }
        });
        return result;
    }
}

