/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv;

import com.deutscheboerse.comxerv.comtrader.entities.type.JodaDateFormatType;
import com.deutscheboerse.comxerv.comtrader.entities.type.NumberStyleType;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.csv.ExportWriter;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class HTMLExportWriter
implements ExportWriter {
    private final LocalService localService;

    @Inject
    public HTMLExportWriter(LocalService localService) {
        this.localService = localService;
    }

    @Override
    public void writeHeader(Writer writer, List<String> columnNames) throws IOException {
        NumberStyleType numberStyleType = this.localService.getNumberStyleType();
        JodaDateFormatType dateFormatType = this.localService.getJodaDateFormat();
        boolean groupingSeparatorEnabled = this.localService.isGroupingSeparatorEnabled();
        writer.write(String.format("%s%n", "<html xmlns:o=\"urn:schemas-microsoft-com:office:office\""));
        writer.write(String.format("%s%n", "      xmlns:x=\"urn:schemas-microsoft-com:office:excel\""));
        writer.write(String.format("%s%n", "      xmlns=\"http://www.w3.org/TR/REC-html40\">"));
        writer.write(String.format("%s%n", "<head>"));
        writer.write(String.format("%s%n", " <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />"));
        writer.write(String.format("%s%n", " <style type=\"text/css\">"));
        writer.write(String.format("%s%n", "  <!--"));
        writer.write(String.format("%s%n", "  /* " + numberStyleType.getDisplayName() + (groupingSeparatorEnabled ? " with thousand separator" : " without thousand separator") + " */"));
        writer.write(String.format("%s%n", "  table     {"));
        writer.write(String.format("%s%n", "              mso-displayed-decimal-separator: \"\\" + (numberStyleType == NumberStyleType.EUROPEAN ? "," : ".") + "\";"));
        writer.write(String.format("%s%n", "              mso-displayed-thousand-separator: \"\\" + (numberStyleType == NumberStyleType.EUROPEAN ? "." : ",") + "\";"));
        writer.write(String.format("%s%n", "            }"));
        writer.write(String.format("%s%n", "  col       { mso-width-source: auto;}"));
        writer.write(String.format("%s%n", "  td, th    { mso-height-source: auto; white-space: nowrap; }"));
        writer.write(String.format("%s%n", "  .text     { mso-number-format: \\@ }"));
        writer.write(String.format("%s%n", "  .datetime { mso-number-format: \"" + this.getDateFormatTypePattern(dateFormatType) + "\"; }"));
        writer.write(String.format("%s%n", "  .percent  { mso-number-format: \"Percent\"; text-align:right; }"));
        writer.write(String.format("%s%n", "  .int      { mso-number-format: \"\\#\\,\\#\\#0\"; text-align:right;}"));
        writer.write(String.format("%s%n", "  .num      { mso-number-format: \"\\#" + (groupingSeparatorEnabled ? "\\," : "") + "\\#\\#0\\.000\"; }"));
        writer.write(String.format("%s%n", "  .account  { mso-number-format: \"\\#\\,\\#\\#0;[Red\\]\\(\\#\\,\\#\\#0\\);\\-\"; text-align:right;}"));
        writer.write(String.format("%s%n", "  .money    { mso-number-format: \"Currency\"; text-align:right; }"));
        writer.write(String.format("%s%n", "  -->"));
        writer.write(String.format("%s%n", " </style>"));
        writer.write(String.format("%s%n", "</head>"));
        writer.write(String.format("%s%n", "<body>"));
        writer.write(String.format("%s%n", "<table>"));
        if (!columnNames.isEmpty()) {
            writer.write(String.format("%s%n", "<tr>"));
            for (String columnName : columnNames) {
                writer.write("<th>");
                writer.write(columnName);
                writer.write(String.format("%s%n", "</th>"));
            }
            writer.write(String.format("%s%n", "</tr>"));
        }
    }

    private String getDateFormatTypePattern(JodaDateFormatType dateFormatType) {
        String pattern = dateFormatType == JodaDateFormatType.FORMAT_WITH_DOT_DD_MM_YYYY ? JodaDateFormatType.FORMAT_WITH_DOT_DD_MM_YYYY.getDisplayName() : (dateFormatType == JodaDateFormatType.FORMAT_WITH_SLASH_MM_DD_YYYY ? JodaDateFormatType.FORMAT_WITH_SLASH_MM_DD_YYYY.getDisplayName() : JodaDateFormatType.FORMAT_WITH_MINUS_YYYY_MM_DD.getDisplayName());
        pattern = pattern.replaceAll("/", "\\\\\\\\/");
        return pattern;
    }

    @Override
    public void writeDataLine(Writer writer, List<Object> data) throws IOException {
        writer.write(String.format("%s%n", "<tr>"));
        for (Object object : data) {
            if (object == null) {
                writer.write(String.format("%s%n", "  <td></td>"));
                continue;
            }
            String field = object.toString();
            if (field.matches("0\\d+") || field.matches("((0\\d)|(1[012]))-.*") || field.matches("\\d{13,}") || field.matches("^=.*")) {
                writer.write("  <td class=\"text\">");
            } else if (field.matches("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d).*") || field.matches("(\\d\\d)\\.(\\d\\d)\\.(\\d\\d\\d\\d).*") || field.matches("(\\d\\d)/(\\d\\d)/(\\d\\d\\d\\d).*")) {
                writer.write("  <td class=\"datetime\">");
            } else if (field.matches("(\\d)*[\\.\\,].*")) {
                writer.write("  <td class=\"num\">");
            } else {
                writer.write("  <td>");
            }
            writer.write(StringEscapeUtils.escapeHtml4(field));
            writer.write(String.format("%s%n", "</td>"));
        }
        writer.write(String.format("%s%n", "</tr>"));
    }

    @Override
    public void writeFooter(Writer writer) throws IOException {
        writer.write(String.format("%s%n", "</table>"));
        writer.write(String.format("%s%n", "</body>"));
        writer.write(String.format("%s%n", "</html>"));
    }
}

