/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.IntegerColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import java.util.Collection;
import java.util.Collections;

public class OrderUsageFractionColumn
extends IntegerColumn<Order>
implements ImportColumn<Integer, Order> {
    public OrderUsageFractionColumn(String header) {
        super(header);
    }

    @Override
    public void applyValue(Integer value, Order importedObject) {
        importedObject.setUsageFraction(value);
    }

    @Override
    public Integer parseValue(String data) throws ImportException {
        return this.parseIntegerValue(data);
    }

    @Override
    public Integer getValue(Order objectToExport) {
        return objectToExport.getUsageFraction();
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Collections.singletonList(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_USAGE_FRACTION_RANGE.getMessageKey());
    }
}

