/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.mapper;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.Mapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MapperHandler.class);
    public static final String MOCKITO_INNER_CLASS_ID = "$MockitoMock$";
    private final Map<String, Mapper> class2Mapper = new ConcurrentHashMap<String, Mapper>();

    private static String getKey(Class<?> from, Class<?> to) {
        String name = from.getName();
        if (name.contains(MOCKITO_INNER_CLASS_ID)) {
            name = name.substring(0, name.indexOf(MOCKITO_INNER_CLASS_ID));
        }
        return name + to.getName();
    }

    public <F, T> void addHandler(AbstractMapper<T, F> handler) {
        if (BroadcastEntity.class.isAssignableFrom(handler.getTo())) {
            this.class2Mapper.put(MapperHandler.getKey(handler.getFrom(), BroadcastEntity.class), handler);
        }
        this.class2Mapper.put(MapperHandler.getKey(handler.getFrom(), handler.getTo()), handler);
    }

    public <E, I> E translate(Class<E> toClass, I from) {
        return this.translate(toClass, from, null);
    }

    public <E, I> E translate(Class<E> toClass, I from, Object hint) {
        Mapper mapper;
        if (from == null) {
            return null;
        }
        if (from instanceof BroadcastEntity) {
            BroadcastEntity broadcastEntity = (BroadcastEntity)from;
            mapper = this.class2Mapper.get(MapperHandler.getKey(broadcastEntity.getEntityClass(), toClass));
        } else {
            mapper = this.class2Mapper.get(MapperHandler.getKey(from.getClass(), toClass));
        }
        if (mapper != null) {
            return mapper.translate(from, this, hint);
        }
        LOG.warn("Returning null when translating class {} from {}", (Object)toClass, (Object)from.getClass());
        return null;
    }

    public <E, I> Set<E> translateSet(Class<E> toClass, Collection<I> fromCollection) {
        return this.translateSet(toClass, fromCollection, null);
    }

    public <E, I> Set<E> translateSet(Class<E> toClass, Collection<I> fromCollection, Object hint) {
        long startTime = System.currentTimeMillis();
        Set collect = this.translateStream(toClass, fromCollection.stream(), hint).collect(Collectors.toSet());
        this.logDuration(toClass, fromCollection, startTime);
        return collect;
    }

    public <E, I> List<E> translateList(Class<E> toClass, Collection<I> fromCollection) {
        return this.translateList(toClass, fromCollection, null);
    }

    public <E, I> List<E> translateList(Class<E> toClass, Collection<I> fromCollection, Object hint) {
        long startTime = System.currentTimeMillis();
        List<E> collect = this.translateStream(toClass, fromCollection.stream(), hint).toList();
        this.logDuration(toClass, fromCollection, startTime);
        return collect;
    }

    public <E, I> Stream<E> translateStream(Class<E> toClass, Stream<I> fromStream) {
        return this.translateStream(toClass, fromStream, null);
    }

    public <E, I> Stream<E> translateStream(Class<E> toClass, Stream<I> fromStream, Object hint) {
        return fromStream.map(i -> this.translate(toClass, i, hint)).filter(Objects::nonNull);
    }

    private <E, I> void logDuration(Class<E> toClass, Collection<I> fromCollection, long startTime) {
        if (LOG.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            LOG.debug("Translation of {} {} items took: {}ms", fromCollection.size(), toClass.getSimpleName(), duration);
        }
    }
}

