/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.protection;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.ProductQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryRule;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.SerializableOrderEntryRule;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class OrderEntryProtectionServiceImpl
implements OrderEntryProtectionService {
    private final SettingsService settingsService;
    private final ProductQueries productQueries;
    private final UserAlertService userAlertService;
    private static final SettingsService.Settings<List<SerializableOrderEntryRule>> ORDER_ENTRY_PROTECTION_RULE_LIST = new SettingsService.Settings("orderEntryProtectionRuleList", new ArrayList());

    @Inject
    public OrderEntryProtectionServiceImpl(SettingsService settingsService, ApplicationContext applicationContext, UserAlertService userAlertService) {
        this.settingsService = settingsService;
        this.userAlertService = userAlertService;
        this.productQueries = applicationContext.getService(ProductQueries.class);
    }

    @Override
    public boolean checkOrders(List<Order> orders) {
        StringBuilder errorCollector = new StringBuilder();
        orders.forEach(order -> this.checkOrder((Order)order, errorCollector));
        String error = errorCollector.toString();
        return error.isEmpty() || this.userAlertService.showQuestionDialog(Util.getLabel("orderEntryProtectionService_orderEntryConfirmation_question_header"), Util.getLabel("orderEntryProtectionService_orderEntryConfirmation_question"), error, true, UserAlertService.Flag.HIGH_VISIBILITY);
    }

    private void checkOrder(Order order, StringBuilder errorCollector) {
        boolean orderAppended = false;
        List<OrderEntryRule> validOrderEntryRules = this.getOrderEntryRules(order);
        for (OrderEntryRule orderEntryRule : validOrderEntryRules) {
            if (orderEntryRule.getUpperPrice() != null && orderEntryRule.getUpperPrice().compareTo(order.getLimitPrice()) < 0) {
                orderAppended = this.appendOrderIfNotAlready(order, errorCollector, orderAppended);
                errorCollector.append(Util.getLabel("orderEntryProtectionService_orderEntryConfirmation_exceeded_upperPrice_limit", orderEntryRule.getUpperPrice().toString(), order.getContract().getProduct().getCurrencyCode()));
            }
            if (orderEntryRule.getLowerPrice() != null && orderEntryRule.getLowerPrice().compareTo(order.getLimitPrice()) > 0) {
                orderAppended = this.appendOrderIfNotAlready(order, errorCollector, orderAppended);
                errorCollector.append(Util.getLabel("orderEntryProtectionService_orderEntryConfirmation_exceeded_lowerPrice_limit", orderEntryRule.getLowerPrice().toString(), order.getContract().getProduct().getCurrencyCode()));
            }
            if (orderEntryRule.getQuantity() != null && orderEntryRule.getQuantity().compareTo(order.getRemainingQuantity()) < 0) {
                orderAppended = this.appendOrderIfNotAlready(order, errorCollector, orderAppended);
                errorCollector.append(Util.getLabel("orderEntryProtectionService_orderEntryConfirmation_exceeded_quantity_limit", orderEntryRule.getQuantity().toString(), order.getContract().getProduct().getQuantityUnit()));
            }
            BigDecimal orderAmount = order.getLimitPrice().getDisplayValue().multiply(order.getRemainingQuantity().getDisplayValue()).multiply(BigDecimal.valueOf(order.getContract().getDeliveryUnits())).abs();
            if (orderEntryRule.getAmount() == null || orderEntryRule.getAmount().getDisplayValue().compareTo(orderAmount) >= 0) continue;
            orderAppended = this.appendOrderIfNotAlready(order, errorCollector, orderAppended);
            errorCollector.append(Util.getLabel("orderEntryProtectionService_orderEntryConfirmation_exceeded_amount_limit", orderAmount.toString(), orderEntryRule.getAmount().toString(), order.getContract().getProduct().getCurrencyCode()));
        }
    }

    private boolean appendOrderIfNotAlready(Order order, StringBuilder errorCollector, boolean orderAppended) {
        if (!orderAppended) {
            this.appendOrder(order, errorCollector);
            return true;
        }
        return orderAppended;
    }

    private void appendOrder(Order order, StringBuilder errorCollector) {
        errorCollector.append(Util.getLabel("orderEntryProtectionService_orderEntryConfirmation_question_orderFormat", order.getDirection().getDescription(), order.getContract().getName(), order.getRemainingQuantity().toString(), order.getContract().getProduct().getQuantityUnit(), order.getLimitPrice().toString(), order.getContract().getProduct().getCurrencyCode(), order.getDeliveryArea().getDisplayName())).append("\n");
    }

    protected List<OrderEntryRule> getOrderEntryRules(Order order) {
        ArrayList<OrderEntryRule> validOrderEntryRules = new ArrayList<OrderEntryRule>();
        for (OrderEntryRule orderEntryRule : this.getOrderEntryRules()) {
            String ruleProductName = orderEntryRule.getProductName();
            boolean matchesDirection = orderEntryRule.getDirection().matchesDirection(order.getDirection());
            Product orderProduct = order.getProduct();
            if (ruleProductName.endsWith("*")) {
                String namePrefix = ruleProductName.substring(0, ruleProductName.lastIndexOf("*"));
                if (!this.productQueries.findProductsByNameStart(namePrefix).getAll().anyMatch(orderProduct::equals) || !matchesDirection) continue;
                validOrderEntryRules.add(orderEntryRule);
                continue;
            }
            if (!this.productQueries.findProductsByName(ruleProductName).getAll().anyMatch(orderProduct::equals) || !matchesDirection) continue;
            validOrderEntryRules.add(orderEntryRule);
        }
        return validOrderEntryRules;
    }

    @Override
    public void storeOrderEntryRule(List<OrderEntryRule> orderEntryRules) {
        this.settingsService.storeSettings(ORDER_ENTRY_PROTECTION_RULE_LIST, orderEntryRules.stream().map(SerializableOrderEntryRule::new).toList());
    }

    @Override
    public List<OrderEntryRule> getOrderEntryRules() {
        return this.settingsService.loadSettings(ORDER_ENTRY_PROTECTION_RULE_LIST).stream().map(OrderEntryRule::new).toList();
    }
}

