/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileContentWithFormatVersion;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigration;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigrationService;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1000001DelOwnMarketSpread
implements ProfileMigration {
    private static final Logger LOG = LoggerFactory.getLogger(V1000001DelOwnMarketSpread.class);
    private static final long NEW_VERSION = 1000001L;

    @Inject
    public V1000001DelOwnMarketSpread(ProfileMigrationService profileMigrationService) {
        profileMigrationService.registerProfileMigration(this, 1000001L);
    }

    @Override
    public ProfileContentWithFormatVersion apply(ProfileContentWithFormatVersion profile) {
        LOG.info("Running profile migration");
        profile.setFormatVersion(1000001L);
        for (Map.Entry<String, String> entry : profile.getComponentData().entrySet()) {
            String value = entry.getValue();
            if (!StringUtils.isNotEmpty(value)) continue;
            entry.setValue(this.delete(value));
        }
        return profile;
    }

    private String delete(String value) {
        return value.replaceAll("OwnMarketPanelState><spread>.*?spread>", "OwnMarketPanelState>");
    }
}

