/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileContentWithFormatVersion;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigration;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigrationService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileSerializer;
import com.google.inject.Inject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1000003SelectedThemePath
implements ProfileMigration {
    private static final String SELECTED_THEME_PATH = "selectedThemePath";
    private static final Logger LOG = LoggerFactory.getLogger(V1000003SelectedThemePath.class);
    private static final long NEW_VERSION = 1000003L;
    private final ProfileSerializer profileSerializer;

    @Inject
    public V1000003SelectedThemePath(ProfileMigrationService profileMigrationService, ProfileSerializer profileSerializer) {
        profileMigrationService.registerProfileMigration(this, 1000003L);
        this.profileSerializer = profileSerializer;
    }

    @Override
    public ProfileContentWithFormatVersion apply(ProfileContentWithFormatVersion profile) {
        LOG.info("Running profile migration");
        profile.setFormatVersion(1000003L);
        for (Map.Entry<String, String> entry : profile.getSettings().entrySet()) {
            String value;
            if (!SELECTED_THEME_PATH.equals(entry.getKey()) || entry.getValue() == null || !(value = this.deserializeValue(entry.getValue())).endsWith(".css") || value.charAt(0) == '/') continue;
            entry.setValue(this.serializeValue("/" + value));
        }
        return profile;
    }

    private String serializeValue(String value) {
        return this.profileSerializer.writeValue(value);
    }

    private String deserializeValue(String serializedValue) {
        return (String)this.profileSerializer.readValue(serializedValue);
    }
}

