/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.user;

import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.OwnUserLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

@Singleton
public class UserServiceImpl
implements UserService {
    private final ObjectProperty<User> currentUser = new SimpleObjectProperty<User>();
    private final ObjectProperty<User> ownUser = new SimpleObjectProperty<User>();

    @Inject
    public UserServiceImpl(OnBehalfService onBehalfService, EventBus eventBus) {
        ReadOnlyObjectProperty<User> onBehalfUser = onBehalfService.onBehalfUserProperty();
        this.currentUser.bind(Bindings.when(onBehalfUser.isNotNull()).then(onBehalfUser).otherwise((ReadOnlyObjectProperty<User>)this.ownUser));
        eventBus.register(this);
    }

    @Subscribe
    public void handleOwnUserLoadedEvent(OwnUserLoadedEvent event) {
        this.ownUser.set(event.getOwnUser());
    }

    @Subscribe
    public void handleLogoutEvent(LogoutEvent event) {
        this.ownUser.setValue(null);
    }

    @Override
    public User getOwnUser() {
        return (User)this.ownUser.get();
    }

    @Override
    public User getCurrentUser() {
        return (User)this.currentUser.get();
    }

    @Override
    public ReadOnlyObjectProperty<User> currentUserProperty() {
        return this.currentUser;
    }

    @Override
    public UserRoles getOwnUserRoles() {
        return this.getUserRoles(this.getOwnUser());
    }

    @Override
    public UserRoles getCurrentUserRoles() {
        return this.getUserRoles(this.getCurrentUser());
    }

    private UserRoles getUserRoles(User user) {
        return Optional.ofNullable(user).map(User::getRoles).orElse(new UserRoles.SimpleRoleSet());
    }
}

