/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api;

import java.util.Optional;

public enum ErrorCodeAndKey {
    INVALID_QUANTITY_SHOULD_BE_IN_INTERVAL(1000, "invalid_quantity_should_be_in_interval"),
    INVALID_PRICE_SHOULD_BE_IN_INTERVAL(1001, "invalid_price_should_be_in_interval"),
    ILLEGAL_ORDER_TYPE(1002, "illegal_order_type"),
    INVALID_OPTION_PRICE(1003, "option_price_out_of_valid_range"),
    INVALID_HIDDEN_QUANTITY_SHOULD_BE_IN_INTERVAL(1005, "invalid_hidden_quantity_should_be_in_interval"),
    LIFT_ORDER_EXECUTION_RESTRICTION_MUST_BE_FOK_OR_IOC(1007, "lift_order_execution_restriction_must_be_fok_or_ioc"),
    TSO_IN_HALT_ADD_ORDER(1008, "tso_in_halt_add_order"),
    TSO_IN_HALT_MODIFY_ORDER(1009, "tso_in_halt_modify_order"),
    TSO_IN_HALT_ACTIVATE_ORDER(1010, "tso_in_halt_activate_order"),
    NO_TRADER_SELECTED_FOR_ON_BEHALF_ORDER(1011, "no_trader_selected_for_on_behalf_order"),
    NOT_ENOUGH_PRIVILEGES_FOR_SELECTED_ORDER_TYPE(1012, "not_enough_privileges_to_use_selected_order_type"),
    LINKED_ORDERS_DISABLED(1013, "linked_orders_disabled"),
    LINKED_ORDERS_MUST_BELONG_TO_SAME_EXCHANGE(1014, "linked_orders_must_belong_to_same_exchange"),
    LINKED_ORDERS_NOT_SUPPORTED_FOR_PRODUCT(1015, "linked_orders_not_supported_for_product"),
    LINKED_ORDERS_MUST_HAVE_FILL_OR_KILL_RESTRICTION(1016, "linked_orders_must_have_fill_or_kill_restriction"),
    ORDER_TEXT_LENGTH_EXCEEDED(1017, "order_text_length_exceeds_250_characters"),
    TARGET_BALANCING_GROUP_NOT_SET(1018, "target_balancing_group_must_be_set"),
    PEAK_QUANTITY_ONLY_FOR_ICB(1019, "peak_quantity_supported_only_for_iceberg_orders"),
    PEAK_PRICE_DELTA_ONLY_FOR_ICB(1020, "peak_delta_supported_only_for_iceberg_orders"),
    PEAK_QUANTITY_MUST_BE_POSITIVE(1021, "peak_quantity_must_be_positive"),
    INVALID_PEAK_QUANTITY_SHOULD_BE_IN_INTERVAL(1022, "invalid_peak_quantity_should_be_in_interval"),
    ICB_BUY_POSITIVE_PPD(1023, "buy_iceberg_order_cannot_have_ppd_greater_than_0"),
    ICB_SELL_NEGATIVE_PPD(1024, "sell_iceberg_orders_cannot_have_ppd_smaller_than_0"),
    FUTURE_PRICE_SMALLER_THAN_PRODUCT_MIN_PRICE(1025, "future_price_of_iceberg_is_smaller_than_minimal_product_price"),
    FUTURE_PRICE_GREATER_THAN_PRODUCT_MAX_PRICE(1026, "future_price_of_iceberg_is_greater_than_max_product_price"),
    ICB_OTC_DONT_ALLOW_EXECUTION_RESTRICTION(1027, "iceberg_otc_orders_do_not_allow_execution_restrictions"),
    ICB_VIOLATES_PEAK_PRICE_DELTA_RANGE(1028, "iceberg_order_violates_peak_price_delta_range"),
    EXECUTION_RESTRICTION_AON_NOT_ALLOWED_FOR_SELECTED_INSTRUMENT(1029, "execution_restriction_AON_is_not_allowed_for_selected_instrument"),
    ICEBERG_ORDERS_NOT_AVAILABLE(1030, "iceberg_orders_are_not_available"),
    EXISTING_QUOTE_ORDER(1031, "existing_quote_order"),
    TARGET_BALANCING_GROUP_CANNOT_BE_ADMIN(1032, "target_balancing_group_cannot_be_admin_balancing_group"),
    TARGET_BALANCING_GROUP_CANNOT_TRADE_PRODUCT(1033, "target_balancing_group_is_not_allowed_to_trade_product"),
    OTC_TRADES_NOT_FOR_CONTRACTS_IN_BALANCE_PHASE(1034, "otc_trades_are_not_supported_for_contracts_in_balance_phase"),
    TARGET_BALANCING_GROUP_NOT_OTC_ENABLED(1035, "target_balancing_group_is_not_otc_enabled"),
    OTC_NOT_SUPPORTED_BY_PRODUCT(1036, "otc_trades_are_not_supported_by_product"),
    BALANCING_GROUP_NOT_OTC_ENABLED(1037, "balancing_group_is_not_otc_enabled"),
    BLOCK_ORDERS_NOT_SUPPORTED_FOR_PRODUCT(1038, "block_orders_are_not_supported_for_product"),
    BALANCE_ORDERS_NOT_SUPPORTED_FOR_PRODUCT(1039, "balance_orders_are_not_supported_for_product"),
    ICEBERG_ORDERS_NOT_SUPPORTED_FOR_PRODUCT(1040, "iceberg_orders_are_not_supported_for_product"),
    STOP_ORDERS_NOT_SUPPORTED_FOR_PRODUCT(1041, "stop_orders_are_not_supported_for_product"),
    RESTRICTION_IS_NOT_ALLOWED_FOR_BLOCK_ORDERS(1042, "restriction_is_not_allowed_for_block_orders"),
    RESTRICTION_IS_NOT_ALLOWED_FOR_STOP_ORDERS(1043, "restriction_is_not_allowed_for_stop_orders"),
    RESTRICTION_IS_NOT_ALLOWED_FOR_QUOTE_ORDERS(1044, "restriction_is_not_allowed_for_quote_orders"),
    ICB_HIDDEN_QUANTITY_MUST_BE_POSITIVE(1045, "hidden_quantity_must_be_positive"),
    ICB_PEAK_QUANTITY_GREATER_THAN_TOTAL_QUANTITY(1046, "peak_quantity_is_larger_than_total_quantity"),
    BLOCK_ORDERS_RESTRICTION_CHANGE_NOT_POSSIBLE(1047, "not_allowed_to_change_restriction_for_block_orders"),
    CANNOT_MODIFY_ORDER_IN_CONTRACT_PHASE(1048, "cannot_modify_order_in_contract_state"),
    CONCURRENT_ORDER_ACCESS(1049, "concurrent_order_access"),
    CANNOT_ENTER_AON_FOR_CANONICAL_CONTRACT(1050, "cannot_enter_aon_for_canonical_contract"),
    CANNOT_ENTER_OPEN_ORDER_FOR_USER_DEFINED_BLOCKS(1051, "cannot_enter_open_for_user_defined_blocks"),
    CANNOT_ENTER_IOC_AND_FOK_ORDERS_IN_AUCTION(1052, "cannot_enter_ioc_and_fok_orders_in_auction"),
    BALANCE_BLOCK_ORDERS_ONLY_WITH_IOC_RESTRICTION(1053, "balance_block_supported_only_ioc_restriction"),
    MARKET_SWEEP_ORDER_NOT_ALLOWED_IN_BALANCING_PHASE(1054, "market_sweep_orders_not_allowed_during_balancing_phase"),
    BLOCK_ORDER_FOR_LOCAL_PRODUCT_CAN_NOT_SPAN_MIDNIGHT(1055, "block_order_for_local_product_can_not_span_midnight"),
    BLOCK_ORDER_FOR_REMOTE_PRODUCT_DELIVERY_UNITS_THRESHOLD_BROKEN(1153, "block_order_for_remote_product_delivery_units_threshold_broken"),
    STOP_PRICE_UNDER_CURRENT_PRICE(1056, "invalid_stop_price_under_current_price"),
    STOP_PRICE_ABOVE_CURRENT_PRICE(1057, "invalid_stop_price_above_current_price"),
    STOP_PRICE_ONLY_FOR_STOP_ORDERS(1058, "stop_price_only_for_stop_orders"),
    MISSING_VALIDITY_RESTRICTION(1059, "missing_validity_restriction"),
    MISSING_EXPIRATION_TIME(1060, "missing_expiration_time"),
    MISSING_CONTRACT(1061, "missing_contract"),
    MISSING_TRADER(1062, "missing_trader"),
    MISSING_PRICE(1063, "missing_price"),
    MISSING_STOP_PRICE(1064, "missing_stop_price"),
    MISSING_TYPE_CODE(1065, "missing_type_code"),
    MISSING_RESTRICTION(1066, "missing_restriction"),
    MISSING_BUY_CODE(1067, "missing_buy_code"),
    MISSING_ACCOUNT(1068, "missing_account"),
    MISSING_BALANCING_GROUP(1069, "missing_balancing_group"),
    VALDATE_CANNOT_BE_IN_PAST(1070, "valdate_cannot_be_in_the_past"),
    VALDATE_CANNOT_BE_AFTER_CONTRACT_EXPIRATION(1071, "valdate_cannot_be_after_contract_expiration"),
    VALDATE_CANNOT_BE_AFTER_CONTRACT_END_DELIVERY(1072, "valdate_cannot_be_after_contract_end_of_delivery"),
    VALDATE_CANNOT_BE_AFTER_BALANCING_PHASE_END(1073, "valdate_cannot_be_later_than_balancing_phase_end"),
    VALDATE_CANNOT_BE_AFTER_TRADING_END(1074, "valdate_cannot_be_later_than_trading_end"),
    ORDER_VALIDITY_TIME_MUST_BE_MULTIPLE_OF_5_MINUTES(1075, "order_validity_time_must_be_multiple_of_5_minutes"),
    VALIDITY_RESTRICTION_NOT_ALLOWED_FOR_IOC_AND_FOK(1076, "validity_restriction_not_allowed_for_orders_for_immediate_execution"),
    CROSS_BORDER_OTC_NOT_AVAILABLE(1077, "cross_border_otc_not_available"),
    CROSS_BORDER_FOR_PRODUCT_NOT_SUPPORTED(1078, "cross_border_with_product_not_supported"),
    NO_CAPACITY_AVAILABLE_FOR_OTC(1079, "no_capacity_available_to_accept_cross_border_otc"),
    INTRAMARKET_ONLY_OTC_SUPPORTED(1080, "otc_trades_can_be_done_only_within_the_same_market"),
    TARGET_BALANCING_GROUP_CAN_ACCEPT_OTC(1081, "cannot_execute_only_target_bg_can_accept"),
    TARGET_BALANCING_GROUP_CAN_REJECT_OTC(1082, "cannot_execute_only_target_bg_can_reject"),
    CANNOT_ACCEPT_INACTIVE_OTC_TRADE(1083, "cannot_accept_incactive_otc_trade"),
    MODIFICATION_TYPE_NOT_SUPPORTED(1084, "modification_type_not_supported"),
    ORDER_NOT_ACTIVE(1085, "order_not_active"),
    ORDER_IS_OTC(1086, "order_is_otc"),
    CANT_ACCEPT_OTC_TSO_IN_HALT(1087, "cant_accept_otc_tso_in_halt"),
    MODIFICATION_TYPE_MISSING(1088, "modification_type_missing"),
    ORDER_SHOULD_BE_ACTIVE_OR_HIBERNATED_CURRENT_STATE_IS(1089, "order_should_be_active_or_hibernated_current_state_is"),
    CANT_ACCEPT_OTC_PRICE_LOWER_THAN_TSO_MIN_PRICE(1090, "cant_accept_otc_price_lower_than_tso_min_price"),
    CANT_ACCEPT_OTC_PRICE_HIGHER_THAN_TSO_MAX_PRICE(1091, "cant_accept_otc_price_higher_than_tso_max_price"),
    OTC_NOT_POSSIBLE_NO_USER_WITH_TRADING_ROLE(1092, "otc_not_possible_no_user_with_trading_role"),
    ORDER_IS_NOT_ICEBERG(1093, "order_is_not_iceberg"),
    ICEBERG_IS_NOT_DEPLETED(1094, "iceberg_is_not_depleted"),
    DEPLETED_ICEBERG_HAS_NO_HIDDEN_QUANTITY(1095, "depleted_iceberg_has_no_hidden_quantity"),
    CURRENT_LOGGED_USER_DOES_NOT_MATCH_PASSED_TRADER_ID(1096, "current_logged_user_does_not_match_passed_trader_id"),
    CAPACITY_EXCEED(1097, "capacity_exceed"),
    NOT_ENOUGH_CAPACITY_FOR_AON(1098, "not_enough_capacity_for_aon"),
    CAPACITY_RESERVATION_FAILED(1099, "capacity_reservation_failed"),
    PNC_ORDERS_NOT_SUPPORTED_FOR_PRODUCT(1107, "pnc_orders_not_supported_for_product"),
    LIFT_ORDER_VALIDITY_RESTRICTION_MUST_BE_NONE(1108, "lift_order_validity_restriction_must_be_none"),
    LIFT_ORDERS_NOT_SUPPORTED_FOR_PRODUCT(1109, "lift_orders_are_not_supported_for_product"),
    RESTRICTION_IS_NOT_ALLOWED_FOR_LIFT_PRODUCT(1110, "restriction_is_not_allowed_for_lift_product"),
    ORDER_TYPE_IS_NOT_ALLOWED_FOR_LIFT_PRODUCT(1111, "order_type_is_not_allowed_for_lift_product"),
    BESPOKE_CONTRACT_SUPPORTS_ONLY_PNC_ORDERS(1112, "bespoke_contract_supports_only_pnc_orders"),
    QUOTE_DIFFERENT_PRODUCT(1113, "quote_different_product"),
    QUOTE_DUPLICATE_CONTRACT(1114, "quote_duplicate_contract"),
    QUOTE_INVALID_PRICE(1115, "quote_invalid_price"),
    QUOTE_NOT_ALLOWED_FOR_PRODUCT(1116, "quote_not_allowed_for_product"),
    CONTRACT_MUST_BELONG_TO_PRODUCT(1117, "contract_must_belong_to_product"),
    ORDER_TYPE_NOT_SUPPORTED_FOR_OTC_ONLY_PRODUCT(1118, "order_type_not_supported_for_otc_only_product"),
    AON_PRODUCT_RESTRICTION_SUPPORTS_ONLY_AON_FOK_ORDERS(1119, "aon_product_restriction_supports_only_aon_fok_orders"),
    ICEBERG_IS_NOT_ALLOWED_FOR_AON_PRODUCT(1120, "iceberg_is_not_allowed_for_aon_product"),
    BALANCING_GROUP_SUSPENDED_ORDERS_HIBERNATE_ALL(1121, "balancing_group_suspended_orders_hibernate_all"),
    BALANCING_GROUP_SUSPENDED_ORDERS_EDIT(1122, "balancing_group_suspended_orders_edit"),
    BALANCING_GROUP_SUSPENDED_ORDERS_ACTIVATE(1123, "balancing_group_suspended_orders_activate"),
    BALANCING_GROUP_SUSPENDED_ORDERS_DELETE(1124, "balancing_group_suspended_orders_delete"),
    INVALID_PRICE_MODULO_TICK_SIZE(1125, "invalid_price_modulo_tick_size"),
    INVALID_QUANTITY_MODULO_LOT_SIZE(1126, "invalid_quantity_modulo_lot_size"),
    OPEN_CLOSE_INDICATOR_REQUIRED_BY_PRODUCT(1127, "open_close_indicator_required_by_product"),
    OPEN_CLOSE_INDICATOR_ALLOWED_ONLY_FOR_FUTURE_AND_CROSS_PRODUCTS(1128, "open_close_indicator_allowed_only_for_future_and_cross_products"),
    INDICATIVE_ORDER_MUST_HAVE_QUANTITY(1129, "indicative_order_must_have_quantity"),
    INDICATIVE_ORDER_EXECUTION_RESTRICTION_MUST_BE_NON(1130, "indicative_order_execution_restriction_must_be_non"),
    INDICATIVE_ORDERS_NOT_SUPPORTED_FOR_PRODUCT(1131, "indicative_orders_not_supported_for_product"),
    OPT_ORDERS_NOT_SUPPORTED_FOR_PRODUCT(1132, "opt_orders_not_supported_for_product"),
    DELIVERY_AREA_NOT_ASSIGNED_TO_USER(1133, "delivery_area_not_assigned_to_user"),
    DELIVERY_AREA_ALREADY_IN_HALT(1134, "delivery_area_already_in_halt_error"),
    UNSUPPORTED_ORDER_ACTIVATION(1135, "unsupported_order_activation"),
    RECALL_RESOLUTION_IMPOSSIBLE_IF_RECALL_NOT_REQUESTED(1136, "recall_resolution_impossible_if_recall_not_requested"),
    NO_ORDERS_SUBMITTED(1137, "no_orders_submitted"),
    ORDER_LIST_MUST_HAVE_MORE_THAN_ONE_ELEMENT(1138, "order_list_must_have_more_than_one_element"),
    DELIVERY_AREA_CANNOT_BE_ACTIVATED_BECAUSE_IN_CMM_IS_SUSPENDED(1141, "delivery_area_cannot_be_activated_because_in_cmm_is_suspended"),
    ORDER_TIME_OUT(1142, "order_not_processed_due_to_timeout"),
    LIST_EXECUTION_RESTRICTION_IS_INVALID(1143, "list_execution_restriction_is_invalid"),
    INCLPREARRANGED_CAN_ONLY_BE_FALSE_FOR_XBID(1144, "inclprearranged_can_only_be_false_for_xbid"),
    ORDER_IS_ALREADY_IN_ACTIVE_STATUS(1145, "order_is_already_in_active_status"),
    INVALID_HIDDEN_QUANTITY_MUST_REFLECT_LOT_SIZE(1146, "invalid_hidden_order_quantity_must_reflect_lot_size"),
    INVALID_PEAK_SIZE_QUANTITY_MUST_REFLECT_LOT_SIZE(1147, "invalid_peak_size_order_quantity_must_reflect_lot_size"),
    DELIVERY_AREA_ALLOWED_ONLY_FOR_DEAC_OR_DELE_MODTYPE(1148, "delivery_area_allowed_only_for_deac_or_dele_modtype"),
    ORDER_REJECTED_SELF_TRADE_PROTECTION(1149, "order_rejected_self_trade_protection"),
    CANNOT_MIX_QUOTES_WITH_OTHER_ORDER_TYPES(1150, "cannot_mix_quotes_with_other_order_types"),
    CANNOT_MIX_INDICATIVE_QUOTES_WITH_OTHER_ORDER_TYPES(1151, "cannot_mix_indicative_quotes_with_other_order_types"),
    UNSUPPORTED_CLEARING_ACCOUNT_TYPE(1152, "unsupported_clearing_account_type"),
    INVALID_EXECUTION_RESTRICTION(1154, "invalid_execution_restrictions"),
    ORDER_ALREADY_DELETED(1155, "order_already_deleted"),
    OPEN_CLOSE_INDICATOR_NOT_ENABLED(1156, "open_close_indicator_not_enabled"),
    AOT_IS_DISABLED_ON_PRODUCT_CANNOT_BE_ENABLED_ON_ORDER(1157, "aot_is_disabled_on_product_cannot_be_enabled_on_order"),
    AOT_IS_NOT_SUPPORTED_ON_PRODUCT_CANNOT_BE_ENABLED_ON_ORDER(1158, "aot_is_not_supported_on_product_cannot_be_enabled_on_order"),
    ORDER_ACTIVATION_REJECTED_FOR_MODIFICATION_TYPE_SNAV(1159, "order_activation_rejected_for_modification_type_snav"),
    ORDER_OPERATION_REJECTED_BECAUSE_ORDER_STATE_IS_UNKNOWN(1160, "order_operation_rejected_because_order_state_is_unknown"),
    AOT_NOT_ALLOWED_FOR_ORDER_FOR_IMMEDIATE_EXECUTION(1161, "aot_not_allowed_for_orders_for_immediate_execution"),
    LIST_EXECUTION_RESTRICTION_VALID_FOR_LOCAL_AND_REMOTE_PRODUCT(1162, "list_execution_restriction_valid_for_local_and_remote_product"),
    INVALID_REMOTE_ORDER_TYPE(1163, "invalid_remote_order_type"),
    MISSING_ORDER_DLVRY_START_OR_DLVRY_END_WHEN_NO_CONTRACT_SPECIFIED(1164, "missing_order_dlvry_start_or_dlvry_end_when_no_contract_specified"),
    ACCESS_DENIED(100, "access_denied"),
    APPLICATION_NOT_FOUND(101, "application_not_found"),
    VALIDATION_ERROR(102, "validation_error"),
    NO_MODIFICATION(103, "no_modification"),
    ERROR_IO_JOURNAL(104, "error_io_journal"),
    MESSAGE_TO_LARGE(105, "message_to_large"),
    CAN_NOT_BE_EMPTY(106, "can_not_be_empty"),
    UNKNOWN_VALIDATION_ERROR(107, "unknown_validation_error"),
    VALUE_TOO_LONG(108, "value_is_too_long"),
    ACCESS_TO_MEMBER_DENIED(110, "access_to_member_denied"),
    ACCESS_DENIED_BAD_DISCONNECT_ACTION(111, "access_denied_bad_disconnect_action"),
    TRADER_ALREADY_LOGGED_IN_EXCEPTION(8000, "trader_already_logged_in"),
    REQUEST_EXPIRED(9000, "request_expired"),
    TSO_IN_HALT(13000, "tso_in_halt"),
    UNKNOWN_SYSTEM_ERROR(14000, "unknown_system_error"),
    DATA_ACCESS_EXCEPTION(14001, "data_access_exception"),
    TOO_MANY_REQUESTS_EXCEPTION(14002, "too_many_requests_excpetion"),
    SYNTACTIC_ERROR(14003, "syntactic_error"),
    ON_BEHALF_ACTIONS_NOT_ALLOWED(2000, "on_behalf_actions_not_allowed"),
    PUBLIC_API_AVAIL_ONLY_FOR_USER_AND_TRADE_BROADCAST(2001, "public_api_available_only_for_role_user_or_role_trade_broadcast"),
    FOR_PUBLIC_API_AMQP_USE_ATTEMPT_AMQP_SINGLE_LOGIN_AUTHENTICATION(2002, "for_public_api_amqp_use_attempt_amqp_single_login_authentication"),
    INVALID_USER_ID(2003, "invalid_user_id"),
    MARKET_AREA_NOT_FOUND(2004, "market_area_not_found"),
    TRADE_DOES_NOT_EXIST(2005, "trade_does_not_exist"),
    TRADER_NOT_FOUND(2006, "trader_not_found"),
    DELIVERY_AREA_NOT_FOUND(2008, "delivery_area_not_found"),
    EXCHANGE_NOT_FOUND(2010, "exchange_not_found"),
    TRADE_IS_CONCURRENTLY_UPDATED(2011, "trade_is_concurrently_updated_by_another_user"),
    TRADE_DELIVERY_TOO_CLOSE(2012, "trade_delivery_too_close"),
    TRADE_EXECUTION_TOO_LONG_AGO(2013, "trade_execution_too_long_ago"),
    ORDER_NOT_FOUND(2014, "order_not_found"),
    UNKNOWN_BALANCING_GROUP(2015, "unknown_balancing_group"),
    UNKNOWN_TARGET_BALANCING_GROUP(2016, "unknown_target_balancing_group"),
    UNKNOWN_CONTRACT(2018, "unknown_contract"),
    CLEARING_HOUSES_DISABLED(2019, "clearing_houses_disabled"),
    SERVICE_IN_HALT(2020, "service_in_halt"),
    PRODUCT_NOT_FOUND(2021, "product_not_found"),
    CONTRACT_NOT_FOUND(2022, "contract_not_found"),
    PRODUCT_IN_HALT(2023, "product_in_halt"),
    MEMBER_NOT_FOUND(2024, "member_not_found"),
    BALANCING_GROUP_NOT_FOUND(2025, "balancing_group_not_found"),
    BALANCING_GROUP_SUSPENDED(2026, "balancing_group_suspended"),
    MEMBER_IS_SUSPENDED(2027, "member_is_suspended"),
    NO_ORDERBOOK_FOUND_FOR_CONTRACT_AND_TSO(2029, "no_orderbook_found_for_contract_and_tso"),
    COULD_NOT_RETRIEVE_AUTHENTICATION_FROM_SECURITY_CONTEXT(2030, "could_not_retrieve_authentication_from_security_context"),
    MISSING_PROPERTY(2031, "missing_property"),
    OPERATION_PROHIBITED_FOR_SLAVE_INSTANCE(2032, "operation_prohibited_for_slave_instance"),
    SOB_DISCONNECTED(2033, "sob_disconnected"),
    CAPACITY_DISCONNECTED(2034, "capacity_disconnected"),
    TRADING_SCHEDULE_NOT_FOUND(2035, "trading_schedule_not_found"),
    BLOCK_CONTRACT_DELIVERY_HAS_TO_MATCH_BASE_DELIVERY(2037, "block_contract_delivery_has_to_match_base_delivery"),
    MEMBER_IS_NO_BROKER_NOR_REGULAR(2038, "member_is_no_broker_nor_regular"),
    X_NOTPROCESSED_DUE_NOTCHANGES(2039, "x_notprocessed_due_notchanges"),
    MEMBER_IS_DELETED(2040, "member_is_deleted"),
    EITHER_MEMBER_ACCOUNT_TRADER_ID_MAY_BE_SUPPLIED(2041, "either_member_account_trader_id_may_be_supplied"),
    CASH_LIMIT_ID_NOT_FOUND(2042, "cash_limit_id_not_found"),
    CASH_LIMIT_ID_AND_REV_NOT_FOUND(2043, "cash_limit_id_and_rev_not_found"),
    CASH_LIMIT_START_DATE_IN_PAST(2044, "cash_limit_start_date_in_past"),
    CASH_LIMIT_VALUE_NOT_SET(2045, "cash_limit_value_not_set"),
    CASH_LIMIT_ATTRIBUTE_NOT_SET(2046, "cash_limit_attribute_not_set"),
    CASH_LIMIT_MIN_VALUE(2047, "cash_limit_min_value"),
    DELIVERY_AREA_ALREADY_IN_TRADING(2048, "delivery_area_already_in_trading_error"),
    CONTRACT_CANNOT_BE_ACTIVATED_TSO_IN_HALT(2049, "contract_cannot_be_activated_tso_in_halt"),
    CONTRACT_CANNOT_BE_ACTIVATED_LEGS_NOT_ACTIVE(2050, "contract_cannot_be_activated_legs_not_active"),
    CONTRACT_INVALID_NUMBER_OF_CONTRACT_PHASES(2051, "contract_invalid_number_of_contract_phases"),
    CONTRACT_PHASE_END_TIME_BLANK(2052, "contract_phase_end_time_blank"),
    CONTRACT_TRADING_PERIOD_START_TIME_AFTER_END_TIME(2053, "contract_trading_period_start_time_after_end_time"),
    CONTRACT_LAST_PHASE_END_TIME_NOT_BLANK(2054, "contract_last_phase_end_time_not_blank"),
    CONTRACT_ALL_PHASES_END_IN_PAST(2055, "contract_all_phases_end_in_past"),
    CONTRACT_INVALID_ORDER_OF_CONTRACT_PHASES(2056, "contract_invalid_order_of_contract_phases"),
    CONTRACT_CANNOT_CHANGE_END_TIME_CONTRACT_IS_ACTIVE(2057, "contract_cannot_change_end_time_contract_is_active"),
    CONTRACT_PHASE_END_IN_PAST(2058, "contract_phase_end_in_past"),
    CONTRACT_REFERENCE_PRICE_ILLEGAL_DATE(2059, "contract_reference_price_date"),
    CONTRACT_REFERENCE_PRICE_ILLEGAL_EXCHANGE(2060, "contract_reference_price_exchange"),
    DECIMAL_SHIFT_WRONG_VALUE(2061, "decimal_shift_wrong_value"),
    SOB_ALREADY_CONNECTED(2062, "sob_already_connected"),
    SOB_DATA_SYNCHRONIZATION_IN_PROGRESS(2063, "sob_data_synchronization_in_progress"),
    SOB_DATA_ALREADY_SYNCHRONIZED(2064, "sob_data_already_synchronized"),
    CONTRACT_DATE_VALIDITY(2065, "contract_date_must_be_mulitply_by"),
    CONTRACT_TSO_STATE_NOT_FOUND(2066, "contract_tso_state_not_found"),
    RISK_SET_NOT_FOUND(2067, "risk_set_not_found"),
    RISK_SET_IS_MISSING(2068, "risk_set_is_missing"),
    RISK_FACTOR_HAS_MORE_THAN_2_DECIMAL_PLACES(2069, "risk_factor_has_more_than_2_decimal_places"),
    RISK_SET_CAN_NOT_BE_DELETED_DEFAULT(2070, "risk_set_can_not_be_deleted_default"),
    RISK_SET_CAN_NOT_BE_DELETED_DA(2071, "risk_set_can_not_be_deleted_da"),
    RISK_SET_CAN_NOT_BE_DELETED_PRODUCT(2072, "risk_set_can_not_be_deleted_product"),
    MEMBER_VOLUME_LIMIT_NOT_FOUND(2073, "member_volume_limit_not_found"),
    ONLY_ONE_ATTRIBUTES_MUST_BE_SUPPLIED(2074, "only_one_attributes_must_be_supplied"),
    ATTRIBUTE_CAN_BE_SUPPLIED_ONLY_WITH_OTHER_ATTRIBUTES(2075, "attribute_can_be_supplied_only_with_other_attributes"),
    RISK_SET_NAME_ALREADY_EXISTS(2076, "risk_set_name_already_exists"),
    CASH_LIMIT_INCORRECT_CURRENCY(2077, "cash_limit_incorrect_currency"),
    TIME_ZONE_NOT_ALLOWED(2078, "timezone_not_allowed"),
    RISK_FACTOR_MUST_BE_IN_RANGE(2079, "risk_factor_must_be_in_range"),
    CONTRACT_REFERENCE_CLOSING_PRICE_DATE_NOT_IN_PAST(2080, "contract_reference_closing_price_date_not_in_past"),
    MEMBER_IS_ACTIVE(2081, "member_is_active"),
    MEMBER_SUSPENDED_BY_ECC(2082, "member_is_suspended_ecc"),
    EMS_ACTIVATE_SUSPENDED_MEMBER(2083, "ems_activate_suspended_member"),
    LOCAL_DELIVERY_AREA_CAN_NOT_BE_ASSIGNED_TO_REMOTE_PRODUCT(2084, "local_delivery_area_can_not_be_assigned_to_remote_product"),
    CONTRACT_MISSING_START_DATE(2085, "contract_missing_start_date"),
    CONTRACT_MISSING_END_DATE(2086, "contract_missing_end_date"),
    CONTRACT_END_DATE_MUST_BE_BEFORE_START_DATE(2087, "contract_end_date_must_be_before_start_date"),
    CONTRACT_MAXIMUM_INTERVAL_EXCEEDED(2088, "contract_maximum_interval_exceeded"),
    CONTRACT_MISSING_CONTRACT_ID(2089, "contract_missing_contract_id"),
    PRODUCT_CONCURRENT_MODIFICATION(2090, "product_concurrent_modification"),
    CASH_LIMIT_MAX_VALUE(2091, "cash_limit_max_value"),
    CASH_LIMIT_INCORRECT_CURRENCY_CHANGE(2092, "cash_limit_incorrect_currency_change"),
    EMS_ACTIVATE_DELETED_MEMBER(2093, "ems_activate_deleted_member"),
    EMS_ACTIVATE_ACTIVE_MEMBER(2094, "ems_activate_active_member"),
    ENQ_EVENT_INDEX_NOT_AVAILABLE(2095, "enq_event_index_not_available"),
    PBLC_TRADE_OPT_OUT_REQ(2096, "pblc_trade_opt_out_req_error"),
    PBLC_ORDERBOOK_OPT_OUT_REQ(2097, "pblc_orderbook_opt_out_req_error"),
    CONCURRENT_V6_AND_V7_LOGIN_DISABLED(2098, "concurrent_v6_and_v7_login_disabled"),
    CONTRACT_ALREADY_EXPIRED(3000, "contract_already_expired"),
    TRADE_IS_ALREADY_RECALLED(3001, "trade_is_already_recalled"),
    TRADE_CAN_BE_RECALLED_ON_SOB_ONLY(3029, "trade_can_be_recalled_on_sob_only"),
    TRADE_IS_ALREADY_CANCELLED(3002, "trade_is_already_cancelled"),
    TRADE_CANCEL_REQ_NOT_POSSIBLE_LOCAL_EXCHANGE(3003, "trade_cancel_req_not_possible_local_exchange"),
    RECALL_ALREADY_REJECTED(3004, "recall_already_rejected"),
    RECALL_ALREADY_GRANTED(3005, "recall_already_granted"),
    RECALL_ALREADY_REQUESTED(3006, "recall_already_requested"),
    RECALL_NOT_POSSIBLE_TRADE_DELIVERY_TOO_CLOSE(3007, "recall_not_possible_trade_execution_too_close_to_delivery"),
    RECALL_NOT_POSSIBLE_NO_TURNOVER_QUANTITY(3008, "recall_not_possible_insufficient_quantity"),
    RECALL_NOT_POSSIBLE_AUCTION(3009, "recall_not_possible_auction"),
    RECALL_NOT_POSSIBLE_LEGS_DIFFERENT_STATUS(3010, "recall_not_possible_legs_different_status"),
    TRADE_CANCEL_NOT_REQUESTED(3011, "trade_cancelation_not_requested"),
    CANCEL_NOT_POSSIBLE_LEGS_DIFFERENT_STATUS(3012, "cancel_not_possible_legs_different_status"),
    TRADING_TIME_EXCEEDED(3013, "trading_time_exceeded"),
    CAPACITY_RECALL_FAILED_EXPIRED_GATE_CLOSURE_TIME(3014, "capacity_recall_not_possible_gate_closure_time"),
    CAPACITY_RECALL_FAILED_FOR_TRADE(3015, "capacity_recall_for_trade_failed"),
    CAPACITY_RECALL_FAILED_BECAUSE_OF(3016, "capacity_recall_for_trade_failed_because_of"),
    OTC_CANNOT_BE_RECALLED(3017, "otc_cannot_be_recalled"),
    CANCELATION_OF_TRADE_IN_STATE_NOT_POSSIBLE(3018, "cancellation_of_trade_in_state_not_possible"),
    TRADE_CANCEL_NEGATIVE_LIMIT(3019, "trade_cancel_negative_limit"),
    MIN_OVER_MAX_PRICE(3020, "min_over_max_price"),
    PNC_TRADES_MUST_BE_ENABLED(3021, "pnc_trades_must_be_enabled"),
    TWO_PREARRANGED_ORDER_EXPECTED(3022, "two_prearranged_orders_expected"),
    FEATURE_SETTLEMENT_IS_NOT_ENABLED(3023, "feature_settlement_is_not_enabled"),
    CANCELATION_OF_CROSS_EXCHANGE_TRADE_NOT_POSSIBLE(3024, "cancellation_of_cross_exchange_trade_not_possible"),
    BESPOKE_PRODUCT_CAN_NOT_HAVE_OPT_TRADE(3025, "bespoke_product_can_not_have_opt_trade"),
    CANCELLATION_OF_REMOTE_TRADE_NOT_POSSIBLE(3026, "cancellation_of_remote_trade_not_possible"),
    ILLEGAL_SETTLEMENT_CHANGE_STATE(3027, "illegal_settlement_change_state"),
    ILLEGAL_STATE_NO_SETTLEMENT_FOR_TRADE_AND_VERSION(3028, "illegal_state_no_settlement_for_trade_and_version"),
    USER_IS_SUSPENDED(10000, "user_is_suspended"),
    READONLY_USER_CANNOT_ACCEPT_OTC(10001, "readonly_user_cannot_accept_otc_order"),
    BALANCING_GROUP_SUSPENDED_RECALL_REQUEST(10002, "balancing_group_suspended_recall_request"),
    ACCESS_TO_ACCOUNT_DENIED(10003, "access_to_account_denied"),
    TRADER_IS_NOT_ALLOWED_TO_TRADE_THE_PRODUCT_FOR_THE_BG(10004, "trader_is_not_allowed_to_trade_the_product_for_the_bg"),
    USER_NOT_ACTIVE(10006, "user_is_not_active"),
    USER_DOES_NOT_HAVE_TRADER_ROLE(10007, "user_does_not_have_trader_role"),
    USER_DOES_NOT_HAVE_ADMIN_ROLE(10008, "user_has_no_admin_role"),
    USER_DOES_NOT_HAVE_ANY_MAIN_ROLE(10009, "user_has_no_main_role"),
    ACCESS_DENIED_FOR_DOWNLOAD_USER(10010, "access_denied_for_download_user"),
    USER_IS_DELETED(10011, "user_is_deleted"),
    USER_IS_READONLY(10012, "user_is_readonly"),
    USER_IS_NOT_AUTHENTICATED(10013, "user_is_not_authenticated"),
    READONLY_CANT_ENTER_ORDERS(10014, "readonly_user_cannot_enter_orders"),
    READONLY_CANT_MODIFY_ORDERS(10015, "readonly_user_cannot_modify_orders"),
    READONLY_USER_CANNOT_REJECT_OTC(10016, "readonly_user_cannot_reject_otc_order"),
    READONLY_USER_CANNOT_REQUEST_RECALL(10017, "readonly_user_cannot_request_recall"),
    READONLY_CANT_PERFORM_ORDER_REQUEST(10018, "readonly_user_cannot_perform_order_request"),
    SERVICE_IN_HALT_MODIFY_ORDER(10019, "service_in_halt_modify_order"),
    SERVICE_IN_HALT_ADD_ORDER(10020, "service_in_halt_add_order"),
    SERVICE_IN_HALT_ACTIVATE_ORDER(10021, "service_in_halt_activate_order"),
    TRADER_NOT_ALLOWED_TO_TRADE_PRODUCT_FOR_BG(10022, "trader_is_not_allowed_to_trade_for_balancing_group"),
    TRADER_NOT_ALLOWED_TO_TRADE_ANY_PRODUCT_FOR_BG(10023, "trader_is_not_allowed_to_trade_any_product_for_balancing_group"),
    OPERATION_NOT_SUPPORTED_FOR_TRADERS(10024, "operation_not_supported_for_traders"),
    OPERATION_NOT_SUPPORTED_FOR_BG(10025, "operation_not_supported_for_bg"),
    OPERATION_NOT_SUPPORTED_FOR_MEMBER(10026, "operation_not_supported_for_member"),
    HIBERNATION_POSSIBLE_ONLY_WHEN_MBRID_PROVIDED(10027, "hibernation_possible_only_when_mbrid_provided"),
    TRADER_IS_NOT_ALLOWED_TO_MODIFY_ORDERS_OF_OTHER_MEMBER(10028, "trader_is_not_allowed_to_modify_orders_of_other_member"),
    TRADER_IS_NOT_ALLOWED_TO_MODIFY_ORDERS_OF(10029, "trader_is_not_allowed_to_modify_orders_of"),
    BALANCING_GROUP_NOT_ASSIGNED(10030, "balancing_group_not_assigned"),
    TRADER_CANNOT_REQUEST_FOREIGN_LIMIT(10031, "trader_cannot_request_foreign_limit"),
    USER_CANNOT_MODIFY_OWN_PROFILE(10032, "user_cannot_modify_own_profile"),
    USER_CANNOT_MODIFY_OWN_BG(10033, "user_cannot_modify_own_bg"),
    TRADER_IS_NOT_ALLOWED_TO_ACCESS_PRODUCT(10035, "trader_is_not_allowed_to_access_product"),
    BROKER_ON_BEHALF_OF_BROKER_FROM_THE_SAME_MEMBER(10036, "broker_on_behalf_of_broker_from_the_same_member"),
    BROKER_OWN_TRADING_NOT_ALLOWED(10037, "broker_own_trading_not_allowed"),
    USER_DOES_NOT_HAVE_REQUIRED_ROLE(10038, "user_does_not_have_required_role"),
    TRADER_IS_NOT_ALLOWED_TO_MODIFY_ORDERS_OF_OTHER_TRADER(10039, "trader_is_not_allowed_to_modify_orders_of_other_trader"),
    MAIN_ROLE_CANNOT_BE_MODIFIED_WHEN_USER_NOT_SUSPENDED(10040, "main_role_cannot_be_modified_when_user_not_suspended"),
    TRADER_IS_NOT_ALLOWED_TO_ACCESS_DELIVERY_AREA(10041, "trader_is_not_allowed_to_access_delivery_area"),
    TRADER_IS_NOT_ALLOWED_TO_LOGOUT_OTHER_TRADERS_SESSION(10042, "trader_is_not_allowed_to_logout_other_traders_session"),
    SUPERADMIN_CANNOT_CHANGE_OWN_BG(10043, "superadmin_cannot_change_his_own_balancing_group"),
    NO_REMOTE_ACCOUNT_FOR_PRODUCT_AND_DELIVERY_AREA(10044, "no_remote_account_for_product_and_delivery_area"),
    TRADER_IS_NOT_ALLOWED_TO_ACCESS_PRODUCT_WITH_DA(10045, "trader_is_not_allowed_to_access_product_with_da"),
    MAXIMUM_ACTIVATE_ORDERS_ERROR(12100, "maximum_amount_of_activated_orders"),
    MAXIMUM_REMOVE_ORDERS_ERROR(12101, "maximum_amount_of_removed_orders"),
    MAXIMUM_INACTIVATE_ORDERS_ERROR(12102, "maximum_amount_of_inactivated_orders"),
    ONLY_ONE_ORDER_WITHIN_5_MINUTES(12103, "it_is_allowed_to_submit_one_order_request_within_5_minutes"),
    MAXIMUM_ORDERS_AMOUNT_TO_IMPORT(12104, "maximum_import_order_amount"),
    TRADING_LIMIT_EXCEEDED(12105, "order_refused_trading_limit_exceeded"),
    COMMODITY_LIMIT_EXCEEDED(12106, "order_refused_commodity_limit_exceeded"),
    LIMIT_DISABLED(12207, "limit_disabled"),
    MEMBER_VOLUME_LIMIT_PRODUCT_LIMIT_MAX_QUANTITY(12208, "member_volume_limit_product_limit_max_quantity"),
    MEMBER_VOLUME_LIMIT_MAX_QUANTITY(12209, "member_volume_limit_max_quantity"),
    MEMBER_VOLUME_LIMIT_MAX_AMOUNT(12210, "member_volume_limit_max_amount"),
    MEMBER_VOLUME_LIMIT_PRODUCT_LIMIT_MAX_AMOUNT(12211, "member_volume_limit_product_limit_max_amount"),
    PRODUCT_MAX_AMOUNT_LESS_THEN_ZERO(12212, "product_max_amount_negative"),
    PRODUCT_MAX_AMOUNT_EXCEEDED_MAX_VALUE(12213, "product_max_amount_exceeded_max_value"),
    EXTERNAL_ID_OR_REVISION_IS_MISSING(12107, "external_id_or_revision_is_missing"),
    INCOMING_EXTERNAL_ID_IS_NOT_EQUAL_TO_STORED(12108, "incoming_external_id_is_not_equal_to_stored"),
    INCOMING_EXTERNAL_VERSION_IS_LOWER_THAN_STORED(12109, "incoming_external_version_is_lower_than_stored"),
    INCOMING_EXTERNAL_VERSION_IS_SAME_BUT_CONTENT_IS_DIFFERENT(12110, "incoming_external_version_is_same_but_content_is_different"),
    CASH_LIMIT_FULL_MOD_DIFFERENT_CURRENCY(12111, "cash_limit_full_mod_different_currency"),
    CASH_LIMIT_FULL_MOD_DUPLICATE(12112, "cash_limit_full_mod_duplicate"),
    CASH_LIMIT_AMOUNT_EXCEEDED(12113, "cash_limit_amount_exceeded"),
    CONTRACT_NOT_ACTIVE(12500, "contract_not_active"),
    BALANCING_GROUP_NOT_ACTIVE(12501, "balancing_group_not_active"),
    TRADER_MUST_HAVE_DEFAULT_BG(12502, "trader_must_have_default_bg"),
    DEFAULT_BG_MUST_BE_ASSIGNED(12503, "default_bg_must_be_assigned"),
    EXIST_OPEN_ORDERS_FOR_BG(12504, "exist_open_orders_for_bg"),
    EXIST_USER_ASSIGNMENT_FOR_BG(12505, "exist_user_assignment_for_bg"),
    EXIST_BG_ASSIGNMENT_FOR_MEMBER(12506, "exist_bg_assignment_for_member"),
    EXIST_OPEN_ORDERS_FOR_BG_TRADER(12507, "exist_open_orders_for_bg_and_trader"),
    OPEN_ORDERS_IN_BG_AND_TSO(12508, "open_orders_in_bg_and_tso"),
    MARKET_AREA_DELETE_DELIVERY_AREAS_ASSIGNED(12509, "market_area_cannot_be_deleted_has_delivery_areas_asssigned"),
    DELIVERY_AREA_DELETE_BG_ASSIGNED(12510, "delivery_area_cannot_be_deleted_has_bg_assigned"),
    DELIVERY_AREA_DELETE_PRODUCTS_ASSIGNED(12511, "delivery_area_cannot_be_deleted_has_products_assigned"),
    DELIVERY_AREA_DELETE_ORDERS_ASSIGNED(12512, "delivery_area_cannot_be_deleted_has_orders_assigned"),
    DELIVERY_AREA_DELETE_INTERCONNECTORS_ASSIGNED(12513, "delivery_area_cannot_be_deleted_has_interconnectors_assigned"),
    ASSIGN_MEMBER_TO_BG(12514, "assign_member_to_bg"),
    USER_SHOULD_HAVE_ONE_BG(12515, "user_should_have_one_bg"),
    BG_DOESNT_BELONG_MEMBER(12516, "bg_doesnt_belong_member"),
    ILLEGAL_TSO_TOKEN(12517, "illegal_tso_token"),
    MISSING_TSO_ID(12518, "missing_tso_id"),
    BG_IS_NOT_ASSIGNED_TO_TSO(12519, "bg_is_not_assigned_to_tso"),
    TSO_IS_NOT_ASSIGNED_TO_SELECTED_PRODUCTS(12521, "tso_is_not_assigned_to_selected_products"),
    NO_TSOS_ARE_ASSIGNED_TO_PRODUCT(12522, "no_tsos_are_assigned_to_product"),
    BG_DOESNT_HAVE_CROSS_LEG_ASSIGNED(12525, "bg_doesnt_have_cross_leg_assigned"),
    LOGIN_DETAIL_ARE_NOT_SET(12526, "login_details_are_not_set"),
    LOGIN_DETAIL_INTERFACE_IS_NOT_SET(12527, "login_detail_interface_type_not_set"),
    MARKET_AREA_ALREADY_EXISTS(12528, "market_area_already_exists"),
    DELIVERY_AREA_ALREADY_EXISTS(12529, "delivery_area_already_exists"),
    MEMBER_ALREADY_EXISTS(12530, "member_already_exists"),
    ACCOUNT_ALREADY_EXISTS(12531, "bg_already_exists"),
    USER_HAS_MORE_MAIN_ROLES(12532, "user_has_more_main_roles"),
    USER_HAS_INVALID_SUB_ROLES(12533, "user_has_invalid_sub_roles"),
    RECALL_REQUESTED_BY_UNKNOWN_PARTY(12534, "recall_requested_by_unknown_party"),
    TRADER_ID_NULL_OR_DOES_NOT_MATCH_CURRENT_TRADER(12535, "given_trader_id_is_null_or_does_not_match_current_trader_id"),
    ACTIVATION_NOT_POSSIBLE_FOR_ACTIVE_PRODUCT(12536, "activation_not_possible_for_active_product"),
    DEACTIVATION_NOT_POSSIBLE_PRODUCT_NOT_ACTIVE(12537, "deactivation_not_possible_product_not_active"),
    ACTIVE_PRODUCT_NOT_MODIFIABLE(12538, "active_product_not_modifiable"),
    INVALID_CONTRACT_TIMES(12539, "invalid_contract_times"),
    CONTRACT_NOT_ACTIVE_FOR_TSO(12540, "contract_not_active_for_tso"),
    INVALID_CLEARING_HOUSES(12541, "invalid_clearing_houses"),
    CLEARING_HOUSE_EXISTS(12542, "clearing_house_exists"),
    CLEARING_ACCOUNT_EXISTS(12543, "clearing_account_exists"),
    CLEARING_ACCOUNT_NOT_ASSIGNED(12544, "clearing_account_not_assigned"),
    CLEARING_ACCOUNT_NOT_FOUND(12545, "clearing_account_not_found"),
    INACTIVE_CLEARING_ACCOUNT(12546, "inactive_clearing_account"),
    CONTRACT_EXPIRATION_TIME_IS_NULL(12547, "contract_expiration_time_is_null_for_contract"),
    CONTRACT_OR_DELIVERY_AREA_NOT_ACTIVE(12551, "contract_or_delivery_area_not_active"),
    MEMBER_ID_MISSING(12552, "member_id_missing"),
    BALANCING_GROUP_CODE_MISSING(12553, "balancing_group_code_missing"),
    BALANCING_GROUP_NOT_ASSIGNED_TO_PRODUCT(12554, "balancing_group_not_assigned_to_product"),
    TSO_NOT_ASSIGNED_TO_PRODUCT(12555, "tso_not_assigned_to_product"),
    WRONG_MIN_MAX_QUANTITY(12556, "wrong_min_max_quantity"),
    ORDERBOOK_NOT_AVAILABLE_FOR_CONTRACT(12557, "orderbook_not_available_for_contract"),
    BLOCK_ORDERBOOK_NOT_AVAILABLE_FOR_PRODUCT(12558, "block_orderbook_not_available_for_product"),
    INVALID_MARKET_AREA_ID(12559, "invalid_market_area_id"),
    USER_ASSIGNMENT_DOES_NOT_EXIST_FOR_MEMBER(12560, "user_assignment_does_not_exist_for_member"),
    INVALID_ASSIGNMENT_LOCAL_CLEARING_REMOTE_PRODUCT(12561, "invalid_assignment_local_clearing_remote_product"),
    INVALID_ASSIGNMENT_BROKER_OWN_BG_WITHOUT_OWN_TRADING(12562, "invalid_assignment_broker_own_bg_without_own_trading"),
    CANNOT_FIND_CAPACITY_BORDER_FOR(12563, "cannot_find_capacity_border_for"),
    UNABLE_TO_UPDATE_BORDER_MARKET_AREA_DOES_NOT_EXIST(12564, "unable_to_update_border_market_area_does_not_exist"),
    UNABLE_TO_UPDATE_DELIVERY_AREA_PARENT_DELIVERY_AREA_DOES_NOT_EXIST(12565, "unable_to_update_delivery_area_parent_delivery_area_does_not_exist"),
    UNABLE_TO_UPDATE_DELIVERY_AREA_PARENT_MARKET_AREA_DOES_NOT_EXIST(12566, "unable_to_update_delivery_area_parent_market_area_does_not_exist"),
    UNABLE_TO_UPDATE_INTERCONNECTOR_DELIVERY_AREA_DOES_NOT_EXIST(12567, "unable_to_update_interconnector_delivery_area_does_not_exist"),
    UNABLE_TO_UPDATE_INTERCONNECTOR_BORDER_DOES_NOT_EXIST(12568, "unable_to_update_interconnector_border_does_not_exist"),
    DISPUTE_2_DIFFERENT_EXCHANGES(12569, "dispute_2_different_exchanges"),
    DISPUTE_2_DIFFERENT_DELIVERY_AREAS(12570, "dispute_2_different_delivery_areas"),
    RACF_ALREADY_ASSIGNED(12571, "racf_already_assigned"),
    CANNOT_MODIFY_DELETED_USER(12572, "cannot_modify_deleted_user"),
    MORE_RACF_ASSIGNED_TO_USER(12573, "more_racf_assigned_to_user"),
    USER_CODE_ALREADY_EXISTS_FOR_MEMBER(12574, "user_code_already_exists_for_member"),
    USER_CODE_MUST_NOT_BE_CHANGED(12575, "user_code_must_not_be_changed"),
    CANNOT_ASSIGN_READONLY_ROLE_USER_HASOPEN_ORDERS(12576, "cannot_assign_readonly_role_user_hasopen_orders"),
    CANNOT_CREATE_ADMIN_FOR_NON_ADMIN_MEMBER(12578, "cannot_create_admin_for_non_admin_member"),
    CANNOT_CREATE_NON_ADMIN_FOR_ADMIN_MEMBER(12579, "cannot_create_non_admin_for_admin_member"),
    CONCURRENT_UPDATE(12580, "concurrent_update"),
    LOCAL_SCHEDULE_MUST_FIT_INTO_REMOTE_SCHEDULE(12581, "local_schedule_must_fit_into_remote_schedule"),
    CANNOT_ASSIGN_BROKER_MEMBER(12582, "cannot_assign_broker_member"),
    CANNOT_ASSIGN_MEMBERS_TO_NONBROKER_BG(12583, "cannot_assign_member_to_non_broker_bg"),
    MEMBER_IS_ASSIGNED_TO_BROKER_CANNOT_BE_BROKER(12584, "member_is_assigned_to_broker_cannot_be_broker"),
    BROKER_MEMBER_HAS_ASSIGNMENT_CANNOT_CHANGE_TO_REGULAR(12585, "member_has_assignments_cannot_be_regular"),
    BROKER_MEMBER_HAS_BROKER_TRADER_CANNOT_CHANGE_TO_REGULAR(12586, "member_has_broker_traders_cannot_be_regular"),
    TRADER_CANNOT_BE_BROKER_IF_MEMBER_IS_REGULAR(12587, "trader_cannot_be_broker_if_member_is_regular"),
    TRADER_MUST_BE_BROKER_IF_MEMBER_IS_BROKER(12588, "trader_must_be_broker_if_member_is_broker"),
    TRADING_SCHEDULE_NAME_MUST_BE_UNIQUE(12589, "trading_schedule_name_must_be_unique"),
    INVALID_BESPOKE_CONTRACT_REQUEST(12590, "invalid_bespoke_contract_request"),
    INVALID_BESPOKE_PRODUCT_FOR_CONTRACT_REQUEST(12591, "invalid_bespoke_product_for_contract_request"),
    INVALID_MEMBER_OF_PRODUCT_FOR_BESPOKE_CONTRACT_REQ(12592, "invalid_member_of_product_for_bespoke_contract_req"),
    BESPOKE_CONTRACT_ALREADY_EXISTS(12593, "bespoke_contract_already_exists"),
    BESPOKE_CONTRACT_CANNOT_BE_UNDERLYING_CONTRACT(12594, "bespoke_contract_cannot_be_underlying_contract"),
    ONLY_ACTIVE_CONTRACT_CAN_BE_UNDERLYING_CONTRACT(12595, "only_active_contract_can_be_underlying_contract"),
    BESPOKE_CONTRACT_SUPPORTS_ONLY_SINGLE_UNDERLYING_PRODUCT(12596, "bespoke_contract_supports_only_single_underlying_product"),
    CLEARING_ACCOUNT_ACTIVATION_NOT_POSSIBLE_INACTIVE_CLEARING_HOUSE(12597, "clearing_account_activation_not_possible_inactive_clearing_house"),
    CLEARING_ACCOUNT_DEACTIVATION_ERROR_FAILED_ORDERS(12598, "clearing_account_deactivation_error_failed_orders"),
    CONCURRENT_PRODUCT_ACCESS(12599, "concurrent_product_access"),
    OPEN_ORDER_FOR_CLEARINGACCOUNT(12600, "open_orders_for_product_ca"),
    BG_MEMBER_CANNOT_BE_CHANGED(12601, "bg_member_cannot_be_changed"),
    DATA_VENDOR_MUST_HAVE_ONLY_ONE_BG(12602, "data_vendor_must_have_only_one_bg"),
    DATA_VENDOR_ONLY_AMONG_OTHER_DV(12603, "data_vendor_only_among_other_dv"),
    DELIVERY_AREA_MISSING_EIC_CODE(12604, "delivery_area_missing_eic_code"),
    DELIVERY_AREA_MISSING_SHORT_NAME(12605, "delivery_area_missing_short_name"),
    DELIVERY_AREA_MISSING_LONG_NAME(12606, "delivery_area_missing_long_name"),
    DELIVERY_AREA_DELETE_DELIVERY_AREAS_ASSIGNED(12607, "delivery_area_delete_delivery_areas_assigned"),
    DELIVERY_AREA_SHORT_NAME_TOO_LONG(12608, "delivery_area_short_name_too_long"),
    DELIVERY_AREA_LONG_NAME_TOO_LONG(12609, "delivery_area_long_name_too_long"),
    OPERATION_NOT_SUPPORTED(12610, "operation_not_supported"),
    MARKET_AREA_SHORT_NAME_TOO_LONG(12611, "market_area_short_name_too_long"),
    MARKET_AREA_LONG_NAME_TOO_LONG(12612, "market_area_long_name_too_long"),
    CANNOT_CREATE_ANOTHER_REPORTING_USER_FOR_MEMBER(12613, "cannot_create_another_reporting_user_for_member"),
    UNABLE_TO_DETECT_TRADING_REQUEST_LIMITS(12614, "unable_to_detect_trading_request_limits"),
    INVALID_CONTRACT_ID(12615, "invalid_contract_id"),
    NO_CLEARING_ACCOUNT_ASSIGNMENT(12616, "no_clearing_account_assignments"),
    NEW_PASSWORD_HAS_TO_BE_DIFFERENT_FROM_OLD_ONE(12617, "new_password_has_to_be_different_from_old_one"),
    NEW_AND_OLD_PASSWORDS_HAVE_TO_BE_SPECIFIED(12618, "new_and_old_passwords_have_to_be_specified"),
    TSO_CAN_NOT_LOADED(12619, "tso_can_not_loaded"),
    ERROR_GETTING_ORDERS_FOR_TSO(12620, "error_getting_orders_for_tso"),
    INVALID_PPD_DIFFERENT_FROM_TICK_SIZE(12621, "invalid_ppd_different_from_tick_size"),
    PRODUCT_ALREADY_EXISTS(12623, "product_already_exists"),
    CLEARING_ACCOUNT_NAME_CANNOT_BE_EMPTY(12629, "clearing_account_name_cannot_be_empty"),
    CLEARING_ACCOUNT_NAME_EXCEEDS_LENGTH(12630, "clearing_account_name_exceeds_length"),
    CLEARING_ACCOUNTS_DISABLED(12631, "clearing_accounts_disabled"),
    MEMBER_ID_INVALID(12632, "member_id_invalid"),
    EITHER_BOTH_OR_NONE_CROSS_LEGS_MUST_BE_PRESENT(12633, "either_both_or_none_cross_legs_must_be_present"),
    EXCHANGE_DISPUTES_DISABLED(12634, "exchange_disputes_disabled"),
    EXCHANGE_MARKET_SHORT_NAME_INVALID(12635, "exchange_market_short_name_invalid"),
    EXCHANGE_MARKET_SHORT_NAME_EXCEEDS_LENGTH(12636, "exchange_market_short_name_exceeds_length"),
    EXCHANGE_MARKET_LONG_NAME_INVALID(12637, "exchange_market_long_name_invalid"),
    EXCHANGE_MARKET_LONG_NAME_EXCEEDS_LENGTH(12638, "exchange_market_long_name_exceeds_length"),
    EXCHANGE_MARKET_MISSING_MEMBER(12639, "exchange_market_missing_member"),
    EXCHANGE_MARKET_MISSING_MEMBER_ID(12640, "exchange_market_missing_member_id"),
    EXCHANGE_MARKET_CANT_CHANGE_MEMBER_ID(12641, "exchange_market_cant_change_member_id"),
    EXCHANGE_MARKET_MISSING_ID(12642, "exchange_market_missing_id"),
    EXCHANGE_MARKET_EXISTS(12643, "exchange_market_exists"),
    EXCHANGE_MARKET_NOT_EXISTS(12644, "exchange_market_not_exists"),
    EXCHANGE_MARKET_DELETED(12645, "exchange_market_deleted"),
    EXCHANGE_MARKET_CONTAINS_DISPUTE(12646, "exchange_market_contains_dispute"),
    EXCHANGE_MARKET_DISPUTE_INVALID(12647, "exchange_market_dispute_invalid"),
    EXCHANGE_MARKET_DISPUTE_EXIST(12648, "exchange_market_dispute_exist"),
    EXCHANGE_MARKET_DISPUTE_NOT_EXIST(12649, "exchange_market_dispute_not_exist"),
    PASSWORD_CHANGE_ERROR(12650, "password_change_error"),
    PASSWORD_CREATE_ERROR(12651, "password_create_error"),
    PRODUCT_NAME_CANNOT_BE_EMPTY(12652, "product_name_cannot_be_empty"),
    BALANCING_GROUP_NOT_EDITABLE(12653, "balancing_group_not_editable"),
    FEATURE_BROKER_NOT_ENABLED(12654, "feature_broker_not_enabled"),
    TRADING_SCHEDULE_HAS_ALREADY_CONTRACTS(12655, "trading_schedule_has_already_contracts"),
    TRADING_SCHEDULE_HAS_NO_TRADING_DAY(12656, "trading_schedule_has_no_trading_day"),
    TRADING_SCHEDULE_PRODUCT_ASSIGNED(12657, "products_assigned_to_schedule"),
    CLEARING_HOUSE_DEACTIVATION_ERROR_FAILED_ORDERS(12658, "clearing_house_deactivation_error_failed_orders"),
    CROSS_LEG_NOT_FOUND(12659, "invalid_cross_leg"),
    INVALID_INTERVAL_ENDDATE_BEFORE_STARTDATE(12660, "invalid_interval_enddate_before_startdate"),
    VALIDATOR_REQUEST_UNSUPPORTED_CONTENT(12661, "validator_request_unsupported_content"),
    VALIDATOR_ALL_UNSUPPORTED_MESSAGE_TYPE(12662, "validator_all_unsupported_message_type"),
    CANNOT_ACTIVATE_PRODUCT_BASE_IS_INACTIVE(12663, "cannot_activate_product_base_is_inactive"),
    CANNOT_ACTIVATE_CONTRACT_UNDERLYING_CONTRACT_INACTIVE(12664, "cannot_activate_contract_underlying_contract_inactive"),
    PRODUCT_REF_DONT_EXIST_IN_POOL(12665, "product_ref_dont_exist_in_pool"),
    SUBSCRIBER_NOT_FOUND(12666, "subscriber_not_found"),
    TRADING_SCHEDULE_PHASES_MUST_START_WITH_CLOSED(12667, "trading_schedule_phases_must_start_with_closed"),
    TRADING_SCHEDULE_NAME_NOT_MODIFIABLE(12668, "trading_schedule_name_not_modifiable"),
    NO_SOB_SESSION(12669, "no_sob_session"),
    CLEARING_ACCOUNT_NOT_FOUND_FOR_BG(12670, "clearing_account_not_found_for_bg"),
    PRODUCT_ILLEGAL_DELIVERY_START_REFERENCE(12671, "product_illegal_delivery_start_reference"),
    PRODUCT_ILLEGAL_DELIVERY_PERIOD(12672, "product_illegal_delivery_period"),
    PRODUCT_ILLEGAL_GAP_BETWEEN_CONTRACTS(12673, "product_illegal_gap_between_contracts"),
    PRODUCT_MINIMUM_QUANTITY_LOWER_THAN_IC_CAPACITY_RESOLUTION(12674, "product_minimum_capacity_lower_than_ic_capacity_resolution"),
    PRODUCT_MIN_QUANTITY_NOT_DIVISIBLE_BY_IC_CAPACITY_RESOLUTION(12675, "product_min_quantity_not_divisible_by_ic_capacity_resolution"),
    DELIVERY_AREA_MUST_BE_HALTED_WHEN_BEING_MODIFIED(12676, "delivery_area_must_be_halted_when_being_modified"),
    MEMBER_ASSIGNED_TO_EXCHANGE_MARKET(12677, "member_assigned_to_exchange_market"),
    CANNOT_CREATE_HOLIDAY_ALREADY_EXISTING(12678, "cannot_create_holiday_already_existing"),
    CANNOT_CREATE_HOLIDAY_WITHOUT_NAME(12679, "cannot_create_holiday_without_name"),
    CANNOT_CREATE_HOLIDAY_WITHOUT_MARKET_AREA(12680, "cannot_create_holiday_without_market_area"),
    CANNOT_CREATE_HOLIDAY_WITH_DAY_NOT_IN_SPECIFIED_YEAR(12681, "cannot_create_holiday_with_day_not_in_specified_year"),
    CANNOT_CREATE_HOLIDAY_WHEN_TRADING_CALENDAR_DISABLED(12682, "cannot_create_holiday_when_trading_calendar_disabled"),
    HOLIDAY_NOT_FOUND(12683, "holiday_not_found"),
    CANNOT_DELETE_HOLIDAY_WHEN_TRADING_CALENDAR_DISABLED(12684, "cannot_delete_holiday_when_trading_calendar_disabled"),
    CANNOT_CHANGE_REMOTE_TRADER_WITH_THE_SAME(12686, "cannot_change_remote_trader_with_the_same"),
    USER_HAS_NOT_DESIRED_PRIVILEGES_TO_CONNECT_SOB(12687, "user_has_no_desired_privileges_to_connect_sob"),
    UNABLE_TO_CONNECT_TO_SOB(12688, "unable_to_connect_to_sob"),
    MEMBER_VOLUME_LIMIT_ALREADY_EXISTS(12689, "member_volume_limit_already_exists"),
    DELIVERY_AREA_AUTOSYNC_CANNOT_BE_ENABLED_FOR_LOCAL_DELIVERY_AREA(12690, "delivery_area_autosync_cannot_be_enabled_for_local_delivery_area"),
    DELIVERY_AREA_STATE_CANNOT_BE_MODIFIED_WITH_AUTOSYNC_ENABLED(12691, "delivery_area_state_cannot_be_modified_with_autosync_enabled"),
    LINKED_PRODUCT_CAN_NO_BE_CREATED_MORE_THEN_ONE_FOR_SAME_PRODUCT(12692, "linked_product_can_no_be_created_more_then_one_for_same_product"),
    LINKED_PRODUCT_ATTRIBUTE_IS_NOT_MODIFIABLE(12693, "linked_product_attribute_is_not_modifiable"),
    LINKED_PRODUCT_CAN_NOT_BE_CREATED_WITH_BASE_REFERENCE(12694, "linked_product_can_not_be_created_with_base_reference"),
    LINKED_PRODUCT_ALLOWED_PRODUCT_TYPE(12695, "linked_product_allowed_product_type"),
    LINKED_PRODUCT_CAN_BE_CREATED_ONLY_FOR_REMOTE_PRODUCT(12696, "linked_product_can_be_created_only_for_remote_product"),
    LINKED_PRODUCT_ASSIGN_INVALID_TRADING_SCHEDULE(12697, "linked_product_assign_invalid_trading_schedule"),
    LINKED_PRODUCT_ASSIGN_REMOTE_TRADING_SCHEDULE(12698, "linked_product_assign_remote_trading_schedule"),
    PRODUCT_MUST_HAVE_CORRECT_EXCHANGE(12699, "product_must_have_correct_exchange"),
    DELIVERY_AREA_DELETE_NOT_HALT(12700, "delivery_area_delete_not_halt"),
    REMOTE_PRODUCT_DEFAULT_SCHEDULE_CANNOT_BE_OVERRIDDEN(12701, "remote_product_default_schedule_cannot_be_overridden"),
    REMOTE_PRODUCT_DELIVERY_AREA_SCHEDULE_CAN_BE_OVERRIDDEN_BY_LOCAL_SCHEDULE_ONLY(12702, "remote_product_delivery_area_schedule_can_be_overridden_by_local_schedule_only"),
    LOCAL_PRODUCT_CAN_HAVE_ONLY_LOCAL_SCHEDULE(12703, "local_product_can_have_only_local_schedule"),
    CROSS_PRODUCT_DELIVERY_AREA_NOT_ASSIGNED_TO_LEGS(12704, "cross_product_delivery_area_not_assigned_to_legs"),
    DELIVERY_AREA_DELETE_IS_ASSIGNED_TO_PRODUCT(12706, "delivery_area_delete_is_assigned_to_product"),
    DELIVERY_AREA_DELETE_IS_ASSIGNED_TO_BALANCING_GROUP(12707, "delivery_area_delete_is_assigned_to_balancing_group"),
    BALANCING_GROUP_EIC_IS_NOT_UNQUE_IN_FIRST_16_CHAR(12708, "balancing_group_eic_is_not_unque_in_first_16_char"),
    MODIFYING_REMOTE_PRODUCT_WHILE_DISCONNECTED(12709, "modifying_remote_product_while_disconnected"),
    BALANCING_GROUP_CROSS_PRODUCT_SPREADS_REQUIRED(12710, "balancing_group_cross_product_spreads_required"),
    INVALID_BESPOKE_CONTRACT_NAME(12711, "invalid_bespoke_contract_name"),
    UDDP_PRODUCT_CAN_HAVE_ONLY_DLVR_AREA_FROM_BASE_PROD(12712, "uddp_product_can_have_only_dlvr_area_from_base_prod"),
    REMOTE_PRODUCT_CAN_NOT_HAVE_LOCAL_SCHEDULE_WITH_SDAT_PHASE(12713, "remote_product_can_not_have_local_schedule_with_sdat_phase"),
    PASSWORD_CHANGE_CONSTRAINT_VIOLATION(12714, "password_change_constraint_violation"),
    ACTIVATION_NOT_POSSIBLE_FOR_LINKED_PRODUCT_WITHOUT_MASTER(12715, "activation_not_possible_for_linked_product_without_master"),
    NOT_POSSIBLE_TO_DELETE_ACTIVE_LINKED_PRODUCT(12716, "not_possible_to_delete_active_linked_product"),
    CAN_NOT_GENERATE_CONTRACTS_INVALID_PRODUCT_CONFIGURATION(12717, "can_not_generate_contracts_invalid_product_configuration"),
    PRODUCTS_NOT_EXISTING_OR_NOT_ASSIGNED(12718, "products_not_existing_or_not_assigned"),
    TRADER_ASSIGN_BG_WITH_DATA_VENDOR(12719, "trader_assign_bg_with_data_vendor"),
    LOCATIONS_NOT_SUPPORTED(12720, "location_not_supported"),
    INVALID_LOCATION(12721, "location_is_invalid"),
    PASSWORD_NOT_MATCHED(12722, "password_does_not_match"),
    INVALID_INTERVAL_TOO_LONG(12723, "invalid_interval_too_long"),
    TECHNICAL_ERROR_CANNOT_MARSHALL_RESPONSE(12724, "technical_error_cannot_marshall_response"),
    VALIDATION_ERROR_WITH_MESSAGE(12725, "validation_error_with_message"),
    INVALID_MARKET_BASED_ATTRIBUTE(12726, "market_based_attribute_is_invalid"),
    INVALID_CONTRACT_REFERENCE_ATTRIBUTE(12727, "contract_reference_attribute_is_invalid"),
    INVALID_FACILITY_TYPE_ATTRIBUTE(12728, "facility_type_attribute_is_invalid"),
    INVALID_USAGE_FRACTION_ATTRIBUTE(12729, "usage_fraction_attribute_is_invalid"),
    LOCATION_ATTRIBUTE_NOT_SUPPORTED(12730, "location_attribute_not_supported"),
    HUBTOHUB_GENERAL_ERROR(50001, "hubtohub_general_error"),
    HUBTOHUB_INVALID_DELIVERY_AREA(50002, "hubtohub_invalid_delivery_area"),
    HUBTOHUB_INVALID_DATE(50003, "hubtohub_invalid_date"),
    HUBTOHUB_INVALID_ATTRIBUTE(50004, "hubtohub_invalid_attribute"),
    HUBTOHUB_MISSING_ATTRIBUTE(50005, "hubtohub_missing_attribute"),
    FEATURE_DELIVERY_RISK_APPLIED_ON_MEMBER_NOT_ENABLED(50006, "feature_delivery_risk_applied_on_member_not_enabled");

    private final String text;
    private final int errorCode;

    private ErrorCodeAndKey(int errorCode, String text) {
        this.text = text;
        this.errorCode = errorCode;
    }

    public static Optional<ErrorCodeAndKey> of(int errorCode) {
        if (errorCode != 0) {
            for (ErrorCodeAndKey codeAndKey : ErrorCodeAndKey.values()) {
                if (codeAndKey.errorCode != errorCode) continue;
                return Optional.of(codeAndKey);
            }
        }
        return Optional.empty();
    }

    public String getText() {
        return this.text;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

