/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api.type;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum ProductType implements Serializable
{
    COMMODITY("COM", true),
    CROSS("CRO", true),
    ENERGY("ENG", true),
    FUTURES("FUT", true),
    USER_DEFINED_DELIVERY("UDD", true);

    private final String value;
    private final boolean visible;
    private static final Map<String, ProductType> MAP;

    public static ProductType[] visibleValues() {
        return (ProductType[])Arrays.asList(ProductType.values()).stream().filter(ProductType::isVisible).toArray(ProductType[]::new);
    }

    private ProductType(String value, boolean visible) {
        this.value = value;
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getValue() {
        return this.value;
    }

    public String getI18nKey() {
        return "product_" + this.name().toLowerCase();
    }

    public static ProductType getDefault() {
        return ENERGY;
    }

    public static ProductType getType(String type) {
        ProductType productType = MAP.get(type);
        if (productType == null) {
            throw new IllegalArgumentException("No ProductType \"" + type + "\"");
        }
        return productType;
    }

    static {
        MAP = new HashMap<String, ProductType>();
        for (ProductType productType : ProductType.values()) {
            ProductType prev = MAP.put(productType.getValue(), productType);
            if (prev == null) continue;
            throw new IllegalStateException("Duplicate key for ProductType: " + productType.getValue());
        }
    }
}

